/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.MapMaker;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.storage.AnvilSaveHandler;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.util.file.CopyFileVisitor;
import org.spongepowered.api.util.file.DeleteFileVisitor;
import org.spongepowered.api.util.file.ForwardingFileVisitor;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.interfaces.IMixinIntegratedServer;
import org.spongepowered.common.interfaces.IMixinMinecraftServer;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.world.IMixinDimensionType;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.IMixinWorldSettings;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.WorldMigrator;

public final class WorldManager {
    private static final DirectoryStream.Filter<Path> LEVEL_AND_SPONGE = entry -> Files.isDirectory(entry, new LinkOption[0]) && Files.exists(entry.resolve("level.dat"), new LinkOption[0]) && Files.exists(entry.resolve("level_sponge.dat"), new LinkOption[0]);
    private static final Int2ObjectMap<DimensionType> dimensionTypeByTypeId = new Int2ObjectOpenHashMap(3);
    private static final Int2ObjectMap<DimensionType> dimensionTypeByDimensionId = new Int2ObjectOpenHashMap(3);
    private static final Int2ObjectMap<Path> dimensionPathByDimensionId = new Int2ObjectOpenHashMap(3);
    private static final Int2ObjectOpenHashMap<WorldServer> worldByDimensionId = new Int2ObjectOpenHashMap(3);
    private static final Map<String, WorldProperties> worldPropertiesByFolderName = new HashMap<String, WorldProperties>(3);
    private static final Map<UUID, WorldProperties> worldPropertiesByWorldUuid = new HashMap<UUID, WorldProperties>(3);
    private static final Map<Integer, String> worldFolderByDimensionId = new HashMap<Integer, String>();
    private static final BiMap<String, UUID> worldUuidByFolderName = HashBiMap.create((int)3);
    private static final BitSet dimensionBits = new BitSet(1024);
    private static final Map<WorldServer, WorldServer> weakWorldByWorld = new MapMaker().weakKeys().weakValues().concurrencyLevel(1).makeMap();
    private static final Queue<WorldServer> unloadQueue = new ArrayDeque<WorldServer>();
    private static final Comparator<WorldServer> WORLD_SERVER_COMPARATOR = (world1, world2) -> {
        Integer world1DimId = ((IMixinWorldServer)world1).getDimensionId();
        if (world2 == null) {
            return world1DimId;
        }
        Integer world2DimId = ((IMixinWorldServer)world2).getDimensionId();
        return world1DimId - world2DimId;
    };
    private static boolean isVanillaRegistered = false;

    public static void registerVanillaTypesAndDimensions() {
        if (!isVanillaRegistered) {
            WorldManager.registerDimensionType(0, DimensionType.OVERWORLD);
            WorldManager.registerDimensionType(-1, DimensionType.NETHER);
            WorldManager.registerDimensionType(1, DimensionType.THE_END);
            WorldManager.registerDimension(0, DimensionType.OVERWORLD);
            WorldManager.registerDimension(-1, DimensionType.NETHER);
            WorldManager.registerDimension(1, DimensionType.THE_END);
        }
        isVanillaRegistered = true;
    }

    public static void registerDimensionType(DimensionType type) {
        Preconditions.checkNotNull((Object)type);
        Optional<Integer> optNextDimensionTypeId = WorldManager.getNextFreeDimensionTypeId();
        optNextDimensionTypeId.ifPresent(integer -> WorldManager.registerDimensionType(integer, type));
    }

    public static void registerDimensionType(int dimensionTypeId, DimensionType type) {
        Preconditions.checkNotNull((Object)type);
        if (dimensionTypeByTypeId.containsKey(dimensionTypeId)) {
            return;
        }
        dimensionTypeByTypeId.put(dimensionTypeId, (Object)type);
    }

    private static Optional<Integer> getNextFreeDimensionTypeId() {
        Integer highestDimensionTypeId = null;
        for (Integer dimensionTypeId : dimensionTypeByTypeId.keySet()) {
            if (highestDimensionTypeId != null && highestDimensionTypeId >= dimensionTypeId) continue;
            highestDimensionTypeId = dimensionTypeId;
        }
        if (highestDimensionTypeId != null && highestDimensionTypeId < 127) {
            highestDimensionTypeId = highestDimensionTypeId + 1;
            return Optional.of(highestDimensionTypeId);
        }
        return Optional.empty();
    }

    public static Integer getNextFreeDimensionId() {
        return dimensionBits.nextClearBit(0);
    }

    public static void registerDimension(int dimensionId, DimensionType type) {
        Preconditions.checkNotNull((Object)type);
        if (!dimensionTypeByTypeId.containsValue((Object)type)) {
            return;
        }
        if (dimensionTypeByDimensionId.containsKey(dimensionId)) {
            return;
        }
        dimensionTypeByDimensionId.put(dimensionId, (Object)type);
        if (dimensionId >= 0) {
            dimensionBits.set(dimensionId);
        }
    }

    public static void unregisterDimension(int dimensionId) {
        if (!dimensionTypeByDimensionId.containsKey(dimensionId)) {
            throw new IllegalArgumentException("Failed to unregister dimension [" + dimensionId + "] as it is not registered!");
        }
        dimensionTypeByDimensionId.remove(dimensionId);
    }

    private static void registerVanillaDimensionPaths(Path savePath) {
        WorldManager.registerDimensionPath(0, savePath);
        WorldManager.registerDimensionPath(-1, savePath.resolve("DIM-1"));
        WorldManager.registerDimensionPath(1, savePath.resolve("DIM1"));
    }

    public static void registerDimensionPath(int dimensionId, Path dimensionDataRoot) {
        Preconditions.checkNotNull((Object)dimensionDataRoot);
        dimensionPathByDimensionId.put(dimensionId, (Object)dimensionDataRoot);
    }

    public static Path getDimensionPath(int dimensionId) {
        return (Path)dimensionPathByDimensionId.get(dimensionId);
    }

    public static Optional<DimensionType> getDimensionType(int dimensionId) {
        return Optional.ofNullable(dimensionTypeByDimensionId.get(dimensionId));
    }

    public static Optional<DimensionType> getDimensionTypeByTypeId(int dimensionTypeId) {
        return Optional.ofNullable(dimensionTypeByTypeId.get(dimensionTypeId));
    }

    public static Optional<DimensionType> getDimensionType(Class<? extends WorldProvider> providerClass) {
        Preconditions.checkNotNull(providerClass);
        for (Object rawDimensionType : dimensionTypeByTypeId.values()) {
            DimensionType dimensionType = (DimensionType)rawDimensionType;
            if (!((org.spongepowered.api.world.DimensionType)dimensionType).getDimensionClass().equals(providerClass)) continue;
            return Optional.of(dimensionType);
        }
        return Optional.empty();
    }

    public static Collection<DimensionType> getDimensionTypes() {
        return dimensionTypeByTypeId.values();
    }

    public static int[] getRegisteredDimensionIdsFor(DimensionType type) {
        return dimensionTypeByDimensionId.int2ObjectEntrySet().stream().filter(entry -> entry.getValue() == type).mapToInt(Int2ObjectMap.Entry::getIntKey).toArray();
    }

    public static int[] getRegisteredDimensionIds() {
        return dimensionTypeByDimensionId.keySet().toIntArray();
    }

    @Nullable
    private static Path getWorldFolder(DimensionType dimensionType, int dimensionId) {
        return (Path)dimensionPathByDimensionId.get(dimensionId);
    }

    public static boolean isDimensionRegistered(int dimensionId) {
        return dimensionTypeByDimensionId.containsKey(dimensionId);
    }

    private static Map<Integer, DimensionType> sortedDimensionMap() {
        Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap(dimensionTypeByDimensionId);
        LinkedHashMap<Integer, DimensionType> newMap = new LinkedHashMap<Integer, DimensionType>();
        newMap.put(0, (DimensionType)copy.remove(0));
        newMap.put(-1, (DimensionType)copy.remove(-1));
        newMap.put(1, (DimensionType)copy.remove(1));
        int[] ids = copy.keySet().toIntArray();
        Arrays.sort(ids);
        for (int id : ids) {
            newMap.put(id, (DimensionType)copy.get(id));
        }
        return newMap;
    }

    public static ObjectIterator<Int2ObjectMap.Entry<WorldServer>> worldsIterator() {
        return worldByDimensionId.int2ObjectEntrySet().fastIterator();
    }

    public static Collection<WorldServer> getWorlds() {
        return worldByDimensionId.values();
    }

    public static Optional<WorldServer> getWorldByDimensionId(int dimensionId) {
        return Optional.ofNullable(worldByDimensionId.get(dimensionId));
    }

    public static Optional<String> getWorldFolderByDimensionId(int dimensionId) {
        return Optional.ofNullable(worldFolderByDimensionId.get(dimensionId));
    }

    public static int[] getLoadedWorldDimensionIds() {
        return worldByDimensionId.keySet().toIntArray();
    }

    public static Optional<WorldServer> getWorld(String worldName) {
        for (WorldServer worldServer : WorldManager.getWorlds()) {
            World apiWorld = (World)worldServer;
            if (!apiWorld.getName().equals(worldName)) continue;
            return Optional.of(worldServer);
        }
        return Optional.empty();
    }

    private static void registerWorldProperties(WorldProperties properties) {
        Preconditions.checkNotNull((Object)properties);
        worldPropertiesByFolderName.put(properties.getWorldName(), properties);
        worldPropertiesByWorldUuid.put(properties.getUniqueId(), properties);
        worldUuidByFolderName.put((Object)properties.getWorldName(), (Object)properties.getUniqueId());
        worldFolderByDimensionId.put(((IMixinWorldInfo)((Object)properties)).getDimensionId(), properties.getWorldName());
    }

    public static void unregisterWorldProperties(WorldProperties properties, boolean freeDimensionId) {
        Preconditions.checkNotNull((Object)properties);
        worldPropertiesByFolderName.remove(properties.getWorldName());
        worldPropertiesByWorldUuid.remove(properties.getUniqueId());
        worldUuidByFolderName.remove((Object)properties.getWorldName());
        worldFolderByDimensionId.remove(((IMixinWorldInfo)((Object)properties)).getDimensionId());
        if (((IMixinWorldInfo)((Object)properties)).getDimensionId() != null && freeDimensionId) {
            dimensionBits.clear(((IMixinWorldInfo)((Object)properties)).getDimensionId());
        }
    }

    public static void unregisterAllWorldSettings() {
        worldPropertiesByFolderName.clear();
        worldPropertiesByWorldUuid.clear();
        worldUuidByFolderName.clear();
        worldByDimensionId.clear();
        worldFolderByDimensionId.clear();
        dimensionTypeByDimensionId.clear();
        dimensionPathByDimensionId.clear();
        dimensionBits.clear();
        weakWorldByWorld.clear();
        isVanillaRegistered = false;
        WorldManager.registerVanillaTypesAndDimensions();
    }

    public static Optional<WorldProperties> getWorldProperties(String folderName) {
        Preconditions.checkNotNull((Object)folderName);
        return Optional.ofNullable(worldPropertiesByFolderName.get(folderName));
    }

    public static Collection<WorldProperties> getAllWorldProperties() {
        return Collections.unmodifiableCollection(worldPropertiesByFolderName.values());
    }

    public static Optional<WorldProperties> getWorldProperties(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return Optional.ofNullable(worldPropertiesByWorldUuid.get(uuid));
    }

    public static Optional<UUID> getUuidForFolder(String folderName) {
        Preconditions.checkNotNull((Object)folderName);
        return Optional.ofNullable(worldUuidByFolderName.get((Object)folderName));
    }

    public static Optional<String> getFolderForUuid(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return Optional.ofNullable(worldUuidByFolderName.inverse().get((Object)uuid));
    }

    public static WorldProperties createWorldProperties(String folderName, WorldArchetype archetype) {
        return WorldManager.createWorldProperties(folderName, archetype, null);
    }

    public static WorldProperties createWorldProperties(String folderName, WorldArchetype archetype, @Nullable Integer dimensionId) {
        Preconditions.checkNotNull((Object)folderName);
        Preconditions.checkNotNull((Object)archetype);
        Optional<WorldServer> optWorldServer = WorldManager.getWorld(folderName);
        if (optWorldServer.isPresent()) {
            return ((World)optWorldServer.get()).getProperties();
        }
        Optional<WorldProperties> optWorldProperties = WorldManager.getWorldProperties(folderName);
        if (optWorldProperties.isPresent()) {
            return optWorldProperties.get();
        }
        AnvilSaveHandler saveHandler = new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), folderName, true, SpongeImpl.getDataFixer());
        WorldInfo worldInfo = saveHandler.func_75757_d();
        if (worldInfo == null) {
            worldInfo = new WorldInfo((WorldSettings)archetype, folderName);
        } else {
            ((IMixinWorldInfo)worldInfo).setDimensionType(archetype.getDimensionType());
            ((IMixinWorldInfo)worldInfo).createWorldConfig();
            ((WorldProperties)worldInfo).setGeneratorModifiers(archetype.getGeneratorModifiers());
        }
        if (archetype.isSeedRandomized()) {
            ((WorldProperties)worldInfo).setSeed(SpongeImpl.random.nextLong());
        }
        WorldManager.setUuidOnProperties(WorldManager.getCurrentSavesDirectory().get(), (WorldProperties)worldInfo);
        if (dimensionId != null) {
            ((IMixinWorldInfo)worldInfo).setDimensionId(dimensionId);
        } else if (((IMixinWorldInfo)worldInfo).getDimensionId() == null || WorldManager.getWorldByDimensionId(((IMixinWorldInfo)worldInfo).getDimensionId()).isPresent()) {
            ((IMixinWorldInfo)worldInfo).setDimensionId(WorldManager.getNextFreeDimensionId());
        }
        ((WorldProperties)worldInfo).setGeneratorType(archetype.getGeneratorType());
        ((IMixinWorldInfo)worldInfo).getOrCreateWorldConfig().save();
        WorldManager.registerWorldProperties((WorldProperties)worldInfo);
        SpongeImpl.postEvent(SpongeEventFactory.createConstructWorldPropertiesEvent(Sponge.getCauseStackManager().getCurrentCause(), archetype, (WorldProperties)worldInfo));
        saveHandler.func_75755_a(worldInfo, SpongeImpl.getServer().func_184103_al().func_72378_q());
        return (WorldProperties)worldInfo;
    }

    public static boolean saveWorldProperties(WorldProperties properties) {
        Preconditions.checkNotNull((Object)properties);
        Optional<WorldServer> optWorldServer = WorldManager.getWorldByDimensionId(((IMixinWorldInfo)((Object)properties)).getDimensionId());
        if (optWorldServer.isPresent()) {
            WorldServer worldServer = optWorldServer.get();
            worldServer.func_72860_G().func_75761_a((WorldInfo)properties);
            worldServer.func_72860_G().func_75757_d();
        } else {
            new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), properties.getWorldName(), true, SpongeImpl.getDataFixer()).func_75761_a((WorldInfo)properties);
        }
        ((IMixinWorldInfo)((Object)properties)).getOrCreateWorldConfig().save();
        return true;
    }

    public static void unloadQueuedWorlds() {
        WorldServer server;
        while ((server = unloadQueue.poll()) != null) {
            WorldManager.unloadWorld(server, true);
        }
        unloadQueue.clear();
    }

    public static void queueWorldToUnload(WorldServer worldServer) {
        Preconditions.checkNotNull((Object)worldServer);
        unloadQueue.add(worldServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unloadWorld(WorldServer worldServer, boolean checkConfig) {
        Preconditions.checkNotNull((Object)worldServer);
        MinecraftServer server = SpongeImpl.getServer();
        if (!worldByDimensionId.containsValue((Object)worldServer)) {
            return false;
        }
        if (SpongeImpl.getGlobalConfig().getConfig().getModules().useOptimizations() && SpongeImpl.getGlobalConfig().getConfig().getOptimizations().useAsyncLighting()) {
            ((IMixinWorldServer)worldServer).getLightingExecutor().shutdownNow();
        }
        if (server.func_71278_l()) {
            if (!worldServer.field_73010_i.isEmpty()) {
                return false;
            }
            if (checkConfig && ((WorldProperties)worldServer.func_72912_H()).doesKeepSpawnLoaded()) {
                return false;
            }
        }
        try (Object ignored = ((PhaseContext)GeneralPhase.State.WORLD_UNLOAD.createPhaseContext()).source(worldServer);){
            ((PhaseContext)ignored).buildAndSwitch();
            UnloadWorldEvent event = SpongeEventFactory.createUnloadWorldEvent(Sponge.getCauseStackManager().getCurrentCause(), (World)worldServer);
            boolean isCancelled = SpongeImpl.postEvent(event);
            if (server.func_71278_l() && isCancelled) {
                boolean bl = false;
                return bl;
            }
            IMixinWorldServer mixinWorldServer = (IMixinWorldServer)worldServer;
            int dimensionId = mixinWorldServer.getDimensionId();
            try {
                if (server.func_71278_l()) {
                    WorldManager.saveWorld(worldServer, true);
                }
                mixinWorldServer.getActiveConfig().save();
            }
            catch (MinecraftException e) {
                e.printStackTrace();
            }
            finally {
                worldByDimensionId.remove(dimensionId);
                weakWorldByWorld.remove(worldServer);
                ((IMixinMinecraftServer)server).removeWorldTickTimes(dimensionId);
                SpongeImpl.getLogger().info("Unloading world [{}] (DIM{})", (Object)worldServer.func_72912_H().func_76065_j(), (Object)dimensionId);
                WorldManager.reorderWorldsVanillaFirst();
            }
        }
        return true;
    }

    public static void saveWorld(WorldServer worldServer, boolean flush) throws MinecraftException {
        worldServer.func_73044_a(true, null);
        if (flush) {
            worldServer.func_73041_k();
        }
    }

    public static Optional<WorldServer> loadWorld(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        Optional<World> optWorld = Sponge.getServer().getWorld(uuid);
        if (optWorld.isPresent()) {
            return Optional.of((WorldServer)optWorld.get());
        }
        String worldFolder = (String)worldUuidByFolderName.inverse().get((Object)uuid);
        if (worldFolder == null) {
            return Optional.empty();
        }
        return WorldManager.loadWorld(worldFolder, null);
    }

    public static Optional<WorldServer> loadWorld(String worldName) {
        Preconditions.checkNotNull((Object)worldName);
        return WorldManager.loadWorld(worldName, null);
    }

    public static Optional<WorldServer> loadWorld(WorldProperties properties) {
        Preconditions.checkNotNull((Object)properties);
        return WorldManager.loadWorld(properties.getWorldName(), properties);
    }

    private static Optional<WorldServer> loadWorld(String worldName, @Nullable WorldProperties properties) {
        Preconditions.checkNotNull((Object)worldName);
        Path currentSavesDir = WorldManager.getCurrentSavesDirectory().orElseThrow(() -> new IllegalStateException("Attempt made to load world too early!"));
        MinecraftServer server = SpongeImpl.getServer();
        Optional<WorldServer> optExistingWorldServer = WorldManager.getWorld(worldName);
        if (optExistingWorldServer.isPresent()) {
            return optExistingWorldServer;
        }
        if (!server.func_71255_r()) {
            SpongeImpl.getLogger().error("Unable to load world [{}]. Multi-world is disabled via [allow-nether] in [server.properties].", (Object)worldName);
            return Optional.empty();
        }
        Path worldFolder = currentSavesDir.resolve(worldName);
        if (!Files.isDirectory(worldFolder, new LinkOption[0])) {
            SpongeImpl.getLogger().error("Unable to load world [{}]. We cannot find its folder under [{}].", (Object)worldFolder, (Object)currentSavesDir);
            return Optional.empty();
        }
        AnvilSaveHandler saveHandler = new AnvilSaveHandler(currentSavesDir.toFile(), worldName, true, SpongeImpl.getDataFixer());
        if (properties == null && (properties = (WorldProperties)saveHandler.func_75757_d()) == null) {
            SpongeImpl.getLogger().error("Unable to load world [{}]. No world properties was found!", (Object)worldName);
            return Optional.empty();
        }
        if (((IMixinWorldInfo)((Object)properties)).getDimensionId() == null) {
            ((IMixinWorldInfo)((Object)properties)).setDimensionId(WorldManager.getNextFreeDimensionId());
        }
        WorldManager.setUuidOnProperties(WorldManager.getCurrentSavesDirectory().get(), properties);
        WorldManager.registerWorldProperties(properties);
        WorldInfo worldInfo = (WorldInfo)properties;
        ((IMixinWorldInfo)worldInfo).createWorldConfig();
        if (!((WorldProperties)worldInfo).isEnabled()) {
            SpongeImpl.getLogger().error("Unable to load world [{}]. It is disabled.", (Object)worldName);
            return Optional.empty();
        }
        int dimensionId = ((IMixinWorldInfo)((Object)properties)).getDimensionId();
        WorldManager.registerDimension(dimensionId, (DimensionType)properties.getDimensionType());
        WorldManager.registerDimensionPath(dimensionId, worldFolder);
        SpongeImpl.getLogger().info("Loading world [{}] ({})", (Object)properties.getWorldName(), (Object)WorldManager.getDimensionType(dimensionId).get().func_186065_b());
        WorldServer worldServer = WorldManager.createWorldFromProperties(dimensionId, (ISaveHandler)saveHandler, (WorldInfo)properties, new WorldSettings((WorldInfo)properties), false);
        WorldManager.reorderWorldsVanillaFirst();
        return Optional.of(worldServer);
    }

    public static void loadAllWorlds(long defaultSeed, WorldType defaultWorldType, String generatorOptions) {
        MinecraftServer server = SpongeImpl.getServer();
        Path currentSavesDir = server.field_71308_o.toPath().resolve(server.func_71270_I());
        try {
            if (Files.isSymbolicLink(currentSavesDir)) {
                Path actualPathLink = Files.readSymbolicLink(currentSavesDir);
                if (Files.notExists(actualPathLink, new LinkOption[0])) {
                    Files.createDirectories(actualPathLink, new FileAttribute[0]);
                } else if (!Files.isDirectory(actualPathLink, new LinkOption[0])) {
                    throw new IOException("Saves directory [" + currentSavesDir + "] symlinked to [" + actualPathLink + "] is not a directory!");
                }
            } else {
                Files.createDirectories(currentSavesDir, new FileAttribute[0]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        WorldManager.registerVanillaDimensionPaths(currentSavesDir);
        WorldMigrator.migrateWorldsTo(currentSavesDir);
        WorldManager.registerExistingSpongeDimensions(currentSavesDir);
        for (Map.Entry<Integer, DimensionType> entry : WorldManager.sortedDimensionMap().entrySet()) {
            WorldSettings worldSettings;
            SpongeConfig<? extends GeneralConfigBase> activeConfig;
            int dimensionId = entry.getKey();
            DimensionType dimensionType = entry.getValue();
            if (dimensionId != 0 && !server.func_71255_r() || WorldManager.getWorldByDimensionId(dimensionId).isPresent()) continue;
            Path worldFolder = WorldManager.getWorldFolder(dimensionType, dimensionId);
            if (worldFolder == null) {
                SpongeImpl.getLogger().error("An attempt was made to load a world with dimension id [{}] that has no registered world folder!", (Object)dimensionId);
                continue;
            }
            String worldFolderName = worldFolder.getFileName().toString();
            if (dimensionId != 0 && !(activeConfig = SpongeHooks.getActiveConfig(((IMixinDimensionType)dimensionType).getConfigPath(), worldFolderName)).getConfig().getWorld().isWorldEnabled()) {
                SpongeImpl.getLogger().warn("World [{}] (DIM{}) is disabled. World will not be loaded...", (Object)worldFolder, (Object)dimensionId);
                continue;
            }
            Object saveHandler = dimensionId == 0 ? server.func_71254_M().func_75804_a(server.func_71270_I(), true) : new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), worldFolderName, true, SpongeImpl.getDataFixer());
            WorldInfo worldInfo = saveHandler.func_75757_d();
            if (server instanceof IMixinIntegratedServer) {
                worldSettings = ((IMixinIntegratedServer)server).getSettings();
                if (dimensionId == 0 && ((IMixinIntegratedServer)server).isNewSave()) {
                    SpongeImpl.postEvent(SpongeEventFactory.createConstructWorldPropertiesEvent(Sponge.getCauseStackManager().getCurrentCause(), (WorldArchetype)worldSettings, (WorldProperties)worldInfo));
                }
            } else {
                worldSettings = new WorldSettings(defaultSeed, server.func_71265_f(), server.func_71225_e(), server.func_71199_h(), defaultWorldType);
            }
            if (worldInfo == null) {
                worldInfo = WorldManager.createWorldInfoFromSettings(currentSavesDir, (org.spongepowered.api.world.DimensionType)dimensionType, dimensionId, worldFolderName, worldSettings, generatorOptions);
            } else {
                ((IMixinWorldInfo)worldInfo).setDimensionType((org.spongepowered.api.world.DimensionType)dimensionType);
                ((IMixinWorldInfo)worldInfo).createWorldConfig();
                ((WorldProperties)worldInfo).setGenerateSpawnOnLoad(((IMixinDimensionType)dimensionType).shouldGenerateSpawnOnLoad());
            }
            if (((WorldProperties)worldInfo).getUniqueId() == null) {
                WorldManager.setUuidOnProperties(dimensionId == 0 ? currentSavesDir.getParent() : currentSavesDir, (WorldProperties)worldInfo);
            }
            if (((IMixinWorldInfo)worldInfo).getDimensionId() == null) {
                ((IMixinWorldInfo)worldInfo).setDimensionId(dimensionId);
            }
            if (!worldInfo.func_76065_j().equals(worldFolderName)) {
                worldInfo.func_76062_a(worldFolderName);
            }
            if (dimensionId == 0) {
                server.func_175584_a(worldFolderName, saveHandler);
            }
            WorldManager.registerWorldProperties((WorldProperties)worldInfo);
            if (dimensionId != 0 && !((WorldProperties)worldInfo).loadOnStartup()) {
                SpongeImpl.getLogger().warn("World [{}] (DIM{}) is set to not load on startup. To load it later, enable [load-on-startup] in config or use a plugin", (Object)worldFolder, (Object)dimensionId);
                continue;
            }
            WorldServer worldServer = WorldManager.createWorldFromProperties(dimensionId, saveHandler, worldInfo, worldSettings, true);
            SpongeImpl.getLogger().info("Loading world [{}] ({})", (Object)((World)worldServer).getName(), (Object)WorldManager.getDimensionType(dimensionId).get().func_186065_b());
        }
        WorldManager.reorderWorldsVanillaFirst();
    }

    private static WorldInfo createWorldInfoFromSettings(Path currentSaveRoot, org.spongepowered.api.world.DimensionType dimensionType, int dimensionId, String worldFolderName, WorldSettings worldSettings, String generatorOptions) {
        worldSettings.func_82750_a(generatorOptions);
        ((IMixinWorldSettings)worldSettings).setDimensionType(dimensionType);
        ((IMixinWorldSettings)worldSettings).setGenerateSpawnOnLoad(((IMixinDimensionType)((Object)dimensionType)).shouldGenerateSpawnOnLoad());
        WorldInfo worldInfo = new WorldInfo(worldSettings, worldFolderName);
        WorldManager.setUuidOnProperties(dimensionId == 0 ? currentSaveRoot.getParent() : currentSaveRoot, (WorldProperties)worldInfo);
        ((IMixinWorldInfo)worldInfo).setDimensionId(dimensionId);
        SpongeImpl.postEvent(SpongeEventFactory.createConstructWorldPropertiesEvent(Sponge.getCauseStackManager().getCurrentCause(), (WorldArchetype)worldSettings, (WorldProperties)worldInfo));
        return worldInfo;
    }

    private static WorldServer createWorldFromProperties(int dimensionId, ISaveHandler saveHandler, WorldInfo worldInfo, @Nullable WorldSettings worldSettings, boolean initializing) {
        MinecraftServer server = SpongeImpl.getServer();
        WorldServer worldServer = new WorldServer(server, saveHandler, worldInfo, dimensionId, server.field_71304_b);
        worldServer.func_175643_b();
        if (worldSettings != null && initializing) {
            worldServer.func_72963_a(worldSettings);
        }
        worldServer.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(server, worldServer));
        if (!server.func_71264_H() && worldServer.func_72912_H().func_76077_q() == GameType.NOT_SET) {
            worldServer.func_72912_H().func_76060_a(server.func_71265_f());
        }
        worldByDimensionId.put(dimensionId, (Object)worldServer);
        weakWorldByWorld.put(worldServer, worldServer);
        ((IMixinMinecraftServer)SpongeImpl.getServer()).putWorldTickTimes(dimensionId, new long[100]);
        ((IMixinChunkProviderServer)worldServer.func_72863_F()).setForceChunkRequests(true);
        WorldManager.reorderWorldsVanillaFirst();
        SpongeImpl.postEvent(SpongeEventFactory.createLoadWorldEvent(Sponge.getCauseStackManager().getCurrentCause(), (World)worldServer));
        if (((IMixinDimensionType)((Object)((World)worldServer).getDimension().getType())).shouldLoadSpawn()) {
            ((IMixinMinecraftServer)server).prepareSpawnArea(worldServer);
        }
        ((IMixinChunkProviderServer)worldServer.func_72863_F()).setForceChunkRequests(false);
        ((IMixinWorld)worldServer).clearFakeCheck();
        return worldServer;
    }

    public static void forceAddWorld(int dimensionId, WorldServer worldServer) {
        worldByDimensionId.put(dimensionId, (Object)worldServer);
        weakWorldByWorld.put(worldServer, worldServer);
        ((IMixinMinecraftServer)SpongeImpl.getServer()).putWorldTickTimes(dimensionId, new long[100]);
    }

    public static void reorderWorldsVanillaFirst() {
        LinkedList<Object> sorted = new LinkedList<Object>();
        ArrayList<Integer> vanillaWorldIds = new ArrayList<Integer>();
        WorldServer worldServer = (WorldServer)worldByDimensionId.get(0);
        if (worldServer != null) {
            vanillaWorldIds.add(0);
            sorted.add(worldServer);
        }
        if ((worldServer = (WorldServer)worldByDimensionId.get(-1)) != null) {
            vanillaWorldIds.add(-1);
            sorted.add(worldServer);
        }
        if ((worldServer = (WorldServer)worldByDimensionId.get(1)) != null) {
            vanillaWorldIds.add(1);
            sorted.add(worldServer);
        }
        ArrayList<WorldServer> worlds = new ArrayList<WorldServer>((Collection<WorldServer>)worldByDimensionId.values());
        Iterator iterator = worlds.iterator();
        while (iterator.hasNext()) {
            IMixinWorldServer mixinWorld = (IMixinWorldServer)iterator.next();
            Integer dimensionId = mixinWorld.getDimensionId();
            if (!vanillaWorldIds.contains(dimensionId)) continue;
            iterator.remove();
        }
        worlds.sort(WORLD_SERVER_COMPARATOR);
        sorted.addAll(worlds);
        SpongeImpl.getServer().field_71305_c = sorted.toArray(new WorldServer[0]);
    }

    private static void setUuidOnProperties(Path savesRoot, WorldProperties properties) {
        UUID uuid;
        Preconditions.checkNotNull((Object)properties);
        if (properties.getUniqueId() == null || properties.getUniqueId().equals(UUID.fromString("00000000-0000-0000-0000-000000000000"))) {
            Path uidPath = savesRoot.resolve(properties.getWorldName()).resolve("uid.dat");
            if (Files.notExists(uidPath, new LinkOption[0])) {
                uuid = UUID.randomUUID();
            } else {
                try (DataInputStream dis = new DataInputStream(Files.newInputStream(uidPath, new OpenOption[0]));){
                    uuid = new UUID(dis.readLong(), dis.readLong());
                }
                catch (IOException e) {
                    SpongeImpl.getLogger().error("World folder [{}] has an existing Bukkit unique identifier for it but we encountered issues parsing the file. We will have to use a new unique id. Please report this to Sponge ASAP.", (Object)properties.getWorldName(), (Object)e);
                    uuid = UUID.randomUUID();
                }
            }
        } else {
            uuid = properties.getUniqueId();
        }
        ((IMixinWorldInfo)((Object)properties)).setUniqueId(uuid);
    }

    private static void registerExistingSpongeDimensions(Path rootPath) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(rootPath, LEVEL_AND_SPONGE);){
            for (Path worldPath : stream) {
                NBTTagCompound compound;
                Path spongeLevelPath = worldPath.resolve("level_sponge.dat");
                String worldFolderName = worldPath.getFileName().toString();
                try {
                    compound = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(spongeLevelPath, new OpenOption[0]));
                }
                catch (IOException e) {
                    SpongeImpl.getLogger().error("Failed loading Sponge data for World [{}]}. Report to Sponge ASAP.", (Object)worldFolderName, (Object)e);
                    continue;
                }
                NBTTagCompound spongeDataCompound = compound.func_74775_l("SpongeData");
                if (!compound.func_74764_b("SpongeData")) {
                    SpongeImpl.getLogger().error("World [{}] has Sponge related data in the form of [level-sponge.dat] but the structure is not proper. Generally, the data is within a [{}] tag but it is not for this world. Report to Sponge ASAP.", (Object)worldFolderName, (Object)"SpongeData");
                    continue;
                }
                if (!spongeDataCompound.func_74764_b("dimensionId")) {
                    SpongeImpl.getLogger().error("World [{}] has no dimension id. Report this to Sponge ASAP.", (Object)worldFolderName);
                    continue;
                }
                int dimensionId = spongeDataCompound.func_74762_e("dimensionId");
                if (dimensionId == 0 || dimensionId == -1 || dimensionId == 1) continue;
                spongeDataCompound = DataUtil.spongeDataFixer.func_188257_a((IFixType)FixTypes.LEVEL, spongeDataCompound);
                String dimensionTypeId = "overworld";
                if (spongeDataCompound.func_74764_b("dimensionType")) {
                    dimensionTypeId = spongeDataCompound.func_74779_i("dimensionType");
                } else {
                    SpongeImpl.getLogger().warn("World [{}] (DIM{}) has no specified dimension type. Defaulting to [{}}]...", (Object)worldFolderName, (Object)dimensionId, (Object)DimensionTypes.OVERWORLD.getName());
                }
                dimensionTypeId = WorldManager.fixDimensionTypeId(dimensionTypeId);
                org.spongepowered.api.world.DimensionType dimensionType = Sponge.getRegistry().getType(org.spongepowered.api.world.DimensionType.class, dimensionTypeId).orElse(null);
                if (dimensionType == null) {
                    SpongeImpl.getLogger().warn("World [{}] (DIM{}) has specified dimension type that is not registered. Skipping...", (Object)worldFolderName, (Object)dimensionId);
                    continue;
                }
                spongeDataCompound.func_74778_a("dimensionType", dimensionTypeId);
                if (!spongeDataCompound.func_186855_b("UUID")) {
                    SpongeImpl.getLogger().error("World [{}] (DIM{}) has no valid unique identifier. This is a critical error and should be reported to Sponge ASAP.", (Object)worldFolderName, (Object)dimensionId);
                    continue;
                }
                worldFolderByDimensionId.put(dimensionId, worldFolderName);
                WorldManager.registerDimensionPath(dimensionId, rootPath.resolve(worldFolderName));
                WorldManager.registerDimension(dimensionId, (DimensionType)dimensionType);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String fixDimensionTypeId(String name) {
        if (!name.contains(":")) {
            for (org.spongepowered.api.world.DimensionType type : Sponge.getRegistry().getAllOf(org.spongepowered.api.world.DimensionType.class)) {
                String typeId = type.getId().substring(type.getId().lastIndexOf(":") + 1);
                if (!typeId.equals(name)) continue;
                return type.getId();
            }
        }
        return name;
    }

    public static CompletableFuture<Optional<WorldProperties>> copyWorld(WorldProperties worldProperties, String copyName) {
        Preconditions.checkArgument((boolean)worldPropertiesByFolderName.containsKey(worldProperties.getWorldName()), (Object)"World properties not registered!");
        Preconditions.checkArgument((!worldPropertiesByFolderName.containsKey(copyName) ? 1 : 0) != 0, (Object)"Destination world name already is registered!");
        WorldInfo info = (WorldInfo)worldProperties;
        WorldServer worldServer = (WorldServer)worldByDimensionId.get(((IMixinWorldInfo)info).getDimensionId().intValue());
        if (worldServer != null) {
            try {
                WorldManager.saveWorld(worldServer, true);
            }
            catch (MinecraftException e) {
                throw new RuntimeException(e);
            }
            ((IMixinMinecraftServer)SpongeImpl.getServer()).setSaveEnabled(false);
        }
        CompletableFuture<Optional<WorldProperties>> future = SpongeImpl.getScheduler().submitAsyncTask(new CopyWorldTask(info, copyName));
        if (worldServer != null) {
            future.thenRun(() -> ((IMixinMinecraftServer)SpongeImpl.getServer()).setSaveEnabled(true));
        }
        return future;
    }

    public static Optional<WorldProperties> renameWorld(WorldProperties worldProperties, String newName) {
        Preconditions.checkNotNull((Object)worldProperties);
        Preconditions.checkNotNull((Object)newName);
        Preconditions.checkState((!worldByDimensionId.containsKey((Object)((IMixinWorldInfo)((Object)worldProperties)).getDimensionId()) ? 1 : 0) != 0, (Object)"World is still loaded!");
        Path oldWorldFolder = WorldManager.getCurrentSavesDirectory().get().resolve(worldProperties.getWorldName());
        Path newWorldFolder = oldWorldFolder.resolveSibling(newName);
        if (Files.exists(newWorldFolder, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            Files.move(oldWorldFolder, newWorldFolder, new CopyOption[0]);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        WorldManager.unregisterWorldProperties(worldProperties, false);
        WorldInfo info = new WorldInfo((WorldInfo)worldProperties);
        info.func_76062_a(newName);
        ((IMixinWorldInfo)info).setUniqueId(worldProperties.getUniqueId());
        if (((IMixinWorldInfo)((Object)worldProperties)).getDimensionId() != null) {
            ((IMixinWorldInfo)info).setDimensionId(((IMixinWorldInfo)((Object)worldProperties)).getDimensionId());
        }
        ((IMixinWorldInfo)info).createWorldConfig();
        new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), newName, true, SpongeImpl.getDataFixer()).func_75761_a(info);
        WorldManager.registerWorldProperties((WorldProperties)info);
        return Optional.of((WorldProperties)info);
    }

    public static CompletableFuture<Boolean> deleteWorld(WorldProperties worldProperties) {
        Preconditions.checkNotNull((Object)worldProperties);
        Preconditions.checkArgument((boolean)worldPropertiesByWorldUuid.containsKey(worldProperties.getUniqueId()), (Object)"World properties not registered!");
        Preconditions.checkState((!worldByDimensionId.containsKey((Object)((IMixinWorldInfo)((Object)worldProperties)).getDimensionId()) ? 1 : 0) != 0, (Object)"World not unloaded!");
        return SpongeImpl.getScheduler().submitAsyncTask(new DeleteWorldTask(worldProperties));
    }

    public static void updateServerDifficulty() {
        EnumDifficulty serverDifficulty = SpongeImpl.getServer().func_147135_j();
        for (WorldServer worldServer : WorldManager.getWorlds()) {
            WorldManager.adjustWorldForDifficulty(worldServer, ((IMixinWorldInfo)worldServer.func_72912_H()).hasCustomDifficulty() ? worldServer.func_72912_H().func_176130_y() : serverDifficulty, false);
        }
    }

    public static void adjustWorldForDifficulty(WorldServer worldServer, EnumDifficulty difficulty, boolean isCustom) {
        MinecraftServer server = SpongeImpl.getServer();
        if (worldServer.func_72912_H().func_76093_s()) {
            difficulty = EnumDifficulty.HARD;
            worldServer.func_72891_a(true, true);
        } else if (SpongeImpl.getServer().func_71264_H()) {
            worldServer.func_72891_a(worldServer.func_175659_aa() != EnumDifficulty.PEACEFUL, true);
        } else {
            worldServer.func_72891_a(server.func_71193_K(), server.func_71268_U());
        }
        if (!isCustom) {
            ((IMixinWorldInfo)worldServer.func_72912_H()).forceSetDifficulty(difficulty);
        } else {
            worldServer.func_72912_H().func_176144_a(difficulty);
        }
    }

    public static void sendDimensionRegistration(EntityPlayerMP playerMP, WorldProvider provider) {
    }

    public static void loadDimensionDataMap(@Nullable NBTTagCompound compound) {
        dimensionBits.clear();
        if (compound == null) {
            dimensionTypeByDimensionId.keySet().stream().filter(dimensionId -> dimensionId >= 0).forEach(dimensionBits::set);
        } else {
            int[] intArray = compound.func_74759_k("DimensionArray");
            for (int i = 0; i < intArray.length; ++i) {
                for (int j = 0; j < 32; ++j) {
                    dimensionBits.set(i * 32 + j, (intArray[i] & 1 << j) != 0);
                }
            }
        }
    }

    public static NBTTagCompound saveDimensionDataMap() {
        int[] data = new int[(dimensionBits.length() + 32 - 1) / 32];
        NBTTagCompound dimMap = new NBTTagCompound();
        for (int i = 0; i < data.length; ++i) {
            int val = 0;
            for (int j = 0; j < 32; ++j) {
                val |= dimensionBits.get(i * 32 + j) ? 1 << j : 0;
            }
            data[i] = val;
        }
        dimMap.func_74783_a("DimensionArray", data);
        return dimMap;
    }

    public static Optional<Path> getCurrentSavesDirectory() {
        Optional<WorldServer> optWorldServer = WorldManager.getWorldByDimensionId(0);
        if (optWorldServer.isPresent()) {
            return Optional.of(optWorldServer.get().func_72860_G().func_75765_b().toPath());
        }
        if (SpongeImpl.getGame().getState().ordinal() >= GameState.SERVER_ABOUT_TO_START.ordinal()) {
            SaveHandler saveHandler = (SaveHandler)SpongeImpl.getServer().func_71254_M().func_75804_a(SpongeImpl.getServer().func_71270_I(), false);
            return Optional.of(saveHandler.func_75765_b().toPath());
        }
        return Optional.empty();
    }

    public static Map<WorldServer, WorldServer> getWeakWorldMap() {
        return weakWorldByWorld;
    }

    public static int getClientDimensionId(EntityPlayerMP player, net.minecraft.world.World world) {
        if (!((IMixinEntityPlayerMP)player).usesCustomClient()) {
            DimensionType type = world.field_73011_w.func_186058_p();
            if (type == DimensionType.OVERWORLD) {
                return 0;
            }
            if (type == DimensionType.NETHER) {
                return -1;
            }
            return 1;
        }
        return ((IMixinWorldServer)world).getDimensionId();
    }

    @Nullable
    public static Integer getDimensionId(WorldServer world) {
        return ((IMixinWorldInfo)world.func_72912_H()).getDimensionId();
    }

    private static class DeleteWorldTask
    implements Callable<Boolean> {
        private final WorldProperties props;

        DeleteWorldTask(WorldProperties props) {
            this.props = props;
        }

        @Override
        public Boolean call() {
            Path worldFolder = WorldManager.getCurrentSavesDirectory().get().resolve(this.props.getWorldName());
            if (!Files.exists(worldFolder, new LinkOption[0])) {
                WorldManager.unregisterWorldProperties(this.props, true);
                return true;
            }
            try {
                Files.walkFileTree(worldFolder, DeleteFileVisitor.INSTANCE);
                WorldManager.unregisterWorldProperties(this.props, true);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    private static class CopyWorldTask
    implements Callable<Optional<WorldProperties>> {
        private final WorldInfo oldInfo;
        private final String newName;

        CopyWorldTask(WorldInfo info, String newName) {
            this.oldInfo = info;
            this.newName = newName;
        }

        @Override
        public Optional<WorldProperties> call() throws Exception {
            Path oldWorldFolder = WorldManager.getCurrentSavesDirectory().get().resolve(this.oldInfo.func_76065_j());
            Path newWorldFolder = WorldManager.getCurrentSavesDirectory().get().resolve(this.newName);
            if (Files.exists(newWorldFolder, new LinkOption[0])) {
                return Optional.empty();
            }
            FileVisitor<Path> visitor = new CopyFileVisitor(newWorldFolder, new CopyOption[0]);
            if (((IMixinWorldInfo)this.oldInfo).getDimensionId() == 0) {
                oldWorldFolder = WorldManager.getCurrentSavesDirectory().get();
                visitor = new ForwardingFileVisitor<Path>((FileVisitor)visitor){
                    private boolean root;
                    {
                        super(x0);
                        this.root = true;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (!this.root && Files.exists(dir.resolve("level.dat"), new LinkOption[0])) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        this.root = false;
                        return super.preVisitDirectory(dir, attrs);
                    }
                };
            }
            Files.walkFileTree(oldWorldFolder, visitor);
            WorldInfo info = new WorldInfo(this.oldInfo);
            info.func_76062_a(this.newName);
            ((IMixinWorldInfo)info).setDimensionId(WorldManager.getNextFreeDimensionId());
            ((IMixinWorldInfo)info).setUniqueId(UUID.randomUUID());
            ((IMixinWorldInfo)info).createWorldConfig();
            WorldManager.registerWorldProperties((WorldProperties)info);
            new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), this.newName, true, SpongeImpl.getDataFixer()).func_75761_a(info);
            return Optional.of((WorldProperties)info);
        }
    }
}

