/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.world.SpongeLocatableBlock;

public class SpongeLocatableBlockBuilder
extends AbstractDataBuilder<LocatableBlock>
implements LocatableBlock.Builder {
    @Nullable
    BlockState blockState;
    @Nullable
    Vector3i position;
    @Nullable
    UUID worldId;
    @Nullable
    WeakReference<World> worldReference;

    public SpongeLocatableBlockBuilder() {
        super(LocatableBlock.class, 1);
    }

    @Override
    public SpongeLocatableBlockBuilder state(BlockState blockState) {
        this.blockState = (BlockState)Preconditions.checkNotNull((Object)blockState, (Object)"BlockState cannot be null!");
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder location(Location<World> location) {
        Preconditions.checkNotNull(location, (Object)"Location cannot be null!");
        this.blockState = location.getBlock();
        this.position = location.getBlockPosition();
        this.worldId = location.getExtent().getUniqueId();
        this.worldReference = new WeakReference<World>(location.getExtent());
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder position(Vector3i position) {
        this.position = (Vector3i)Preconditions.checkNotNull((Object)position, (Object)"Position cannot be null!");
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder position(int x, int y, int z) {
        this.position = new Vector3i(x, y, z);
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder world(World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null!");
        this.worldReference = new WeakReference<World>(world);
        this.worldId = world.getUniqueId();
        return this;
    }

    @Override
    public SpongeLocatableBlockBuilder from(LocatableBlock value) {
        this.position = ((LocatableBlock)Preconditions.checkNotNull((Object)value, (Object)"LocatableBlock cannot be null!")).getPosition();
        this.worldId = value.getLocation().getExtent().getUniqueId();
        this.worldReference = new WeakReference<World>(value.getLocation().getExtent());
        return this;
    }

    @Override
    public LocatableBlock build() {
        Preconditions.checkNotNull((Object)this.position, (Object)"Position cannot be null!");
        Preconditions.checkNotNull((Object)this.worldId, (Object)"World UUID cannot be null!");
        Preconditions.checkNotNull(this.worldReference, (Object)"World reference cannot be null!");
        if (this.blockState == null) {
            if (this.worldReference.get() != null) {
                this.blockState = ((World)this.worldReference.get()).getBlock(this.position);
            } else {
                Optional<World> world = Sponge.getServer().getWorld(this.worldId);
                Preconditions.checkArgument((boolean)world.isPresent(), (Object)("World is not available by the UUID: " + this.worldId));
                this.worldReference = new WeakReference<World>(world.get());
                this.blockState = ((World)this.worldReference.get()).getBlock(this.position);
            }
        }
        return new SpongeLocatableBlock(this);
    }

    @Override
    public SpongeLocatableBlockBuilder reset() {
        this.position = null;
        this.worldId = null;
        this.worldReference = null;
        this.blockState = null;
        return this;
    }

    @Override
    protected Optional<LocatableBlock> buildContent(DataView container) throws InvalidDataException {
        int x = container.getInt(Queries.POSITION_X).orElseThrow(() -> new InvalidDataException("Could not locate an \"x\" coordinate in the container!"));
        int y = container.getInt(Queries.POSITION_Y).orElseThrow(() -> new InvalidDataException("Could not locate an \"y\" coordinate in the container!"));
        int z = container.getInt(Queries.POSITION_Z).orElseThrow(() -> new InvalidDataException("Could not locate an \"z\" coordinate in the container!"));
        BlockState blockState = container.getCatalogType(DataQueries.BLOCK_STATE, BlockState.class).orElseThrow(() -> new InvalidDataException("Could not locate a BlockState"));
        UUID worldId = container.getObject(Queries.WORLD_ID, UUID.class).orElseThrow(() -> new InvalidDataException("Could not locate a UUID"));
        return Sponge.getServer().getWorld(worldId).map(world -> new SpongeLocatableBlockBuilder().position(x, y, z).world((World)world).state(blockState).build());
    }
}

