/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.collect.ImmutableList;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.common.config.category.LoggingCategory;

public enum BlockChange {
    BREAK{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventBreak(cause, transactions);
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockBreakLogging();
        }
    }
    ,
    DECAY{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventDecay(cause, transactions);
        }
    }
    ,
    MODIFY{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventModify(cause, transactions);
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockModifyLogging();
        }
    }
    ,
    PLACE{

        @Override
        public ChangeBlockEvent createEvent(Cause cause, ImmutableList<Transaction<BlockSnapshot>> transactions) {
            return SpongeEventFactory.createChangeBlockEventPlace(cause, transactions);
        }

        @Override
        public boolean allowsLogging(LoggingCategory category) {
            return category.blockPlaceLogging();
        }
    };


    public boolean allowsLogging(LoggingCategory category) {
        return false;
    }

    public abstract ChangeBlockEvent createEvent(Cause var1, ImmutableList<Transaction<BlockSnapshot>> var2);
}

