/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.FixedTranslation;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.CatalogBuilder;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
public abstract class SpongeCatalogBuilder<C extends CatalogType, B extends ResettableBuilder<C, B>>
implements CatalogBuilder<C, B> {
    @Nullable
    protected Translation name;
    protected String id;

    @Override
    public B name(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkState((!name.isEmpty() ? 1 : 0) != 0, (Object)"The name may not be empty");
        this.name = new FixedTranslation(name);
        return (B)this;
    }

    public Translation getName() {
        if (this.name != null) {
            return this.name;
        }
        return new FixedTranslation(this.id);
    }

    @Override
    public B name(Translation name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkState((!name.getId().isEmpty() ? 1 : 0) != 0, (Object)"The translation id may not be empty");
        this.name = name;
        return (B)this;
    }

    @Override
    public B id(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"The id may not be empty.");
        this.id = id;
        return (B)this;
    }

    @Override
    public C build() {
        Preconditions.checkNotNull((Object)this.id, (Object)"The id must be set.");
        PluginContainer plugin = Sponge.getCauseStackManager().getCurrentCause().first(PluginContainer.class).orElseThrow(() -> new IllegalStateException("Couldn't find a PluginContainer in the cause stack."));
        Translation name = this.name;
        if (name == null) {
            name = new FixedTranslation(this.id);
        }
        return this.build(plugin, this.id, name);
    }

    protected abstract C build(PluginContainer var1, String var2, Translation var3);

    @Override
    public B reset() {
        this.name = null;
        this.id = null;
        return (B)this;
    }
}

