/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.selector;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.GameType;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.text.selector.ArgumentType;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.text.selector.SpongeArgumentHolder;
import org.spongepowered.common.text.selector.SpongeSelectorFactory;

@NonnullByDefault
public class SpongeArgumentType<T>
extends SpongeArgumentHolder<ArgumentType<T>>
implements ArgumentType<T> {
    private static final Map<String, Function<String, ?>> converters = Maps.newHashMap();
    private final String key;
    private final Function<String, T> converter;

    static <T> Function<String, T> getConverter(Class<T> type, String converterKey) {
        if (!converters.containsKey(converterKey)) {
            try {
                Method valueOf = type.getMethod("valueOf", String.class);
                converters.put(converterKey, SpongeSelectorFactory.methodAsFunction(valueOf, true));
            }
            catch (NoSuchMethodException ignored) {
                if (CatalogType.class.isAssignableFrom(type)) {
                    Class<CatalogType> type2 = type.asSubclass(CatalogType.class);
                    converters.put(converterKey, input -> SpongeImpl.getGame().getRegistry().getType(type2, (String)input).get());
                }
                throw new IllegalStateException("can't convert " + type);
            }
            catch (SecurityException e) {
                SpongeImpl.getLogger().catching((Throwable)e);
            }
        }
        return converters.get(converterKey);
    }

    public SpongeArgumentType(String key, Class<T> type) {
        this(key, type, type.getName());
    }

    public SpongeArgumentType(String key, Class<T> type, String converterKey) {
        this(key, SpongeArgumentType.getConverter(type, converterKey));
    }

    public SpongeArgumentType(String key, Function<String, T> converter) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.converter = (Function)Preconditions.checkNotNull(converter);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.getKey();
    }

    public boolean equals(Object obj) {
        return obj instanceof ArgumentType && ((ArgumentType)obj).getKey().equals(this.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    protected T convert(String s) {
        return this.converter.apply(s);
    }

    static {
        converters.put(String.class.getName(), Function.identity());
        converters.put(EntityType.class.getName(), input -> EntityTypeRegistryModule.getInstance().getById(input.toLowerCase()).orElse(null));
        converters.put(GameMode.class.getName(), input -> {
            try {
                int i = Integer.parseInt(input);
                return GameType.func_185329_a((int)i, (GameType)GameType.NOT_SET);
            }
            catch (NumberFormatException e) {
                return GameType.func_185328_a((String)input, (GameType)GameType.NOT_SET);
            }
        });
    }

    public static class Invertible<T>
    extends SpongeArgumentType<T>
    implements ArgumentType.Invertible<T> {
        public Invertible(String key, Class<T> type) {
            super(key, type);
        }

        public Invertible(String key, Class<T> type, String converterKey) {
            super(key, Invertible.getConverter(type, converterKey));
        }

        public Invertible(String key, Function<String, T> converter) {
            super(key, converter);
        }
    }
}

