/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.user;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListBans;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.UserListEntryBan;
import net.minecraft.server.management.UserListWhitelist;
import net.minecraft.server.management.UserListWhitelistEntry;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.SaveHandler;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.ProfileNotFoundException;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.world.WorldManager;

class UserDiscoverer {
    private static final Cache<UUID, User> userCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private static final Cache<String, User> userByNameCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private static final Set<UUID> nonExistentUsers = new HashSet<UUID>();

    UserDiscoverer() {
    }

    static User create(com.mojang.authlib.GameProfile profile) {
        User user = (User)((Object)new SpongeUser(profile));
        userCache.put((Object)profile.getId(), (Object)user);
        if (profile.getName() != null) {
            userByNameCache.put((Object)profile.getName(), (Object)user);
        }
        nonExistentUsers.remove(profile.getId());
        return user;
    }

    static User forceRecreate(com.mojang.authlib.GameProfile profile) {
        SpongeUser user = (SpongeUser)userCache.getIfPresent((Object)profile.getId());
        if (user != null && SpongeUser.dirtyUsers.contains(user)) {
            user.save();
        }
        return UserDiscoverer.create(profile);
    }

    static User findByProfile(GameProfile profile) {
        UUID uniqueId = profile.getUniqueId();
        User user = (User)userCache.getIfPresent((Object)uniqueId);
        if (user != null) {
            if (user.getName() == null && profile.getName().isPresent()) {
                user = UserDiscoverer.getFromStoredData(profile);
            }
            return user;
        }
        user = UserDiscoverer.getOnlinePlayer(uniqueId);
        if (user != null) {
            nonExistentUsers.remove(profile.getUniqueId());
            return user;
        }
        user = UserDiscoverer.getFromStoredData(profile);
        if (user != null) {
            return user;
        }
        user = UserDiscoverer.getFromWhitelist(uniqueId);
        if (user != null) {
            return user;
        }
        user = UserDiscoverer.getFromBanlist(uniqueId);
        return user;
    }

    static User findByUsername(String username) {
        Object profile;
        User user = (User)userByNameCache.getIfPresent((Object)username);
        if (user != null) {
            return user;
        }
        PlayerProfileCache cache = SpongeImpl.getServer().func_152358_ax();
        HashSet names = Sets.newHashSet((Object[])cache.func_152654_a());
        if (names.contains(username.toLowerCase(Locale.ROOT)) && (profile = cache.func_152655_a(username)) != null) {
            return UserDiscoverer.findByProfile((GameProfile)profile);
        }
        try {
            profile = Sponge.getServer().getGameProfileManager().get(username).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while looking up username " + username, e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ProfileNotFoundException) {
                return null;
            }
            throw new RuntimeException("Exception while looking up username " + username, e);
        }
        return UserDiscoverer.findByProfile((GameProfile)profile);
    }

    static Collection<GameProfile> getAllProfiles() {
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        HashMap<UUID, GameProfile> profiles = new HashMap<UUID, GameProfile>();
        userCache.asMap().values().stream().map(User::getProfile).forEach(p -> profiles.put(p.getUniqueId(), (GameProfile)p));
        SaveHandler saveHandler = (SaveHandler)WorldManager.getWorldByDimensionId(0).get().func_72860_G();
        String[] uuids = saveHandler.func_75754_f();
        PlayerProfileCache profileCache = SpongeImpl.getServer().func_152358_ax();
        for (String playerUuid : uuids) {
            UUID uuid;
            if (playerUuid.contains(".")) continue;
            try {
                uuid = UUID.fromString(playerUuid);
            }
            catch (Exception ex) {
                continue;
            }
            nonExistentUsers.remove(uuid);
            com.mojang.authlib.GameProfile profile = profileCache.func_152652_a(uuid);
            if (profile == null) continue;
            profiles.put(profile.getId(), (GameProfile)profile);
        }
        UserDiscoverer.addToProfiles(SpongeImpl.getServer().func_184103_al().func_152599_k().func_152688_e().values(), profiles, profileCache);
        UserDiscoverer.addToProfiles(SpongeImpl.getServer().func_184103_al().func_152608_h().func_152688_e().values(), profiles, profileCache);
        return profiles.values();
    }

    private static void addToProfiles(Collection<? extends UserListEntry<com.mojang.authlib.GameProfile>> gameProfiles, Map<UUID, GameProfile> profiles, PlayerProfileCache profileCache) {
        gameProfiles.stream().filter(x -> !profiles.containsKey(((com.mojang.authlib.GameProfile)x.field_152642_a).getId())).map(entry -> (com.mojang.authlib.GameProfile)entry.field_152642_a).forEach(x -> {
            com.mojang.authlib.GameProfile profile = profileCache.func_152652_a(x.getId());
            if (profile == null) {
                profile = x;
                profileCache.func_152649_a(profile);
            }
            profiles.put(profile.getId(), (GameProfile)profile);
        });
    }

    static boolean delete(UUID uniqueId) {
        if (UserDiscoverer.getOnlinePlayer(uniqueId) != null) {
            return false;
        }
        boolean success = UserDiscoverer.deleteStoredPlayerData(uniqueId);
        success = success && UserDiscoverer.deleteWhitelistEntry(uniqueId);
        success = success && UserDiscoverer.deleteBanlistEntry(uniqueId);
        return success;
    }

    private static User getOnlinePlayer(UUID uniqueId) {
        Optional<User> optional;
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        PlayerList playerList = SpongeImpl.getServer().func_184103_al();
        Preconditions.checkNotNull((Object)playerList, (Object)"Server is not fully initialized yet! (Try a later event)");
        IMixinEntityPlayerMP player = (IMixinEntityPlayerMP)playerList.func_177451_a(uniqueId);
        if (player != null && (optional = player.getBackingUser()).isPresent()) {
            User user = optional.get();
            userCache.put((Object)uniqueId, (Object)user);
            userByNameCache.put((Object)user.getName(), (Object)user);
            return user;
        }
        return null;
    }

    private static User getFromStoredData(GameProfile profile) {
        if (nonExistentUsers.contains(profile.getUniqueId())) {
            return null;
        }
        File dataFile = UserDiscoverer.getPlayerDataFile(profile.getUniqueId());
        if (dataFile == null) {
            nonExistentUsers.add(profile.getUniqueId());
            return null;
        }
        User user = UserDiscoverer.create((com.mojang.authlib.GameProfile)profile);
        try {
            ((SpongeUser)((Object)user)).readFromNbt(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(dataFile)));
        }
        catch (IOException e) {
            SpongeImpl.getLogger().warn("Corrupt user file {}", (Object)dataFile, (Object)e);
        }
        return user;
    }

    private static User getFromWhitelist(UUID uniqueId) {
        com.mojang.authlib.GameProfile profile = null;
        UserListWhitelist whiteList = SpongeImpl.getServer().func_184103_al().func_152599_k();
        UserListWhitelistEntry whiteListData = (UserListWhitelistEntry)whiteList.func_152683_b((Object)new com.mojang.authlib.GameProfile(uniqueId, ""));
        if (whiteListData != null) {
            profile = (com.mojang.authlib.GameProfile)whiteListData.field_152642_a;
        }
        if (profile != null) {
            return UserDiscoverer.create(profile);
        }
        return null;
    }

    private static User getFromBanlist(UUID uniqueId) {
        com.mojang.authlib.GameProfile profile = null;
        UserListBans banList = SpongeImpl.getServer().func_184103_al().func_152608_h();
        UserListEntryBan banData = (UserListEntryBan)banList.func_152683_b((Object)new com.mojang.authlib.GameProfile(uniqueId, ""));
        if (banData != null) {
            profile = (com.mojang.authlib.GameProfile)banData.field_152642_a;
        }
        if (profile != null) {
            return UserDiscoverer.create(profile);
        }
        return null;
    }

    private static File getPlayerDataFile(UUID uniqueId) {
        Optional<WorldServer> worldServer = WorldManager.getWorldByDimensionId(0);
        if (!worldServer.isPresent()) {
            return null;
        }
        SaveHandler saveHandler = (SaveHandler)worldServer.get().func_72860_G();
        File file = new File(saveHandler.field_75771_c, uniqueId.toString() + ".dat");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static boolean deleteStoredPlayerData(UUID uniqueId) {
        File dataFile = UserDiscoverer.getPlayerDataFile(uniqueId);
        if (dataFile != null) {
            try {
                return dataFile.delete();
            }
            catch (SecurityException e) {
                SpongeImpl.getLogger().warn("Unable to delete file {} due to a security error", (Object)dataFile, (Object)e);
                return false;
            }
        }
        return true;
    }

    private static boolean deleteWhitelistEntry(UUID uniqueId) {
        UserListWhitelist whiteList = SpongeImpl.getServer().func_184103_al().func_152599_k();
        whiteList.func_152684_c((Object)new com.mojang.authlib.GameProfile(uniqueId, ""));
        return true;
    }

    private static boolean deleteBanlistEntry(UUID uniqueId) {
        UserListBans banList = SpongeImpl.getServer().func_184103_al().func_152608_h();
        banList.func_152684_c((Object)new com.mojang.authlib.GameProfile(uniqueId, ""));
        return true;
    }
}

