/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.passive.EntityHorse;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseColors;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.entity.SpongeHorseColor;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=HorseColors.class)
public class HorseColorRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<HorseColor> {
    public static final Map<Integer, HorseColor> HORSE_COLOR_IDMAP = Maps.newHashMap();
    public static final SpongeHorseColor WHITE = new SpongeHorseColor(0, "minecraft:white", "WHITE");
    public static final SpongeHorseColor CREAMY = new SpongeHorseColor(1, "minecraft:creamy", "CREAMY");
    public static final SpongeHorseColor CHESTNUT = new SpongeHorseColor(2, "minecraft:chestnut", "CHESTNUT");
    public static final SpongeHorseColor BROWN = new SpongeHorseColor(3, "minecraft:brown", "BROWN");
    public static final SpongeHorseColor BLACK = new SpongeHorseColor(4, "minecraft:black", "BLACK");
    public static final SpongeHorseColor GRAY = new SpongeHorseColor(5, "minecraft:gray", "GRAY");
    public static final SpongeHorseColor DARK_BROWN = new SpongeHorseColor(6, "minecraft:dark_brown", "DARK_BROWN");
    private static final HorseColorRegistryModule INSTANCE = new HorseColorRegistryModule();

    private HorseColorRegistryModule() {
        super("minecraft");
    }

    public static HorseColorRegistryModule getInstance() {
        return INSTANCE;
    }

    public static HorseColor getHorseColor(EntityHorse horse) {
        return HORSE_COLOR_IDMAP.get(horse.func_110202_bQ() & 0xFF);
    }

    public static HorseColor getHorseColor(DataView container) {
        return SpongeImpl.getRegistry().getType(HorseColor.class, DataUtil.getData(container, Keys.HORSE_COLOR, String.class)).get();
    }

    @Override
    public void registerDefaults() {
        HORSE_COLOR_IDMAP.put(0, WHITE);
        HORSE_COLOR_IDMAP.put(1, CREAMY);
        HORSE_COLOR_IDMAP.put(2, CHESTNUT);
        HORSE_COLOR_IDMAP.put(3, BROWN);
        HORSE_COLOR_IDMAP.put(4, BLACK);
        HORSE_COLOR_IDMAP.put(5, GRAY);
        HORSE_COLOR_IDMAP.put(6, DARK_BROWN);
        this.register(WHITE);
        this.register(CREAMY);
        this.register(CHESTNUT);
        this.register(BROWN);
        this.register(BLACK);
        this.register(GRAY);
        this.register(DARK_BROWN);
    }
}

