/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.ai.EntityAITasks;
import org.spongepowered.api.entity.ai.GoalType;
import org.spongepowered.api.entity.ai.GoalTypes;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.ai.SpongeGoalType;

public class GoalTypeModule
implements AlternateCatalogRegistryModule<GoalType> {
    @RegisterCatalog(value=GoalTypes.class)
    private final Map<String, GoalType> goalTypes = new HashMap<String, GoalType>();

    public static GoalTypeModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, GoalType> provideCatalogMap() {
        HashMap<String, GoalType> goalMap = new HashMap<String, GoalType>();
        for (Map.Entry<String, GoalType> entry : this.goalTypes.entrySet()) {
            goalMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        return goalMap;
    }

    @Override
    public Optional<GoalType> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return Optional.ofNullable(this.goalTypes.get(id.toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<GoalType> getAll() {
        return ImmutableList.copyOf(this.goalTypes.values());
    }

    @Override
    public void registerDefaults() {
        this.createGoalType("minecraft:normal", "Normal");
        this.createGoalType("minecraft:target", "Target");
    }

    private GoalType createGoalType(String combinedId, String name) {
        SpongeGoalType newType = new SpongeGoalType(combinedId, name, EntityAITasks.class);
        this.goalTypes.put(combinedId, newType);
        return newType;
    }

    public GoalType createGoalType(Object plugin, String id, String name) {
        Optional<PluginContainer> optPluginContainer = SpongeImpl.getGame().getPluginManager().fromInstance(plugin);
        Preconditions.checkArgument((boolean)optPluginContainer.isPresent());
        PluginContainer pluginContainer = optPluginContainer.get();
        String combinedId = pluginContainer.getId().toLowerCase(Locale.ENGLISH) + ":" + id;
        return this.createGoalType(combinedId, name);
    }

    GoalTypeModule() {
    }

    private static final class Holder {
        static final GoalTypeModule INSTANCE = new GoalTypeModule();

        private Holder() {
        }
    }
}

