/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.item.EntityPainting;
import org.spongepowered.api.data.type.Art;
import org.spongepowered.api.data.type.Arts;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.AdditionalRegistration;
import org.spongepowered.api.registry.util.CustomCatalogRegistration;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.RegistryHelper;

public final class ArtRegistryModule
implements CatalogRegistryModule<Art> {
    @RegisterCatalog(value=Arts.class)
    private final Map<String, Art> artMappings = Maps.newHashMap();

    @Override
    public Optional<Art> getById(String id) {
        return Optional.ofNullable(this.artMappings.get(((String)Preconditions.checkNotNull((Object)id)).toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public Collection<Art> getAll() {
        return ImmutableList.copyOf(this.artMappings.values());
    }

    @Override
    public void registerDefaults() {
        for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
            this.artMappings.put(((Art)art).getId().toLowerCase(Locale.ENGLISH), (Art)art);
        }
    }

    @CustomCatalogRegistration
    public void customRegistration() {
        this.registerDefaults();
        RegistryHelper.mapFields(Arts.class, field -> {
            String name = field.replace("_", "");
            return this.artMappings.get(name.toLowerCase(Locale.ENGLISH));
        });
    }

    @AdditionalRegistration
    public void registerAdditionals() {
        for (EntityPainting.EnumArt art : EntityPainting.EnumArt.values()) {
            if (this.artMappings.containsValue(art)) continue;
            this.artMappings.put(((Art)art).getId().toLowerCase(Locale.ENGLISH), (Art)art);
        }
    }
}

