/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.common.registry.RegistryHelper;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

public final class ItemTypeRegistryModule
implements SpongeAdditionalCatalogRegistryModule<ItemType>,
AlternateCatalogRegistryModule<ItemType> {
    public static Item NONE_ITEM;
    public static ItemStack NONE;
    public static ItemStackSnapshot NONE_SNAPSHOT;
    @RegisterCatalog(value=ItemTypes.class)
    private final Map<String, ItemType> itemTypeMappings = new HashMap<String, ItemType>();

    public static ItemTypeRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public Map<String, ItemType> provideCatalogMap() {
        HashMap<String, ItemType> itemTypeMap = new HashMap<String, ItemType>();
        for (Map.Entry<String, ItemType> entry : this.itemTypeMappings.entrySet()) {
            itemTypeMap.put(entry.getKey().replace("minecraft:", ""), entry.getValue());
        }
        itemTypeMap.put("none", (ItemType)NONE_ITEM);
        return itemTypeMap;
    }

    @Override
    public Optional<ItemType> getById(String id) {
        Preconditions.checkNotNull((Object)id);
        if (!id.contains(":")) {
            id = "minecraft:" + id.toLowerCase(Locale.ENGLISH);
        }
        return Optional.ofNullable(this.itemTypeMappings.get(id));
    }

    @Override
    public Collection<ItemType> getAll() {
        return ImmutableList.copyOf(this.itemTypeMappings.values());
    }

    public void registerFromGameData(String id, ItemType itemType) {
        this.itemTypeMappings.put(id.toLowerCase(Locale.ENGLISH), itemType);
    }

    @Override
    public boolean allowsApiRegistration() {
        return false;
    }

    @Override
    public void registerAdditionalCatalog(ItemType extraCatalog) {
        this.itemTypeMappings.put(extraCatalog.getId().toLowerCase(Locale.ENGLISH), extraCatalog);
    }

    @Override
    public void registerDefaults() {
        NONE_ITEM = net.minecraft.item.ItemStack.field_190927_a.func_77973_b();
        NONE = (ItemStack)net.minecraft.item.ItemStack.field_190927_a;
        NONE_SNAPSHOT = NONE.createSnapshot();
        this.setItemNone();
    }

    private void setItemNone() {
        RegistryHelper.setFinalStatic(ItemStackSnapshot.class, "NONE", NONE_SNAPSHOT);
    }

    ItemTypeRegistryModule() {
    }

    private static final class Holder {
        static final ItemTypeRegistryModule INSTANCE = new ItemTypeRegistryModule();

        private Holder() {
        }
    }
}

