/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracking.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.profile.SpongeProfileManager;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.SpongeUsernameCache;

@Mixin(value={net.minecraft.world.chunk.Chunk.class}, priority=1111)
public abstract class MixinChunk_Tracker
implements Chunk,
IMixinChunk {
    private static final int NUM_XZ_BITS = 4;
    private static final int NUM_SHORT_Y_BITS = 8;
    private static final int NUM_INT_Y_BITS = 24;
    private static final int Y_SHIFT = 4;
    private static final short XZ_MASK = 15;
    private static final short Y_SHORT_MASK = 255;
    private static final int Y_INT_MASK = 0xFFFFFF;
    private SpongeProfileManager spongeProfileManager;
    private UserStorageService userStorageService;
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> field_150816_i;
    private Map<Integer, PlayerTracker> trackedIntBlockPositions = new HashMap<Integer, PlayerTracker>();
    private Map<Short, PlayerTracker> trackedShortBlockPositions = new HashMap<Short, PlayerTracker>();

    @Shadow
    public abstract ChunkPos func_76632_l();

    @Final
    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")}, remap=false)
    private void onConstructedTracker(World world, int x, int z, CallbackInfo ci) {
        if (!world.field_72995_K) {
            this.spongeProfileManager = (SpongeProfileManager)Sponge.getServer().getGameProfileManager();
            this.userStorageService = SpongeImpl.getGame().getServiceManager().provide(UserStorageService.class).get();
        }
    }

    @Override
    public void addTrackedBlockPosition(Block block, BlockPos pos, User user, PlayerTracker.Type trackerType) {
        SpongeConfig<? extends GeneralConfigBase> activeConfig;
        TileEntity tileEntity;
        if (this.field_76637_e.field_72995_K) {
            return;
        }
        if (PhaseTracker.getInstance().getCurrentState().tracksOwnersAndNotifiers()) {
            return;
        }
        if (user instanceof EntityPlayerMP && SpongeImplHooks.isFakePlayer((Entity)((EntityPlayerMP)user))) {
            return;
        }
        if (block instanceof ITileEntityProvider && (tileEntity = this.field_150816_i.get(pos)) != null) {
            IMixinTileEntity spongeTile = (IMixinTileEntity)tileEntity;
            if (trackerType == PlayerTracker.Type.NOTIFIER) {
                if (spongeTile.getSpongeNotifier() == user) {
                    return;
                }
                spongeTile.setSpongeNotifier(user);
            } else {
                if (spongeTile.getSpongeOwner() == user) {
                    return;
                }
                spongeTile.setSpongeOwner(user);
            }
        }
        if ((activeConfig = SpongeHooks.getActiveConfig((WorldServer)this.field_76637_e)).getConfig().getLogging().blockTrackLogging()) {
            if (!activeConfig.getConfig().getBlockTracking().getBlockBlacklist().contains(((BlockType)block).getId())) {
                SpongeHooks.logBlockTrack(this.field_76637_e, block, pos, user, true);
            } else {
                SpongeHooks.logBlockTrack(this.field_76637_e, block, pos, user, false);
            }
        }
        IMixinWorldInfo worldInfo = (IMixinWorldInfo)this.field_76637_e.func_72912_H();
        int indexForUniqueId = worldInfo.getIndexForUniqueId(user.getUniqueId());
        if (pos.func_177956_o() <= 255) {
            short blockPos = this.blockPosToShort(pos);
            PlayerTracker playerTracker = this.trackedShortBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (trackerType == PlayerTracker.Type.OWNER) {
                    playerTracker.ownerIndex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.trackedShortBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, trackerType));
            }
        } else {
            int blockPos = this.blockPosToInt(pos);
            PlayerTracker playerTracker = this.trackedIntBlockPositions.get(blockPos);
            if (playerTracker != null) {
                if (trackerType == PlayerTracker.Type.OWNER) {
                    playerTracker.ownerIndex = indexForUniqueId;
                    playerTracker.notifierIndex = indexForUniqueId;
                } else {
                    playerTracker.notifierIndex = indexForUniqueId;
                }
            } else {
                this.trackedIntBlockPositions.put(blockPos, new PlayerTracker(indexForUniqueId, trackerType));
            }
        }
    }

    @Override
    public Map<Integer, PlayerTracker> getTrackedIntPlayerPositions() {
        return this.trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> getTrackedShortPlayerPositions() {
        return this.trackedShortBlockPositions;
    }

    @Override
    public Optional<User> getBlockOwner(BlockPos pos) {
        int intKey = this.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackedIntBlockPositions.get(intKey);
        if (intTracker != null) {
            int notifierIndex = intTracker.ownerIndex;
            return this.getValidatedUser(intKey, notifierIndex);
        }
        short shortKey = this.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int notifierIndex = shortTracker.ownerIndex;
            return this.getValidatedUser(shortKey, notifierIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getBlockOwnerUUID(BlockPos pos) {
        int key = this.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            int ownerIndex = intTracker.ownerIndex;
            return this.getValidatedUUID(key, ownerIndex);
        }
        short shortKey = this.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int ownerIndex = shortTracker.ownerIndex;
            return this.getValidatedUUID(shortKey, ownerIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<User> getBlockNotifier(BlockPos pos) {
        int intKey = this.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackedIntBlockPositions.get(intKey);
        if (intTracker != null) {
            return this.getValidatedUser(intKey, intTracker.notifierIndex);
        }
        short shortKey = this.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            return this.getValidatedUser(shortKey, shortTracker.notifierIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getBlockNotifierUUID(BlockPos pos) {
        int key = this.blockPosToInt(pos);
        PlayerTracker intTracker = this.trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            return this.getValidatedUUID(key, intTracker.notifierIndex);
        }
        short shortKey = this.blockPosToShort(pos);
        PlayerTracker shortTracker = this.trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            return this.getValidatedUUID(shortKey, shortTracker.notifierIndex);
        }
        return Optional.empty();
    }

    private Optional<User> getValidatedUser(int key, int ownerIndex) {
        Optional<UUID> uuid = this.getValidatedUUID(key, ownerIndex);
        if (uuid.isPresent()) {
            UUID userUniqueId = uuid.get();
            EntityPlayer player = this.field_76637_e.func_152378_a(userUniqueId);
            if (player != null) {
                return Optional.of((User)player);
            }
            return this.getUserFromId(userUniqueId);
        }
        return Optional.empty();
    }

    private Optional<UUID> getValidatedUUID(int key, int ownerIndex) {
        UUID uuid = ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getUniqueIdForIndex(ownerIndex).orElse(null);
        if (uuid != null) {
            if (SpongeImpl.getGlobalConfig().getConfig().getWorld().getInvalidLookupUuids().contains(uuid)) {
                this.trackedIntBlockPositions.remove(key);
                return Optional.empty();
            }
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    private Optional<User> getUserFromId(UUID uuid) {
        String username = SpongeUsernameCache.getLastKnownUsername(uuid);
        if (username != null) {
            return this.userStorageService.get(GameProfile.of(uuid, username));
        }
        GameProfile profile = this.spongeProfileManager.getCache().getById(uuid).orElse(null);
        if (profile != null) {
            return this.userStorageService.get(profile);
        }
        this.spongeProfileManager.lookupUserAsync(uuid);
        return Optional.empty();
    }

    @Override
    public void setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
        if (pos.func_177956_o() <= 255) {
            short blockPos = this.blockPosToShort(pos);
            PlayerTracker shortTracker = this.trackedShortBlockPositions.get(blockPos);
            if (shortTracker != null) {
                shortTracker.notifierIndex = uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid);
            } else {
                this.trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        } else {
            int blockPos = this.blockPosToInt(pos);
            PlayerTracker intTracker = this.trackedIntBlockPositions.get(blockPos);
            if (intTracker != null) {
                intTracker.notifierIndex = uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid);
            } else {
                this.trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid), PlayerTracker.Type.NOTIFIER));
            }
        }
    }

    @Override
    public void setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
        if (pos.func_177956_o() <= 255) {
            short blockPos = this.blockPosToShort(pos);
            PlayerTracker shortTracker = this.trackedShortBlockPositions.get(blockPos);
            if (shortTracker != null) {
                shortTracker.ownerIndex = uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid);
            } else {
                this.trackedShortBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid), PlayerTracker.Type.OWNER));
            }
        } else {
            int blockPos = this.blockPosToInt(pos);
            PlayerTracker intTracker = this.trackedIntBlockPositions.get(blockPos);
            if (intTracker != null) {
                intTracker.ownerIndex = uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid);
            } else {
                this.trackedIntBlockPositions.put(blockPos, new PlayerTracker(uuid == null ? -1 : ((IMixinWorldInfo)this.field_76637_e.func_72912_H()).getIndexForUniqueId(uuid), PlayerTracker.Type.OWNER));
            }
        }
    }

    @Override
    public void setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.trackedShortBlockPositions = trackedPositions;
    }

    private int setNibble(int num, int data, int which, int bitsToReplace) {
        return num & ~(bitsToReplace << which * 4) | data << which * 4;
    }

    @Inject(method={"onLoad"}, at={@At(value="HEAD")})
    private void startLoad(CallbackInfo callbackInfo) {
        boolean isFake = ((IMixinWorld)this.field_76637_e).isFake();
        if (!isFake) {
            if (!SpongeImplHooks.isMainThread()) {
                PrettyPrinter printer = new PrettyPrinter(60).add("Illegal Async Chunk Load").centre().hr().addWrapped("Sponge relies on knowing when chunks are being loaded as chunks add entities to the parented world for management. These operations are generally not threadsafe and shouldn't be considered a \"Sponge bug \". Adding/removing entities from another thread to the world is never ok.", new Object[0]).add().add(" %s : %d, %d", "Chunk Pos", this.field_76635_g, this.field_76647_h).add().add(new Exception("Async Chunk Load Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
                return;
            }
            ((ChunkLoadContext)((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext().source(this)).world(this.field_76637_e)).chunk((net.minecraft.world.chunk.Chunk)this).buildAndSwitch();
        }
    }

    @Inject(method={"onLoad"}, at={@At(value="RETURN")})
    private void endLoad(CallbackInfo callbackInfo) {
        if (!((IMixinWorld)this.field_76637_e).isFake() && SpongeImplHooks.isMainThread()) {
            PhaseTracker.getInstance().getCurrentContext().close();
        }
    }

    private short blockPosToShort(BlockPos pos) {
        short serialized = (short)this.setNibble(0, pos.func_177958_n() & 0xF, 0, 4);
        serialized = (short)this.setNibble(serialized, pos.func_177956_o() & 0xFF, 1, 8);
        serialized = (short)this.setNibble(serialized, pos.func_177952_p() & 0xF, 3, 4);
        return serialized;
    }

    private int blockPosToInt(BlockPos pos) {
        int serialized = this.setNibble(0, pos.func_177958_n() & 0xF, 0, 4);
        serialized = this.setNibble(serialized, pos.func_177956_o() & 0xFFFFFF, 1, 24);
        serialized = this.setNibble(serialized, pos.func_177952_p() & 0xF, 7, 4);
        return serialized;
    }
}

