/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracking.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.profile.SpongeProfileManager;
import org.spongepowered.common.util.SpongeUsernameCache;

@Mixin(value={Entity.class}, priority=1111)
public abstract class MixinEntity_Tracker
implements org.spongepowered.api.entity.Entity,
IMixinEntity {
    private SpongeProfileManager spongeProfileManager;
    private UserStorageService userStorageService;
    @Shadow
    public World field_70170_p;
    @Nullable
    private UUID creator;
    @Nullable
    private UUID notifier;

    @Override
    public void trackEntityUniqueId(String nbtKey, @Nullable UUID uuid) {
        if ("Creator".equals(nbtKey)) {
            this.creator = uuid;
        } else if ("Notifier".equals(nbtKey)) {
            this.notifier = uuid;
        }
        NBTTagCompound spongeData = this.getSpongeData();
        if (!spongeData.func_74764_b(nbtKey)) {
            if (uuid == null) {
                return;
            }
            NBTTagCompound sourceNbt = new NBTTagCompound();
            sourceNbt.func_186854_a("UUID", uuid);
            spongeData.func_74782_a(nbtKey, (NBTBase)sourceNbt);
        } else {
            NBTTagCompound compoundTag = spongeData.func_74775_l(nbtKey);
            if (uuid == null) {
                spongeData.func_82580_o(nbtKey);
            } else {
                compoundTag.func_186854_a("UUID", uuid);
            }
        }
    }

    @Override
    public Optional<UUID> getCreator() {
        if (this.creator != null) {
            return Optional.of(this.creator);
        }
        Optional<User> user = this.getTrackedPlayer("Creator");
        if (user.isPresent()) {
            return Optional.of(user.get().getUniqueId());
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getNotifier() {
        if (this.notifier != null) {
            return Optional.of(this.notifier);
        }
        Optional<User> user = this.getTrackedPlayer("Notifier");
        if (user.isPresent()) {
            return Optional.of(user.get().getUniqueId());
        }
        return Optional.empty();
    }

    @Override
    public void setCreator(@Nullable UUID uuid) {
        this.trackEntityUniqueId("Creator", uuid);
    }

    @Override
    public void setNotifier(@Nullable UUID uuid) {
        this.trackEntityUniqueId("Notifier", uuid);
    }

    @Nullable
    private UUID getTrackedUniqueId(String nbtKey) {
        NBTTagCompound nbt;
        if (this.creator != null && "Creator".equals(nbtKey)) {
            return this.creator;
        }
        if (this instanceof IEntityOwnable) {
            IEntityOwnable ownable = (IEntityOwnable)this;
            Entity owner = ownable.func_70902_q();
            if (owner != null && owner instanceof EntityPlayer) {
                this.setCreator(owner.func_110124_au());
                return owner.func_110124_au();
            }
        } else if (this.notifier != null && "Notifier".equals(nbtKey)) {
            return this.notifier;
        }
        if (!(nbt = this.getSpongeData()).func_74764_b(nbtKey)) {
            return null;
        }
        NBTTagCompound creatorNbt = nbt.func_74775_l(nbtKey);
        if (!creatorNbt.func_74764_b("UUIDMost") && !creatorNbt.func_74764_b("UUIDLeast")) {
            return null;
        }
        UUID uniqueId = creatorNbt.func_186857_a("UUID");
        if ("Creator".equals(nbtKey)) {
            this.creator = uniqueId;
        } else if ("Notifier".equals(nbtKey)) {
            this.notifier = uniqueId;
        }
        return uniqueId;
    }

    @Override
    public Optional<User> getCreatorUser() {
        IEntityOwnable ownable;
        Entity owner;
        if (this.creator != null) {
            return this.getUserForUuid(this.creator);
        }
        if (this instanceof IEntityOwnable && (owner = (ownable = (IEntityOwnable)this).func_70902_q()) != null && owner instanceof EntityPlayer) {
            this.setCreator(owner.func_110124_au());
            return Optional.of((User)owner);
        }
        return this.getTrackedPlayer("Creator");
    }

    @Override
    public Optional<User> getNotifierUser() {
        if (this.notifier != null) {
            return this.getUserForUuid(this.notifier);
        }
        return this.getTrackedPlayer("Notifier");
    }

    @Override
    public Optional<User> getTrackedPlayer(String nbtKey) {
        UUID uuid = this.getTrackedUniqueId(nbtKey);
        if (uuid == null) {
            return Optional.empty();
        }
        return this.getUserForUuid(uuid);
    }

    private Optional<User> getUserForUuid(UUID uuid) {
        String username;
        Player player = Sponge.getServer().getPlayer(uuid).orElse(null);
        if (player != null) {
            return Optional.of(player);
        }
        if (this.spongeProfileManager == null) {
            this.spongeProfileManager = (SpongeProfileManager)Sponge.getServer().getGameProfileManager();
        }
        if (this.userStorageService == null) {
            this.userStorageService = SpongeImpl.getGame().getServiceManager().provide(UserStorageService.class).get();
        }
        if ((username = SpongeUsernameCache.getLastKnownUsername(uuid)) != null) {
            return this.userStorageService.get(GameProfile.of(uuid, username));
        }
        GameProfile profile = this.spongeProfileManager.getCache().getById(uuid).orElse(null);
        if (profile != null) {
            return this.userStorageService.get(profile);
        }
        this.spongeProfileManager.lookupUserAsync(uuid);
        return Optional.empty();
    }
}

