/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.exploit;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;

@Mixin(value={AnvilChunkLoader.class})
public class MixinAnvilChunkLoader_FilterInvalidEntities {
    private List<Entity> toUpdate = new ArrayList<Entity>();

    @Inject(method={"writeChunkToNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/WorldProvider;hasSkyLight()Z", shift=At.Shift.AFTER)})
    private void onWriteChunk(Chunk chunkIn, World worldIn, NBTTagCompound compound, CallbackInfo ci) {
        this.toUpdate.clear();
    }

    @Redirect(method={"writeChunkToNBT"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;writeToNBTOptional(Lnet/minecraft/nbt/NBTTagCompound;)Z"))
    private boolean onEntityWriteCheckForValidPosition(Entity entity, NBTTagCompound compound, Chunk chunkIn, World worldIn, NBTTagCompound chunkCompound) {
        if ((int)Math.floor(entity.field_70165_t) >> 4 != chunkIn.field_76635_g || (int)Math.floor(entity.field_70161_v) >> 4 != chunkIn.field_76647_h) {
            SpongeImpl.getLogger().log(Level.WARN, "{} is not in this chunk, skipping save. This is a bug fix to a vanilla bug. Do not report this to Sponge or Forge please.", (Object)entity);
            this.toUpdate.add(entity);
            return false;
        }
        if (entity.field_70128_L) {
            return false;
        }
        return entity.func_70039_c(compound);
    }

    @Redirect(method={"writeChunkToNBT"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;setTag(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V"), slice=@Slice(from=@At(value="CONSTANT", args={"stringValue=Entities"}), to=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;getTileEntityMap()Ljava/util/Map;")))
    private void onWriteEntities(NBTTagCompound nbtTagCompound, String key, NBTBase value, Chunk chunk, World world, NBTTagCompound chunkCompound) {
        if (!"Entities".equals(key)) {
            nbtTagCompound.func_74782_a(key, value);
            return;
        }
        if (!this.toUpdate.isEmpty()) {
            for (Entity entity : this.toUpdate) {
                world.func_72866_a(entity, false);
            }
            this.toUpdate.clear();
        }
        nbtTagCompound.func_74782_a(key, value);
    }
}

