/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollisions;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.CollisionModCategory;
import org.spongepowered.common.config.category.EntityCollisionCategory;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.IModData_Collisions;

@Mixin(value={Block.class})
public abstract class MixinBlock_Collisions
implements IModData_Collisions {
    private int maxCollisions = 8;
    private String modId;
    private String modBlockName;
    private boolean refreshCache = true;

    @Override
    public int getMaxCollisions() {
        return this.maxCollisions;
    }

    @Override
    public void setMaxCollisions(int max) {
        this.maxCollisions = max;
    }

    @Override
    public void setModDataName(String name) {
        this.modBlockName = name;
    }

    @Override
    public String getModDataId() {
        return this.modId;
    }

    @Override
    public void setModDataId(String id) {
        this.modId = id;
    }

    @Override
    public void requiresCollisionsCacheRefresh(boolean flag) {
        this.refreshCache = flag;
    }

    @Override
    public boolean requiresCollisionsCacheRefresh() {
        return this.refreshCache;
    }

    @Override
    public void initializeCollisionState(World worldIn) {
        SpongeConfig<? extends GeneralConfigBase> activeConfig = ((IMixinWorldServer)worldIn).getActiveConfig();
        SpongeConfig<GlobalConfig> globalConfig = SpongeImpl.getGlobalConfig();
        EntityCollisionCategory activeCollCat = activeConfig.getConfig().getEntityCollisionCategory();
        EntityCollisionCategory globalCollCat = ((GeneralConfigBase)globalConfig.getConfig()).getEntityCollisionCategory();
        this.setMaxCollisions(activeCollCat.getMaxEntitiesWithinAABB());
        boolean requiresSave = false;
        String[] ids = ((BlockType)((Object)this)).getId().split(":");
        String modId = ids[0];
        String name = ids[1];
        CollisionModCategory activeCollMod = activeCollCat.getModList().get(modId);
        CollisionModCategory globalCollMod = globalCollCat.getModList().get(modId);
        if (activeCollMod == null && activeCollCat.autoPopulateData()) {
            globalCollMod = new CollisionModCategory(modId);
            globalCollCat.getModList().put(modId, globalCollMod);
            globalCollMod.getBlockList().put(name, this.getMaxCollisions());
            globalConfig.save();
            return;
        }
        if (activeCollMod != null) {
            Integer blockMaxCollision;
            if (!activeCollMod.isEnabled()) {
                this.setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = activeCollMod.getDefaultMaxCollisions().get("blocks");
            if (modCollisionMax != null) {
                this.setMaxCollisions(modCollisionMax);
            }
            if ((blockMaxCollision = activeCollMod.getBlockList().get(name)) == null && activeCollCat.autoPopulateData()) {
                globalCollMod.getBlockList().put(name, this.getMaxCollisions());
                requiresSave = true;
            } else if (blockMaxCollision != null) {
                this.setMaxCollisions(blockMaxCollision);
            }
        }
        if (this.getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfig.save();
        }
    }
}

