/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Vine;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenVines.class})
public abstract class MixinWorldGenVines
extends WorldGenerator
implements Vine {
    private VariableAmount count;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.count = VariableAmount.fixed(50.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.VINE;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos position = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.count.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getX());
            this.func_180709_b(world, random, position.func_177982_a(x, 128, z));
        }
    }

    @Override
    public VariableAmount getVinesPerChunk() {
        return this.count;
    }

    @Override
    public void setVinesPerChunk(VariableAmount count) {
        this.count = (VariableAmount)Preconditions.checkNotNull((Object)count);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Type", (Object)"Vine").add("PerChunk", (Object)this.count).toString();
    }
}

