/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.biome;

import java.util.Iterator;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeJungle;
import org.spongepowered.api.data.type.ShrubTypes;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.api.world.gen.populator.Melon;
import org.spongepowered.api.world.gen.populator.Shrub;
import org.spongepowered.api.world.gen.populator.Vine;
import org.spongepowered.api.world.gen.type.BiomeTreeTypes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.mixin.core.world.biome.MixinBiome;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;

@Mixin(value={BiomeJungle.class})
public abstract class MixinBiomeJungle
extends MixinBiome {
    @Shadow
    @Final
    private boolean field_150614_aC;

    @Override
    public void buildPopulators(World world, SpongeBiomeGenerationSettings gensettings) {
        super.buildPopulators(world, gensettings);
        BiomeDecorator theBiomeDecorator = this.field_76760_I;
        Iterator<Populator> it = gensettings.getPopulators().iterator();
        while (it.hasNext()) {
            TableEntry entry;
            Shrub s;
            Populator next = it.next();
            if (!(next instanceof Shrub) || (s = (Shrub)next).getTypes().size() != 1 || !((entry = s.getTypes().getEntries().get(0)) instanceof WeightedObject) || ((WeightedObject)entry).get() != ShrubTypes.TALL_GRASS) continue;
            it.remove();
        }
        Shrub grass = Shrub.builder().perChunk(theBiomeDecorator.field_76803_B * 128).type(ShrubTypes.FERN, 1).type(ShrubTypes.TALL_GRASS, 3).build();
        gensettings.getPopulators().add(grass);
        Melon melon = Melon.builder().perChunk(64).build();
        gensettings.getPopulators().add(melon);
        Vine vine = Vine.builder().perChunk(50).build();
        gensettings.getPopulators().add(vine);
        gensettings.getPopulators().removeAll(gensettings.getPopulators(Forest.class));
        Forest.Builder forest = Forest.builder();
        forest.perChunk(VariableAmount.baseWithOptionalAddition((double)theBiomeDecorator.field_76832_z, 1.0, 0.1));
        forest.type(BiomeTreeTypes.OAK.getLargePopulatorObject().get(), 1.0);
        forest.type(BiomeTreeTypes.JUNGLE_BUSH.getPopulatorObject(), 4.5);
        if (!this.field_150614_aC) {
            forest.type(BiomeTreeTypes.JUNGLE.getLargePopulatorObject().get(), 1.2);
            forest.type(BiomeTreeTypes.JUNGLE.getPopulatorObject(), 3.0);
        } else {
            forest.type(BiomeTreeTypes.JUNGLE.getPopulatorObject(), 4.5);
        }
        gensettings.getPopulators().add(0, forest.build());
    }
}

