/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import java.io.IOException;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.FlatGeneratorInfo;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.data.persistence.JsonDataFormat;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.world.GeneratorTypeRegistryModule;

@NonnullByDefault
@Mixin(value={WorldType.class})
public abstract class MixinWorldType
implements GeneratorType {
    @Shadow
    @Final
    private String field_77133_f;
    @Shadow
    @Final
    private int field_82748_f;

    @Inject(method={"<init>(ILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void onConstructSpongeRegister(int id, String name, CallbackInfo callbackInfo) {
        GeneratorTypeRegistryModule.getInstance().registerAdditionalCatalog(this);
    }

    @Override
    public String getId() {
        return SpongeImplHooks.getModIdFromClass(this.getClass()) + ":" + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.field_77133_f);
    }

    @Override
    public String getName() {
        return this.field_77133_f;
    }

    @Override
    public DataContainer getGeneratorSettings() {
        if (this == WorldType.field_77138_c) {
            String defaultSettings = FlatGeneratorInfo.func_82649_e().toString();
            return DataContainer.createNew().set(DataQueries.WORLD_CUSTOM_SETTINGS, (Object)defaultSettings);
        }
        if (this == WorldType.field_180271_f) {
            try {
                return JsonDataFormat.serialize(ChunkGeneratorSettings.Factory.field_177901_a, new ChunkGeneratorSettings.Factory());
            }
            catch (JsonParseException | IOException e) {
                throw new AssertionError("Failed to serialize default settings of CUSTOMIZED world type", e);
            }
        }
        return DataContainer.createNew();
    }

    @Override
    public WorldGenerator createGenerator(World world) {
        Preconditions.checkNotNull((Object)world);
        return ((IMixinWorldServer)((Object)world)).createWorldGenerator(this.getGeneratorSettings());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.field_82748_f;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorldType)) {
            return false;
        }
        WorldType other = (WorldType)obj;
        return this.getName().equals(other.func_77127_a()) && this.field_82748_f == other.func_82747_f();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("settings", (Object)this.getGeneratorSettings()).toString();
    }
}

