/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.util.SpawnerSpawnType;

@Mixin(value={WorldEntitySpawner.class})
public abstract class MixinWorldEntitySpawner {
    private static final String BIOME_CAN_SPAWN_ANIMAL = "Lnet/minecraft/world/WorldEntitySpawner;canCreatureTypeSpawnAtLocation(Lnet/minecraft/entity/EntityLiving$SpawnPlacementType;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z";
    private static final String WEIGHTED_RANDOM_GET = "Lnet/minecraft/util/WeightedRandom;getRandomItem(Ljava/util/Random;Ljava/util/List;)Lnet/minecraft/util/WeightedRandom$Item;";
    @Nullable
    private static EntityType spawnerEntityType;
    private List<Chunk> eligibleSpawnChunks = new ArrayList<Chunk>();

    @Overwrite
    public int func_77192_a(WorldServer worldServerIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return 0;
        }
        try (Object context = GenerationPhase.State.WORLD_SPAWNER_SPAWNING.createPhaseContext().world((net.minecraft.world.World)worldServerIn);){
            ((PhaseContext)context).buildAndSwitch();
            Iterator<Chunk> chunkIterator = this.eligibleSpawnChunks.iterator();
            while (chunkIterator.hasNext()) {
                Chunk chunk = chunkIterator.next();
                ((IMixinChunk)chunk).setIsSpawning(false);
                chunkIterator.remove();
            }
            IMixinWorldServer spongeWorld = (IMixinWorldServer)worldServerIn;
            spongeWorld.getTimingsHandler().mobSpawn.startTiming();
            int chunkSpawnCandidates = 0;
            int mobSpawnRange = Math.min(((IMixinWorldServer)worldServerIn).getActiveConfig().getConfig().getWorld().getMobSpawnRange(), ((World)worldServerIn).getViewDistance());
            int MOB_SPAWN_COUNT_DIV = (2 * mobSpawnRange + 1) * (2 * mobSpawnRange + 1);
            for (EntityPlayer entityplayer : worldServerIn.field_73010_i) {
                if (!((IMixinEntityPlayer)entityplayer).affectsSpawning() || entityplayer.func_175149_v()) continue;
                int playerPosX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
                int playerPosZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
                for (int i = -mobSpawnRange; i <= mobSpawnRange; ++i) {
                    for (int j = -mobSpawnRange; j <= mobSpawnRange; ++j) {
                        PlayerChunkMapEntry playerchunkmapentry;
                        boolean flag = i == -mobSpawnRange || i == mobSpawnRange || j == -mobSpawnRange || j == mobSpawnRange;
                        Chunk chunk = ((IMixinChunkProviderServer)worldServerIn.func_72863_F()).getLoadedChunkWithoutMarkingActive(i + playerPosX, j + playerPosZ);
                        if (chunk == null || chunk.field_189550_d && !((IMixinChunk)chunk).isPersistedChunk()) continue;
                        IMixinChunk spongeChunk = (IMixinChunk)chunk;
                        ++chunkSpawnCandidates;
                        ChunkPos chunkPos = chunk.func_76632_l();
                        if (flag || !worldServerIn.func_175723_af().func_177730_a(chunkPos) || (playerchunkmapentry = worldServerIn.func_184164_w().func_187301_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) == null || !playerchunkmapentry.func_187274_e() || spongeChunk.isSpawning()) continue;
                        this.eligibleSpawnChunks.add(chunk);
                        spongeChunk.setIsSpawning(true);
                    }
                }
            }
            if (this.eligibleSpawnChunks.size() == 0) {
                spongeWorld.getTimingsHandler().mobSpawn.stopTiming();
                int n = 0;
                return n;
            }
            int totalSpawned = 0;
            long worldTotalTime = worldServerIn.func_82737_E();
            SpongeConfig<? extends GeneralConfigBase> activeConfig = ((IMixinWorldServer)worldServerIn).getActiveConfig();
            block18: for (EnumCreatureType enumCreatureType : EnumCreatureType.values()) {
                int maxCount;
                int entityCount;
                int limit = 0;
                int tickRate = 0;
                if (enumCreatureType == EnumCreatureType.MONSTER) {
                    limit = activeConfig.getConfig().getSpawner().getMonsterSpawnLimit();
                    tickRate = activeConfig.getConfig().getSpawner().getMonsterTickRate();
                } else if (enumCreatureType == EnumCreatureType.CREATURE) {
                    limit = activeConfig.getConfig().getSpawner().getAnimalSpawnLimit();
                    tickRate = activeConfig.getConfig().getSpawner().getAnimalTickRate();
                } else if (enumCreatureType == EnumCreatureType.WATER_CREATURE) {
                    limit = activeConfig.getConfig().getSpawner().getAquaticSpawnLimit();
                    tickRate = activeConfig.getConfig().getSpawner().getAquaticTickRate();
                } else if (enumCreatureType == EnumCreatureType.AMBIENT) {
                    limit = activeConfig.getConfig().getSpawner().getAmbientSpawnLimit();
                    tickRate = activeConfig.getConfig().getSpawner().getAmbientTickRate();
                }
                if (limit == 0 || tickRate == 0 || worldTotalTime % (long)tickRate != 0L || enumCreatureType.func_75599_d() && !spawnPeacefulMobs || !enumCreatureType.func_75599_d() && !spawnHostileMobs || (entityCount = SpongeImplHooks.countEntities(worldServerIn, enumCreatureType, true)) > (maxCount = limit * chunkSpawnCandidates / MOB_SPAWN_COUNT_DIV)) continue;
                chunkIterator = this.eligibleSpawnChunks.iterator();
                int mobLimit = maxCount - entityCount + 1;
                block19: while (chunkIterator.hasNext() && mobLimit > 0) {
                    Chunk chunk = chunkIterator.next();
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                    BlockPos blockpos = MixinWorldEntitySpawner.getRandomChunkPosition((net.minecraft.world.World)worldServerIn, chunk);
                    int k1 = blockpos.func_177958_n();
                    int l1 = blockpos.func_177956_o();
                    int i2 = blockpos.func_177952_p();
                    IBlockState iblockstate = worldServerIn.func_180495_p(blockpos);
                    if (iblockstate.func_185915_l()) continue;
                    int spawnCount = 0;
                    block20: for (int spawnLimit = 0; spawnLimit < 3; ++spawnLimit) {
                        int l2 = k1;
                        int i3 = l1;
                        int j3 = i2;
                        Biome.SpawnListEntry spawnListEntry = null;
                        IEntityLivingData ientitylivingdata = null;
                        int l3 = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                        for (int i4 = 0; i4 < l3; ++i4) {
                            EntityLiving entityliving;
                            mutableBlockPos.func_181079_c(l2 += worldServerIn.field_73012_v.nextInt(6) - worldServerIn.field_73012_v.nextInt(6), i3 += worldServerIn.field_73012_v.nextInt(1) - worldServerIn.field_73012_v.nextInt(1), j3 += worldServerIn.field_73012_v.nextInt(6) - worldServerIn.field_73012_v.nextInt(6));
                            double spawnX = (float)l2 + 0.5f;
                            double spawnY = i3;
                            double spawnZ = (float)j3 + 0.5f;
                            if (worldServerIn.func_175636_b(spawnX, spawnY, spawnZ, 24.0) || !(worldServerIn.func_175694_M().func_177954_c(spawnX, spawnY, spawnZ) >= 576.0)) continue;
                            if (spawnListEntry == null && (spawnListEntry = worldServerIn.func_175734_a(enumCreatureType, (BlockPos)mutableBlockPos)) == null) continue block20;
                            CatalogType entityType = EntityTypeRegistryModule.getInstance().getForClass(spawnListEntry.field_76300_b);
                            if (entityType != null) {
                                Vector3d vector3d = new Vector3d(spawnX, spawnY, spawnZ);
                                Transform<World> transform = new Transform<World>((World)worldServerIn, vector3d);
                                ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), (EntityType)entityType, transform);
                                if (SpongeImpl.postEvent(event)) continue;
                            }
                            if (!worldServerIn.func_175732_a(enumCreatureType, spawnListEntry, (BlockPos)mutableBlockPos) || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntitySpawnPlacementRegistry.func_180109_a((Class)spawnListEntry.field_76300_b), (net.minecraft.world.World)worldServerIn, (BlockPos)mutableBlockPos)) continue;
                            try {
                                entityliving = (EntityLiving)spawnListEntry.field_76300_b.getConstructor(net.minecraft.world.World.class).newInstance(worldServerIn);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue block18;
                            }
                            entityliving.func_70012_b(spawnX, spawnY, spawnZ, worldServerIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                            boolean entityNotColliding = entityliving.func_70058_J();
                            SpawnerSpawnType type = SpongeImplHooks.canEntitySpawnHere(entityliving, entityNotColliding);
                            if (type != SpawnerSpawnType.NONE) {
                                if (type == SpawnerSpawnType.NORMAL) {
                                    ientitylivingdata = entityliving.func_180482_a(worldServerIn.func_175649_E(new BlockPos((Entity)entityliving)), ientitylivingdata);
                                }
                                if (entityNotColliding) {
                                    ++spawnCount;
                                    worldServerIn.func_72838_d((Entity)entityliving);
                                } else {
                                    entityliving.func_70106_y();
                                }
                                if (--mobLimit <= 0 || spawnCount >= SpongeImplHooks.getMaxSpawnPackSize(entityliving)) continue block19;
                            }
                            totalSpawned += spawnCount;
                        }
                    }
                }
            }
            spongeWorld.getTimingsHandler().mobSpawn.stopTiming();
            int n = totalSpawned;
            return n;
        }
    }

    private static BlockPos getRandomChunkPosition(net.minecraft.world.World worldIn, Chunk chunk) {
        int i = chunk.field_76635_g * 16 + worldIn.field_73012_v.nextInt(16);
        int j = chunk.field_76647_h * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }

    @Overwrite
    private static BlockPos func_180621_a(net.minecraft.world.World worldIn, int x, int z) {
        Chunk chunk = ((IMixinChunkProviderServer)worldIn.func_72863_F()).getLoadedChunkWithoutMarkingActive(x, z);
        if (chunk == null || chunk.field_189550_d && !((IMixinChunk)chunk).isPersistedChunk()) {
            return null;
        }
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }

    @Inject(method={"performWorldGenSpawning"}, at={@At(value="HEAD")})
    private static void onPerformWorldGenSpawningHead(net.minecraft.world.World worldServer, Biome biome, int j, int k, int l, int m, Random rand, CallbackInfo ci) {
        ((GenericGenerationContext)((GenericGenerationContext)GenerationPhase.State.WORLD_SPAWNER_SPAWNING.createPhaseContext().source(worldServer)).world(worldServer)).buildAndSwitch();
    }

    @Inject(method={"performWorldGenSpawning"}, at={@At(value="RETURN")})
    private static void onPerformWorldGenSpawningReturn(net.minecraft.world.World worldServer, Biome biome, int j, int k, int l, int m, Random rand, CallbackInfo ci) {
        PhaseTracker.getInstance().getCurrentContext().close();
        spawnerEntityType = null;
    }

    @Redirect(method={"performWorldGenSpawning"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldEntitySpawner;canCreatureTypeSpawnAtLocation(Lnet/minecraft/entity/EntityLiving$SpawnPlacementType;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z"))
    private static boolean onCanGenerate(EntityLiving.SpawnPlacementType type, net.minecraft.world.World worldIn, BlockPos pos) {
        return WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)type, (net.minecraft.world.World)worldIn, (BlockPos)pos) && MixinWorldEntitySpawner.check(pos, worldIn);
    }

    @Redirect(method={"performWorldGenSpawning"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/WeightedRandom;getRandomItem(Ljava/util/Random;Ljava/util/List;)Lnet/minecraft/util/WeightedRandom$Item;"))
    private static WeightedRandom.Item onGetRandom(Random random, List<Biome.SpawnListEntry> collection) {
        Biome.SpawnListEntry entry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)random, collection);
        MixinWorldEntitySpawner.setEntityType(entry.field_76300_b);
        return entry;
    }

    private static void setEntityType(Class<? extends Entity> entityclass) {
        spawnerEntityType = EntityTypeRegistryModule.getInstance().getForClass((Class)entityclass);
    }

    private static boolean check(BlockPos pos, net.minecraft.world.World world) {
        EntityType entityType = spawnerEntityType;
        if (entityType == null) {
            return true;
        }
        Vector3d vector3d = new Vector3d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        Transform<World> transform = new Transform<World>((World)world, vector3d);
        Sponge.getCauseStackManager().pushCause(world);
        ConstructEntityEvent.Pre event = SpongeEventFactory.createConstructEntityEventPre(Sponge.getCauseStackManager().getCurrentCause(), entityType, transform);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        return !event.isCancelled();
    }
}

