/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.tileentity.Banner;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.meta.SpongePatternLayer;
import org.spongepowered.common.interfaces.block.tile.IMixinBanner;
import org.spongepowered.common.mixin.core.tileentity.MixinTileEntity;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.util.NonNullArrayList;

@NonnullByDefault
@Mixin(value={TileEntityBanner.class})
public abstract class MixinTileEntityBanner
extends MixinTileEntity
implements Banner,
IMixinBanner {
    @Shadow
    private EnumDyeColor field_175120_a;
    @Shadow
    private NBTTagList field_175118_f;
    private List<PatternLayer> patternLayers = Lists.newArrayList();

    @Inject(method={"setItemValues"}, at={@At(value="RETURN")})
    private void onSetItemValues(CallbackInfo ci) {
        this.updatePatterns();
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        this.updatePatterns();
    }

    @Override
    public void sendDataToContainer(DataView dataView) {
        dataView.set(Keys.BANNER_PATTERNS.getQuery(), Lists.newArrayList(this.patternLayers));
        dataView.set(Keys.BANNER_BASE_COLOR.getQuery(), (Object)this.field_175120_a.func_176767_b());
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getBannerData());
    }

    public void markDirtyAndUpdate() {
        this.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.func_174877_v());
        }
    }

    private void updatePatterns() {
        this.patternLayers.clear();
        if (this.field_175118_f != null) {
            SpongeGameRegistry registry = SpongeImpl.getRegistry();
            for (int i = 0; i < this.field_175118_f.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = this.field_175118_f.func_150305_b(i);
                String patternId = tagCompound.func_74779_i("Pattern");
                this.patternLayers.add(new SpongePatternLayer(SpongeImpl.getRegistry().getType(BannerPatternShape.class, patternId).get(), registry.getType(DyeColor.class, EnumDyeColor.func_176766_a((int)tagCompound.func_74762_e("Color")).func_176610_l()).get()));
            }
        }
        this.markDirtyAndUpdate();
    }

    @Override
    public List<PatternLayer> getLayers() {
        return new ArrayList<PatternLayer>(this.patternLayers);
    }

    @Override
    public void setLayers(List<PatternLayer> layers) {
        this.patternLayers = new NonNullArrayList<PatternLayer>();
        this.patternLayers.addAll(layers);
        this.field_175118_f = new NBTTagList();
        for (PatternLayer layer : this.patternLayers) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("Pattern", layer.getShape().getName());
            compound.func_74768_a("Color", ((EnumDyeColor)layer.getColor()).func_176767_b());
            this.field_175118_f.func_74742_a((NBTBase)compound);
        }
        this.markDirtyAndUpdate();
    }

    @Override
    public DyeColor getBaseColor() {
        return (DyeColor)this.field_175120_a;
    }

    @Override
    public void setBaseColor(DyeColor baseColor) {
        Preconditions.checkNotNull((Object)baseColor, (Object)"Null DyeColor!");
        try {
            EnumDyeColor color;
            this.field_175120_a = color = (EnumDyeColor)baseColor;
        }
        catch (Exception e) {
            this.field_175120_a = EnumDyeColor.BLACK;
        }
        this.markDirtyAndUpdate();
    }
}

