/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import co.aikar.timings.TimingsManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveHandler;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.command.TabCompleteEvent;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.ChunkTicketManager;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.command.SpongeCommandManager;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.CauseTrackerCrashHandler;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.interfaces.IMixinCommandSender;
import org.spongepowered.common.interfaces.IMixinCommandSource;
import org.spongepowered.common.interfaces.IMixinMinecraftServer;
import org.spongepowered.common.interfaces.IMixinSubject;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.profile.SpongeProfileManager;
import org.spongepowered.common.resourcepack.SpongeResourcePack;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer
implements Server,
ConsoleSource,
IMixinSubject,
IMixinCommandSource,
IMixinCommandSender,
IMixinMinecraftServer {
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    @Final
    public Profiler field_71304_b;
    @Shadow
    @Final
    public long[] field_71311_j;
    @Shadow
    private boolean field_71289_N;
    @Shadow
    private boolean field_71316_v;
    @Shadow
    private int field_71315_w;
    @Shadow
    private String field_71286_C;
    @Shadow
    public WorldServer[] field_71305_c;
    @Shadow
    private Thread field_175590_aa;
    @Shadow
    @Final
    private DataFixer field_184112_s;
    @Nullable
    private List<String> currentTabCompletionOptions;
    private ResourcePack resourcePack;
    private boolean enableSaving = true;
    private GameProfileManager profileManager;
    private MessageChannel broadcastChannel = MessageChannel.TO_ALL;
    @Nullable
    private Integer dimensionId;

    @Shadow
    public abstract void func_145747_a(ITextComponent var1);

    @Shadow
    public abstract void func_71263_m();

    @Shadow
    public abstract boolean func_71266_T();

    @Shadow
    public abstract boolean func_71278_l();

    @Shadow
    public abstract boolean func_71225_e();

    @Shadow
    public abstract boolean func_71199_h();

    @Shadow
    public abstract boolean func_71264_H();

    @Shadow
    public abstract String func_71270_I();

    @Shadow
    public abstract PlayerList func_184103_al();

    @Shadow
    public abstract EnumDifficulty func_147135_j();

    @Shadow
    public abstract GameType func_71265_f();

    @Shadow
    protected abstract void func_71192_d(String var1);

    @Shadow
    protected abstract void func_71216_a_(String var1, int var2);

    @Shadow
    protected abstract void func_71243_i();

    @Shadow
    protected abstract void func_71237_c(String var1);

    @Shadow
    public abstract void func_175584_a(String var1, ISaveHandler var2);

    @Shadow
    public abstract boolean func_71255_r();

    @Shadow
    public abstract int func_143007_ar();

    @Shadow
    public abstract void shadow$func_143006_e(int var1);

    @Shadow
    public abstract boolean func_71262_S();

    @Override
    public Optional<World> getWorld(String worldName) {
        return WorldManager.getWorld(worldName);
    }

    @Override
    public ChunkLayout getChunkLayout() {
        return SpongeChunkLayout.instance;
    }

    @Override
    public Optional<WorldProperties> getWorldProperties(String worldName) {
        return WorldManager.getWorldProperties(worldName);
    }

    @Override
    public Collection<WorldProperties> getAllWorldProperties() {
        return WorldManager.getAllWorldProperties();
    }

    @Override
    public MessageChannel getBroadcastChannel() {
        return this.broadcastChannel;
    }

    @Override
    public void setBroadcastChannel(MessageChannel channel) {
        this.broadcastChannel = (MessageChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
    }

    @Override
    public Optional<InetSocketAddress> getBoundAddress() {
        return Optional.empty();
    }

    @Override
    public boolean hasWhitelist() {
        return this.func_184103_al().field_72409_l;
    }

    @Override
    public void setHasWhitelist(boolean enabled) {
        this.func_184103_al().func_72371_a(enabled);
    }

    @Override
    public boolean getOnlineMode() {
        return this.func_71266_T();
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        if (this.func_184103_al() == null || this.func_184103_al().func_181057_v() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.func_184103_al().func_181057_v());
    }

    @Override
    public Optional<Player> getPlayer(UUID uniqueId) {
        if (this.func_184103_al() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Player)this.func_184103_al().func_177451_a(uniqueId));
    }

    @Override
    public Optional<Player> getPlayer(String name) {
        if (this.func_184103_al() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Player)this.func_184103_al().func_152612_a(name));
    }

    @Override
    public Text getMotd() {
        return SpongeTexts.fromLegacy(this.field_71286_C);
    }

    @Override
    public int getMaxPlayers() {
        if (this.func_184103_al() == null) {
            return 0;
        }
        return this.func_184103_al().func_72352_l();
    }

    @Override
    public int getRunningTimeTicks() {
        return this.field_71315_w;
    }

    @Override
    public double getTicksPerSecond() {
        double nanoSPerTick = MathHelper.func_76127_a((long[])this.field_71311_j);
        return 1000.0 / Math.max(50.0, nanoSPerTick / 1000000.0);
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    @Override
    public String getSubjectCollectionIdentifier() {
        return "system";
    }

    @Override
    public Tristate permDefault(String permission) {
        return Tristate.TRUE;
    }

    @Override
    public ConsoleSource getConsole() {
        return this;
    }

    @Override
    public ICommandSender asICommandSender() {
        return (MinecraftServer)this;
    }

    @Override
    public CommandSource asCommandSource() {
        return this;
    }

    @Override
    public void shutdown() {
        this.func_71263_m();
    }

    @Override
    public void shutdown(Text kickMessage) {
        for (Player player : this.getOnlinePlayers()) {
            player.kick(kickMessage);
        }
        this.func_71263_m();
    }

    @Overwrite
    public void func_71247_a(String overworldFolder, String worldName, long seed, WorldType type, String generatorOptions) {
        SpongeCommonEventFactory.convertingMapFormat = true;
        this.func_71237_c(overworldFolder);
        SpongeCommonEventFactory.convertingMapFormat = false;
        this.func_71192_d("menu.loadingLevel");
        WorldManager.loadAllWorlds(seed, type, generatorOptions);
        this.func_184103_al().func_72364_a(this.field_71305_c);
        this.func_147139_a(this.func_147135_j());
    }

    @Overwrite
    public void func_71222_d() {
        for (WorldServer worldServer : this.field_71305_c) {
            this.prepareSpawnArea(worldServer);
        }
        this.func_71243_i();
    }

    @Override
    public void prepareSpawnArea(WorldServer worldServer) {
        WorldProperties worldProperties = (WorldProperties)worldServer.func_72912_H();
        if (!((IMixinWorldInfo)((Object)worldProperties)).isValid() || !worldProperties.doesGenerateSpawnOnLoad()) {
            return;
        }
        IMixinChunkProviderServer chunkProviderServer = (IMixinChunkProviderServer)worldServer.func_72863_F();
        chunkProviderServer.setForceChunkRequests(true);
        try (Object context = ((GenericGenerationContext)GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext().source(worldServer)).world((net.minecraft.world.World)worldServer);){
            ((PhaseContext)context).buildAndSwitch();
            int i = 0;
            this.func_71192_d("menu.generatingTerrain");
            field_147145_h.info("Preparing start region for level {} ({})", (Object)((IMixinWorldServer)worldServer).getDimensionId(), (Object)((World)worldServer).getName());
            BlockPos blockpos = worldServer.func_175694_M();
            long j = MinecraftServer.func_130071_aq();
            for (int k = -192; k <= 192 && this.func_71278_l(); k += 16) {
                for (int l = -192; l <= 192 && this.func_71278_l(); l += 16) {
                    long i1 = MinecraftServer.func_130071_aq();
                    if (i1 - j > 1000L) {
                        this.func_71216_a_("Preparing spawn area", i * 100 / 625);
                        j = i1;
                    }
                    ++i;
                    worldServer.func_72863_F().func_186025_d(blockpos.func_177958_n() + k >> 4, blockpos.func_177952_p() + l >> 4);
                }
            }
            this.func_71243_i();
        }
        chunkProviderServer.setForceChunkRequests(false);
    }

    @Override
    public Optional<World> loadWorld(UUID uuid) {
        return WorldManager.loadWorld(uuid);
    }

    @Override
    public Optional<World> loadWorld(WorldProperties properties) {
        return WorldManager.loadWorld(properties);
    }

    @Override
    public Optional<World> loadWorld(String worldName) {
        return WorldManager.loadWorld(worldName);
    }

    @Override
    public WorldProperties createWorldProperties(String folderName, WorldArchetype archetype) {
        return WorldManager.createWorldProperties(folderName, archetype);
    }

    @Override
    public boolean unloadWorld(World world) {
        return ((IMixinWorldServer)((Object)world)).getDimensionId() != 0 && WorldManager.unloadWorld((WorldServer)world, false);
    }

    @Override
    public Collection<World> getWorlds() {
        return Collections.unmodifiableCollection(WorldManager.getWorlds());
    }

    @Override
    public Optional<World> getWorld(UUID uniqueId) {
        for (WorldServer worldserver : WorldManager.getWorlds()) {
            if (!((World)worldserver).getUniqueId().equals(uniqueId)) continue;
            return Optional.of((World)worldserver);
        }
        return Optional.empty();
    }

    @Override
    public Optional<WorldProperties> getDefaultWorld() {
        return WorldManager.getWorldByDimensionId(0).map(worldServer -> ((World)worldServer).getProperties());
    }

    @Override
    public String getDefaultWorldName() {
        Preconditions.checkState((this.func_71270_I() != null ? 1 : 0) != 0, (Object)"Attempt made to grab default world name too early!");
        return this.func_71270_I();
    }

    @Override
    public Collection<WorldProperties> getUnloadedWorlds() {
        return (Collection)WorldManager.getAllWorldProperties().stream().filter(props -> !this.getWorld(props.getUniqueId()).isPresent()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Optional<WorldProperties> getWorldProperties(UUID uniqueId) {
        return WorldManager.getWorldProperties(uniqueId);
    }

    @Override
    public CompletableFuture<Optional<WorldProperties>> copyWorld(WorldProperties worldProperties, String copyName) {
        return WorldManager.copyWorld(worldProperties, copyName);
    }

    @Override
    public Optional<WorldProperties> renameWorld(WorldProperties worldProperties, String newName) {
        return WorldManager.renameWorld(worldProperties, newName);
    }

    @Override
    public CompletableFuture<Boolean> deleteWorld(WorldProperties worldProperties) {
        return WorldManager.deleteWorld(worldProperties);
    }

    @Override
    public boolean saveWorldProperties(WorldProperties properties) {
        return WorldManager.saveWorldProperties(properties);
    }

    @Override
    public ChunkTicketManager getChunkTicketManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GameProfileManager getGameProfileManager() {
        if (this.profileManager == null) {
            this.profileManager = new SpongeProfileManager();
        }
        return this.profileManager;
    }

    @Override
    public Optional<ResourcePack> getDefaultResourcePack() {
        return Optional.ofNullable(this.resourcePack);
    }

    @Inject(method={"setResourcePack(Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="HEAD")})
    public void onSetResourcePack(String url, String hash, CallbackInfo ci) {
        if (url.length() == 0) {
            this.resourcePack = null;
        } else {
            try {
                this.resourcePack = SpongeResourcePack.create(url, hash);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setSaveEnabled(boolean enabled) {
        this.enableSaving = enabled;
    }

    @Override
    public Optional<Scoreboard> getServerScoreboard() {
        return WorldManager.getWorldByDimensionId(0).map(worldServer -> (Scoreboard)worldServer.func_96441_U());
    }

    @Redirect(method={"getTabCompletions"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList()Ljava/util/ArrayList;", remap=false))
    private ArrayList<String> onGetTabCompletionCreateList() {
        ArrayList<String> list = new ArrayList<String>();
        this.currentTabCompletionOptions = list;
        return list;
    }

    @Inject(method={"getTabCompletions"}, at={@At(value="RETURN", ordinal=0)})
    private void onTabCompleteChat(ICommandSender sender, String input, BlockPos pos, boolean usingBlock, CallbackInfoReturnable<List<String>> cir) {
        List completions = (List)Preconditions.checkNotNull(this.currentTabCompletionOptions, (Object)"currentTabCompletionOptions");
        this.currentTabCompletionOptions = null;
        Sponge.getCauseStackManager().pushCause(sender);
        TabCompleteEvent.Chat event = SpongeEventFactory.createTabCompleteEventChat(Sponge.getCauseStackManager().getCurrentCause(), (List)ImmutableList.copyOf((Collection)completions), completions, input, Optional.ofNullable(MixinMinecraftServer.getTarget(sender, pos)), usingBlock);
        Sponge.getEventManager().post(event);
        Sponge.getCauseStackManager().popCause();
        if (event.isCancelled()) {
            completions.clear();
        }
    }

    @Redirect(method={"getTabCompletions"}, at=@At(value="INVOKE", target="Lnet/minecraft/command/ICommandManager;getTabCompletions(Lnet/minecraft/command/ICommandSender;Ljava/lang/String;Lnet/minecraft/util/math/BlockPos;)Ljava/util/List;"))
    public List<String> onGetTabCompletionOptions(ICommandManager manager, ICommandSender sender, String input, @Nullable BlockPos pos, ICommandSender sender_, String input_, BlockPos pos_, boolean hasTargetBlock) {
        return ((SpongeCommandManager)SpongeImpl.getGame().getCommandManager()).getSuggestions((CommandSource)sender, input, MixinMinecraftServer.getTarget(sender, pos), hasTargetBlock);
    }

    @Nullable
    private static Location<World> getTarget(ICommandSender sender, @Nullable BlockPos pos) {
        Location<World> targetPos = null;
        if (pos != null) {
            targetPos = new Location<World>((World)sender.func_130014_f_(), VecHelper.toVector3i(pos));
        }
        return targetPos;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onServerTickStart(CallbackInfo ci) {
        TimingsManager.FULL_SERVER_TICK.startTiming();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void onServerTickEnd(CallbackInfo ci) {
        EntityPlayerMP player;
        int lastAnimTick = SpongeCommonEventFactory.lastAnimationPacketTick;
        int lastPrimaryTick = SpongeCommonEventFactory.lastPrimaryPacketTick;
        int lastSecondaryTick = SpongeCommonEventFactory.lastSecondaryPacketTick;
        if (SpongeCommonEventFactory.lastAnimationPlayer != null && (player = (EntityPlayerMP)SpongeCommonEventFactory.lastAnimationPlayer.get()) != null && lastAnimTick != lastPrimaryTick && lastAnimTick != lastSecondaryTick && lastAnimTick != 0 && lastAnimTick - lastPrimaryTick > 3 && lastAnimTick - lastSecondaryTick > 3) {
            BlockSnapshot blockSnapshot = BlockSnapshot.NONE;
            RayTraceResult result = SpongeImplHooks.rayTraceEyes((EntityLivingBase)player, SpongeImplHooks.getBlockReachDistance(player) + 1.0);
            if (result != null && result.func_178782_a() != null) {
                return;
            }
            Sponge.getCauseStackManager().pushCause(player);
            if (!player.func_184614_ca().func_190926_b() && SpongeCommonEventFactory.callInteractItemEventPrimary((EntityPlayer)player, player.func_184614_ca(), EnumHand.MAIN_HAND, null, blockSnapshot).isCancelled()) {
                SpongeCommonEventFactory.lastAnimationPacketTick = 0;
                Sponge.getCauseStackManager().popCause();
                return;
            }
            SpongeCommonEventFactory.callInteractBlockEventPrimary((EntityPlayer)player, player.func_184614_ca(), EnumHand.MAIN_HAND, null);
            Sponge.getCauseStackManager().popCause();
        }
        SpongeCommonEventFactory.lastAnimationPacketTick = 0;
        TimingsManager.FULL_SERVER_TICK.stopTiming();
    }

    @Redirect(method={"addServerStatsToSnooper"}, at=@At(value="FIELD", target="Lnet/minecraft/world/WorldServer;provider:Lnet/minecraft/world/WorldProvider;", opcode=180))
    private WorldProvider onGetWorldProviderForSnooper(WorldServer world) {
        if (((IMixinWorld)world).isFake() || world.func_72912_H() == null) {
            return ((net.minecraft.world.World)Sponge.getServer().getWorlds().iterator().next()).field_73011_w;
        }
        this.dimensionId = WorldManager.getDimensionId(world);
        return world.field_73011_w;
    }

    @Redirect(method={"addServerStatsToSnooper"}, at=@At(value="INVOKE", target="Ljava/lang/Integer;valueOf(I)Ljava/lang/Integer;", ordinal=5))
    @Nullable
    private Integer onValueOfInteger(int original) {
        return this.dimensionId;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=900)})
    private int getSaveTickInterval(int tickInterval) {
        if (!this.func_71262_S()) {
            return tickInterval;
        }
        if (!this.func_71278_l()) {
            return this.field_71315_w + 1;
        }
        int autoPlayerSaveInterval = SpongeImpl.getGlobalConfig().getConfig().getWorld().getAutoPlayerSaveInterval();
        if (autoPlayerSaveInterval > 0 && this.field_71315_w % autoPlayerSaveInterval == 0) {
            this.func_184103_al().func_72389_g();
        }
        this.func_71267_a(true);
        return this.field_71315_w + 1;
    }

    @Overwrite
    public void func_71267_a(boolean dontLog) {
        if (!this.enableSaving) {
            return;
        }
        for (WorldServer worldserver : this.field_71305_c) {
            if (worldserver == null || worldserver.field_73058_d) continue;
            if (this.func_71262_S() && this.func_71278_l()) {
                IMixinWorldServer spongeWorld = (IMixinWorldServer)worldserver;
                int autoSaveInterval = spongeWorld.getActiveConfig().getConfig().getWorld().getAutoSaveInterval();
                boolean logAutoSave = spongeWorld.getActiveConfig().getConfig().getLogging().worldAutoSaveLogging();
                if (autoSaveInterval <= 0 || ((WorldProperties)worldserver.func_72912_H()).getSerializationBehavior() != SerializationBehaviors.AUTOMATIC) {
                    if (!logAutoSave) continue;
                    field_147145_h.warn("Auto-saving has been disabled for level '" + worldserver.func_72912_H().func_76065_j() + "'/" + worldserver.field_73011_w.func_186058_p().func_186065_b() + ". No chunk data will be auto-saved - to re-enable auto-saving set 'auto-save-interval' to a value greater than zero in the corresponding world config.");
                    continue;
                }
                if (this.field_71315_w % autoSaveInterval != 0) continue;
                if (logAutoSave) {
                    field_147145_h.info("Auto-saving chunks for level '" + worldserver.func_72912_H().func_76065_j() + "'/" + worldserver.field_73011_w.func_186058_p().func_186065_b());
                }
            } else if (!dontLog) {
                field_147145_h.info("Saving chunks for level '" + worldserver.func_72912_H().func_76065_j() + "'/" + worldserver.field_73011_w.func_186058_p().func_186065_b());
            }
            try {
                WorldManager.saveWorld(worldserver, false);
            }
            catch (MinecraftException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")}, cancellable=true)
    public void onStopServer(CallbackInfo ci) {
        if (Sponge.isServerAvailable() && !((MinecraftServer)Sponge.getServer()).func_71278_l() && !Sponge.getServer().isMainThread()) {
            ci.cancel();
        }
    }

    @Override
    public int getPlayerIdleTimeout() {
        return this.func_143007_ar();
    }

    @Intrinsic
    public void server$setPlayerIdleTimeout(int timeout) {
        this.shadow$func_143006_e(timeout);
    }

    @Overwrite
    public WorldServer func_71218_a(int dimensionId) {
        return WorldManager.getWorldByDimensionId(dimensionId).orElse(WorldManager.getWorldByDimensionId(0).orElseThrow(() -> new RuntimeException("Attempt made to get world before overworld is loaded!")));
    }

    @Override
    public boolean isMainThread() {
        return this.field_175590_aa == Thread.currentThread();
    }

    @Redirect(method={"callFromMainThread"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/Callable;call()Ljava/lang/Object;", remap=false))
    public Object onCall(Callable<?> callable) throws Exception {
        Object value;
        if (this.field_71316_v && !SpongeImplHooks.isMainThread()) {
            return callable.call();
        }
        try (BasicPluginContext context = (BasicPluginContext)PluginPhase.State.SCHEDULED_TASK.createPhaseContext().source(callable);){
            context.buildAndSwitch();
            value = callable.call();
        }
        return value;
    }

    @Redirect(method={"updateTimeLightAndEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Util;runTask(Ljava/util/concurrent/FutureTask;Lorg/apache/logging/log4j/Logger;)Ljava/lang/Object;"))
    private Object onRun(FutureTask<?> task, Logger logger) {
        return SpongeImplHooks.onUtilRunTask(task, logger);
    }

    @Override
    public DataFixer getDataFixer() {
        return this.field_184112_s;
    }

    @Inject(method={"addServerInfoToCrashReport"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCrashReport(CrashReport report, CallbackInfoReturnable<CrashReport> cir) {
        report.func_85058_a("Sponge PhaseTracker").func_189529_a("Phase Stack", (ICrashReportDetail)CauseTrackerCrashHandler.INSTANCE);
        cir.setReturnValue(report);
    }

    @Overwrite
    public void func_147139_a(EnumDifficulty difficulty) {
        WorldManager.updateServerDifficulty();
    }
}

