/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import com.flowpowered.math.vector.Vector3d;
import io.netty.util.collection.LongObjectHashMap;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketKeepAlive;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.network.play.client.CPacketVehicleMove;
import net.minecraft.network.play.server.SPacketEntityAttach;
import net.minecraft.network.play.server.SPacketKeepAlive;
import net.minecraft.network.play.server.SPacketMoveVehicle;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketResourcePackSend;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.Sign;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableSignData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.tileentity.ChangeSignEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.AnimateHandEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.network.PlayerConnection;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.player.tab.SpongeTabList;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.tick.PlayerTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.IMixinNetworkManager;
import org.spongepowered.common.interfaces.IMixinPacketResourcePackSend;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.entity.player.IMixinInventoryPlayer;
import org.spongepowered.common.interfaces.inventory.IMixinContainerPlayer;
import org.spongepowered.common.interfaces.network.IMixinNetHandlerPlayServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={NetHandlerPlayServer.class})
public abstract class MixinNetHandlerPlayServer
implements PlayerConnection,
IMixinNetHandlerPlayServer {
    private static final String UPDATE_SIGN = "Lnet/minecraft/network/play/client/CPacketUpdateSign;getLines()[Ljava/lang/String;";
    @Shadow
    @Final
    private static Logger field_147370_c;
    @Shadow
    @Final
    public NetworkManager field_147371_a;
    @Shadow
    @Final
    private MinecraftServer field_147367_d;
    @Shadow
    @Final
    private IntHashMap<Short> field_147372_n;
    @Shadow
    public EntityPlayerMP field_147369_b;
    @Shadow
    private net.minecraft.entity.Entity field_184355_r;
    @Shadow
    private int field_147375_m;
    @Shadow
    private double field_184349_l;
    @Shadow
    private double field_184350_m;
    @Shadow
    private double field_184351_n;
    @Shadow
    private double field_184352_o;
    @Shadow
    private double field_184353_p;
    @Shadow
    private double field_184354_q;
    @Shadow
    private int field_184343_A;
    @Shadow
    private Vec3d field_184362_y;
    @Shadow
    private int field_147368_e;
    @Shadow
    private int field_184347_F;
    @Shadow
    private int field_184348_G;
    @Shadow
    private boolean field_184344_B;
    @Shadow
    private long field_194404_h;
    private boolean justTeleported = false;
    @Nullable
    private Location<World> lastMoveLocation = null;
    private final AtomicInteger numResourcePacksInTransit = new AtomicInteger();
    @Nullable
    private ResourcePack lastReceivedPack;
    @Nullable
    private ResourcePack lastAcceptedPack;
    private final LongObjectHashMap<Runnable> customKeepAliveCallbacks = new LongObjectHashMap();
    @Nullable
    private Item lastItem;

    @Shadow
    public abstract void func_147359_a(Packet<?> var1);

    @Shadow
    public abstract void func_194028_b(ITextComponent var1);

    @Shadow
    private void func_184342_d() {
    }

    @Shadow
    public abstract void func_147364_a(double var1, double var3, double var5, float var7, float var8);

    @Shadow
    private static boolean func_183006_b(CPacketPlayer packetIn) {
        return false;
    }

    @Shadow
    protected abstract long func_147363_d();

    @Override
    public void captureCurrentPlayerPosition() {
        this.func_184342_d();
    }

    @Override
    public Player getPlayer() {
        return (Player)this.field_147369_b;
    }

    @Override
    public InetSocketAddress getAddress() {
        return ((IMixinNetworkManager)this.field_147371_a).getAddress();
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return ((IMixinNetworkManager)this.field_147371_a).getVirtualHost();
    }

    @Override
    public int getLatency() {
        return this.field_147369_b.field_71138_i;
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;onUpdateEntity()V"))
    private void onPlayerTick(EntityPlayerMP player) {
        if (player.field_70170_p.field_72995_K) {
            player.func_71127_g();
            return;
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
             PlayerTickContext context = (PlayerTickContext)TickPhase.Tick.PLAYER.createPhaseContext().source(player);){
            context.buildAndSwitch();
            frame.pushCause(player);
            player.func_71127_g();
        }
    }

    @Redirect(method={"sendPacket(Lnet/minecraft/network/Packet;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/NetworkManager;sendPacket(Lnet/minecraft/network/Packet;)V"))
    public void onSendPacket(NetworkManager manager, Packet<?> packet) {
        if ((packet = this.rewritePacket(packet)) != null) {
            manager.func_179290_a(packet);
        }
    }

    @Inject(method={"processKeepAlive"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkSpongeKeepAlive(CPacketKeepAlive packetIn, CallbackInfo ci) {
        Runnable callback = (Runnable)this.customKeepAliveCallbacks.get(packetIn.func_149460_c());
        if (callback != null) {
            PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)((INetHandlerPlayServer)this), (IThreadListener)this.field_147369_b.func_71121_q());
            this.customKeepAliveCallbacks.remove(packetIn.func_149460_c());
            callback.run();
            ci.cancel();
        }
    }

    @Nullable
    private Packet<?> rewritePacket(Packet<?> packetIn) {
        if (packetIn instanceof SPacketPlayerListItem) {
            ((SpongeTabList)((Player)this.field_147369_b).getTabList()).updateEntriesOnSend((SPacketPlayerListItem)packetIn);
        } else if (packetIn instanceof SPacketResourcePackSend) {
            long now;
            for (now = this.func_147363_d() - 1L; now == this.field_194404_h || this.customKeepAliveCallbacks.containsKey(now); --now) {
            }
            ResourcePack resourcePack = ((IMixinPacketResourcePackSend)packetIn).getResourcePack();
            this.numResourcePacksInTransit.incrementAndGet();
            this.customKeepAliveCallbacks.put(now, () -> {
                this.lastReceivedPack = resourcePack;
                this.numResourcePacksInTransit.decrementAndGet();
            });
            this.field_147371_a.func_179290_a((Packet)new SPacketKeepAlive(now));
        } else if (packetIn instanceof SPacketSetExperience) {
            ((IMixinEntityPlayer)this.field_147369_b).recalculateTotalExperience();
        }
        return packetIn;
    }

    @Inject(method={"processUpdateSign"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/play/client/CPacketUpdateSign;getLines()[Ljava/lang/String;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void callSignChangeEvent(CPacketUpdateSign packetIn, CallbackInfo ci, WorldServer worldserver, BlockPos blockpos, IBlockState iblockstate, TileEntity tileentity, TileEntitySign tileentitysign) {
        ci.cancel();
        Optional<SignData> existingSignData = ((Sign)tileentitysign).get(SignData.class);
        if (!existingSignData.isPresent()) {
            throw new RuntimeException("Critical error! Sign data not present on sign!");
        }
        SignData changedSignData = (SignData)existingSignData.get().copy();
        ListValue<Text> lines = changedSignData.lines();
        for (int i = 0; i < packetIn.func_187017_b().length; ++i) {
            lines.set(i, SpongeTexts.toText((ITextComponent)new TextComponentString(packetIn.func_187017_b()[i])));
        }
        changedSignData.set((BaseValue<?>)lines);
        Sponge.getCauseStackManager().pushCause(this.field_147369_b);
        ChangeSignEvent event = SpongeEventFactory.createChangeSignEvent(Sponge.getCauseStackManager().getCurrentCause(), (ImmutableSignData)changedSignData.asImmutable(), changedSignData, (Sign)tileentitysign);
        if (!SpongeImpl.postEvent(event)) {
            ((Sign)tileentitysign).offer(event.getText());
        } else {
            ((Sign)tileentitysign).offer((ValueContainer)existingSignData.get());
        }
        Sponge.getCauseStackManager().popCause();
        tileentitysign.func_70296_d();
        worldserver.func_184164_w().func_180244_a(blockpos);
    }

    @Overwrite
    public void func_147344_a(CPacketCreativeInventoryAction packetIn) {
        PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)((NetHandlerPlayServer)this), (IThreadListener)this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71134_c.func_73083_d()) {
            boolean itemValidCheck;
            BlockPos blockpos;
            TileEntity tileentity;
            NBTTagCompound nbttagcompound;
            PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
            PacketContext context = (PacketContext)peek.context;
            boolean ignoresCreative = context.getIgnoringCreative();
            boolean clickedOutside = packetIn.func_149627_c() < 0;
            ItemStack itemstack = packetIn.func_149625_d();
            if (!itemstack.func_190926_b() && itemstack.func_77942_o() && itemstack.func_77978_p().func_150297_b("BlockEntityTag", 10) && (nbttagcompound = itemstack.func_77978_p().func_74775_l("BlockEntityTag")).func_74764_b("x") && nbttagcompound.func_74764_b("y") && nbttagcompound.func_74764_b("z") && (tileentity = this.field_147369_b.field_70170_p.func_175625_s(blockpos = new BlockPos(nbttagcompound.func_74762_e("x"), nbttagcompound.func_74762_e("y"), nbttagcompound.func_74762_e("z")))) != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                tileentity.func_189515_b(nbttagcompound1);
                nbttagcompound1.func_82580_o("x");
                nbttagcompound1.func_82580_o("y");
                nbttagcompound1.func_82580_o("z");
                itemstack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound1);
            }
            boolean clickedInsideNotOutput = packetIn.func_149627_c() >= 1 && packetIn.func_149627_c() <= 45;
            boolean bl = itemValidCheck = itemstack.func_190926_b() || itemstack.func_77960_j() >= 0 && itemstack.func_190916_E() <= 64 && !itemstack.func_190926_b();
            if (itemValidCheck) {
                ClickInventoryEvent.Creative clickEvent;
                if (!ignoresCreative && (clickEvent = SpongeCommonEventFactory.callCreativeClickInventoryEvent(this.field_147369_b, packetIn)).isCancelled()) {
                    if (packetIn.func_149627_c() >= 0 && packetIn.func_149627_c() < this.field_147369_b.field_71069_bz.field_75151_b.size()) {
                        this.field_147369_b.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_147369_b.field_71069_bz.field_75152_c, packetIn.func_149627_c(), this.field_147369_b.field_71069_bz.func_75139_a(packetIn.func_149627_c()).func_75211_c()));
                        this.field_147369_b.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(-1, -1, ItemStack.field_190927_a));
                    }
                    return;
                }
                if (clickedInsideNotOutput) {
                    if (itemstack.func_190926_b()) {
                        this.field_147369_b.field_71069_bz.func_75141_a(packetIn.func_149627_c(), ItemStack.field_190927_a);
                    } else {
                        this.field_147369_b.field_71069_bz.func_75141_a(packetIn.func_149627_c(), itemstack);
                    }
                    this.field_147369_b.field_71069_bz.func_75128_a((EntityPlayer)this.field_147369_b, true);
                } else if (clickedOutside && this.field_147375_m < 200) {
                    this.field_147375_m += 20;
                    EntityItem entityitem = this.field_147369_b.func_71019_a(itemstack, true);
                    if (entityitem != null) {
                        entityitem.func_70288_d();
                    }
                }
            }
        }
    }

    @Inject(method={"processClickWindow"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/IntHashMap;addKey(ILjava/lang/Object;)V")})
    public void onInvalidClick(CPacketClickWindow packet, CallbackInfo ci) {
        ((IMixinContainer)this.field_147369_b.field_71070_bA).detectAndSendChanges(true);
    }

    @Redirect(method={"processChatMessage"}, at=@At(value="INVOKE", target="Lorg/apache/commons/lang3/StringUtils;normalizeSpace(Ljava/lang/String;)Ljava/lang/String;", remap=false))
    public String onNormalizeSpace(String input) {
        return input;
    }

    @Inject(method={"setPlayerLocation(DDDFFLjava/util/Set;)V"}, at={@At(value="RETURN")})
    public void setPlayerLocation(double x, double y, double z, float yaw, float pitch, Set<?> relativeSet, CallbackInfo ci) {
        this.justTeleported = true;
    }

    @Redirect(method={"processPlayer"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/player/EntityPlayerMP;queuedEndExit:Z"))
    private boolean throwMoveEvent(EntityPlayerMP playerMP, CPacketPlayer packetIn) {
        if (!playerMP.field_71136_j) {
            boolean positionOnly;
            boolean rotationOnly;
            if (!packetIn.field_149480_h && !packetIn.field_149481_i) {
                return playerMP.field_71136_j;
            }
            Player player = (Player)this.field_147369_b;
            IMixinEntityPlayerMP mixinPlayer = (IMixinEntityPlayerMP)this.field_147369_b;
            Vector3d fromrot = player.getRotation();
            Location<World> from = player.getLocation();
            if (this.lastMoveLocation != null) {
                from = this.lastMoveLocation;
            }
            Vector3d torot = new Vector3d(packetIn.field_149473_f, packetIn.field_149476_e, 0.0f);
            Location<World> to = new Location<World>(player.getWorld(), packetIn.field_149479_a, packetIn.field_149477_b, packetIn.field_149478_c);
            boolean bl = rotationOnly = !packetIn.field_149480_h && packetIn.field_149481_i;
            if (rotationOnly) {
                from = player.getLocation();
                to = from;
            }
            boolean bl2 = positionOnly = packetIn.field_149480_h && !packetIn.field_149481_i;
            if (positionOnly) {
                torot = fromrot;
            }
            ((IMixinEntityPlayerMP)this.field_147369_b).setVelocityOverride(to.getPosition().sub(from.getPosition()));
            double deltaSquared = to.getPosition().distanceSquared(from.getPosition());
            double deltaAngleSquared = fromrot.distanceSquared(torot);
            if (deltaSquared > 0.00390625 || deltaAngleSquared > (double)0.0225f) {
                Transform<World> toTransform;
                Transform<World> fromTransform = player.getTransform().setLocation(from).setRotation(fromrot);
                Transform<World> originalToTransform = toTransform = player.getTransform().setLocation(to).setRotation(torot);
                if (ShouldFire.MOVE_ENTITY_EVENT) {
                    try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                        Sponge.getCauseStackManager().pushCause(player);
                        MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), fromTransform, toTransform, player);
                        SpongeImpl.postEvent(event);
                        Sponge.getCauseStackManager().popCause();
                        if (event.isCancelled()) {
                            mixinPlayer.setLocationAndAngles(fromTransform);
                            this.lastMoveLocation = from;
                            ((IMixinEntityPlayerMP)this.field_147369_b).setVelocityOverride(null);
                            boolean bl3 = true;
                            return bl3;
                        }
                        toTransform = event.getToTransform();
                    }
                }
                if (!toTransform.equals(originalToTransform)) {
                    mixinPlayer.setLocationAndAngles(toTransform);
                    this.lastMoveLocation = toTransform.getLocation();
                    ((IMixinEntityPlayerMP)this.field_147369_b).setVelocityOverride(null);
                    return true;
                }
                if (!from.equals(player.getLocation()) && this.justTeleported) {
                    this.lastMoveLocation = player.getLocation();
                    this.justTeleported = false;
                    ((IMixinEntityPlayerMP)this.field_147369_b).setVelocityOverride(null);
                    return true;
                }
                this.lastMoveLocation = toTransform.getLocation();
                this.resendLatestResourcePackRequest();
            }
        }
        return playerMP.field_71136_j;
    }

    @Redirect(method={"processVehicleMove"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;getLowestRidingEntity()Lnet/minecraft/entity/Entity;"))
    private net.minecraft.entity.Entity processVehicleMoveEvent(EntityPlayerMP playerMP, CPacketVehicleMove packetIn) {
        net.minecraft.entity.Entity ridingEntity = this.field_147369_b.func_184208_bv();
        if (ridingEntity == this.field_147369_b || ridingEntity.func_184179_bs() != this.field_147369_b || ridingEntity != this.field_184355_r) {
            return ridingEntity;
        }
        Entity spongeEntity = (Entity)ridingEntity;
        Vector3d fromrot = spongeEntity.getRotation();
        Location<World> from = spongeEntity.getLocation();
        Vector3d torot = new Vector3d(packetIn.func_187005_e(), packetIn.func_187006_d(), 0.0f);
        Location<World> to = new Location<World>(spongeEntity.getWorld(), packetIn.func_187004_a(), packetIn.func_187002_b(), packetIn.func_187003_c());
        Transform<World> fromTransform = spongeEntity.getTransform().setLocation(from).setRotation(fromrot);
        Transform<World> toTransform = spongeEntity.getTransform().setLocation(to).setRotation(torot);
        MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(Sponge.getCauseStackManager().getCurrentCause(), fromTransform, toTransform, this.getPlayer());
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            this.field_147371_a.func_179290_a((Packet)new SPacketMoveVehicle(ridingEntity));
            return this.field_147369_b;
        }
        return ridingEntity;
    }

    @Redirect(method={"onDisconnect"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;)V"))
    public void onDisconnectHandler(PlayerList this$0, ITextComponent component) {
        if (this.field_147369_b.field_71135_a == null) {
            return;
        }
        Player player = (Player)this.field_147369_b;
        Text message = SpongeTexts.toText(component);
        MessageChannel originalChannel = player.getMessageChannel();
        Sponge.getCauseStackManager().pushCause(player);
        ClientConnectionEvent.Disconnect event = SpongeEventFactory.createClientConnectionEventDisconnect(Sponge.getCauseStackManager().getCurrentCause(), originalChannel, Optional.of(originalChannel), new MessageEvent.MessageFormatter(message), player, false);
        SpongeImpl.postEvent(event);
        Sponge.getCauseStackManager().popCause();
        if (!event.isMessageCancelled()) {
            event.getChannel().ifPresent(channel -> channel.send(player, event.getMessage()));
        }
        ((IMixinEntityPlayerMP)this.field_147369_b).getWorldBorderListener().onPlayerDisconnect();
    }

    @Redirect(method={"processTryUseItemOnBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerInteractionManager;processRightClickBlock(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumHand;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;FFF)Lnet/minecraft/util/EnumActionResult;"))
    public EnumActionResult onProcessRightClickBlock(PlayerInteractionManager interactionManager, EntityPlayer player, net.minecraft.world.World worldIn, @Nullable ItemStack stack, EnumHand hand, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemStack;
        EnumActionResult actionResult = interactionManager.func_187251_a((EntityPlayer)this.field_147369_b, worldIn, stack, hand, pos, facing, hitX, hitY, hitZ);
        PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
        if (!((PacketContext)peek.context).getInteractItemChanged() && !ItemStack.func_77989_b((ItemStack)(itemStack = ItemStackUtil.toNative(((PacketContext)peek.context).getItemUsed())), (ItemStack)player.func_184586_b(hand)) && SpongeCommonEventFactory.interactBlockRightClickEventCancelled) {
            PacketPhaseUtil.handlePlayerSlotRestore((EntityPlayerMP)player, itemStack, hand);
        }
        ((PacketContext)peek.context).interactItemChanged(false);
        SpongeCommonEventFactory.interactBlockRightClickEventCancelled = false;
        return actionResult;
    }

    @Redirect(method={"processTryUseItem"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerInteractionManager;processRightClick(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/EnumHand;)Lnet/minecraft/util/EnumActionResult;"))
    public EnumActionResult onProcessRightClick(PlayerInteractionManager interactionManager, EntityPlayer player, net.minecraft.world.World worldIn, @Nullable ItemStack stack, EnumHand hand) {
        ItemStack itemStack;
        EnumActionResult actionResult = interactionManager.func_187250_a((EntityPlayer)this.field_147369_b, worldIn, stack, hand);
        PhaseData peek = PhaseTracker.getInstance().getCurrentPhaseData();
        if (!((PacketContext)peek.context).getInteractItemChanged() && !ItemStack.func_77989_b((ItemStack)(itemStack = ItemStackUtil.toNative(((PacketContext)peek.context).getItemUsed())), (ItemStack)player.func_184586_b(hand)) && SpongeCommonEventFactory.interactBlockRightClickEventCancelled) {
            PacketPhaseUtil.handlePlayerSlotRestore((EntityPlayerMP)player, itemStack, hand);
        }
        ((PacketContext)peek.context).interactItemChanged(false);
        SpongeCommonEventFactory.interactBlockRightClickEventCancelled = false;
        return actionResult;
    }

    @Nullable
    @Redirect(method={"processPlayerDigging"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;dropItem(Z)Lnet/minecraft/entity/item/EntityItem;"))
    public EntityItem onPlayerDropItem(EntityPlayerMP player, boolean dropAll) {
        EntityItem item = null;
        ItemStack stack = this.field_147369_b.field_71071_by.func_70448_g();
        if (!stack.func_190926_b()) {
            int size = stack.func_190916_E();
            item = this.field_147369_b.func_71040_bB(dropAll);
            if (item == null && ((IMixinEntityPlayer)player).shouldRestoreInventory()) {
                Slot slot = this.field_147369_b.field_71070_bA.func_75147_a((IInventory)this.field_147369_b.field_71071_by, this.field_147369_b.field_71071_by.field_70461_c);
                int windowId = this.field_147369_b.field_71070_bA.field_75152_c;
                stack.func_190920_e(size);
                this.func_147359_a((Packet<?>)new SPacketSetSlot(windowId, slot.field_75222_d, stack));
            }
        }
        return item;
    }

    @Nullable
    private static DataParameter<?> findModifiedEntityInteractDataParameter(ItemStack stack, net.minecraft.entity.Entity entity) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151100_aR) {
            if (entity instanceof EntitySheep) {
                return EntitySheep.field_184774_bv;
            }
            if (entity instanceof EntityWolf) {
                return EntityWolf.field_184758_bB;
            }
            return null;
        }
        if (item == Items.field_151057_cb) {
            return entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) && stack.func_82837_s() ? net.minecraft.entity.Entity.field_184242_az : null;
        }
        if (item == Items.field_151141_av) {
            return entity instanceof EntityPig ? EntityPig.field_184763_bv : null;
        }
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() == Blocks.field_150486_ae) {
            return entity instanceof AbstractChestHorse ? AbstractChestHorse.field_190698_bG : null;
        }
        return null;
    }

    @Inject(method={"handleAnimation"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;markPlayerActive()V")}, cancellable=true)
    public void onHandleAnimation(CPacketAnimation packetIn, CallbackInfo ci) {
        SpongeCommonEventFactory.lastAnimationPacketTick = SpongeImpl.getServer().func_71259_af();
        SpongeCommonEventFactory.lastAnimationPlayer = new WeakReference<EntityPlayerMP>(this.field_147369_b);
        if (ShouldFire.ANIMATE_HAND_EVENT) {
            HandType handType = packetIn.func_187018_a() == EnumHand.MAIN_HAND ? HandTypes.MAIN_HAND : HandTypes.OFF_HAND;
            ItemStack heldItem = this.field_147369_b.func_184586_b(packetIn.func_187018_a());
            Sponge.getCauseStackManager().addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
            AnimateHandEvent event = SpongeEventFactory.createAnimateHandEvent(Sponge.getCauseStackManager().getCurrentCause(), handType, (Humanoid)this.field_147369_b);
            if (SpongeImpl.postEvent(event)) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"processPlayerDigging"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorld(I)Lnet/minecraft/world/WorldServer;")})
    public void onProcessPlayerDigging(CPacketPlayerDigging packetIn, CallbackInfo ci) {
        SpongeCommonEventFactory.lastPrimaryPacketTick = SpongeImpl.getServer().func_71259_af();
    }

    @Inject(method={"processPlayerDigging"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayerMP;dropItem(Z)Lnet/minecraft/entity/item/EntityItem;")})
    public void onProcessPlayerDiggingDropItem(CPacketPlayerDigging packetIn, CallbackInfo ci) {
        ItemStack stack = this.field_147369_b.func_184614_ca();
        if (!stack.func_190926_b()) {
            ((IMixinEntityPlayerMP)this.field_147369_b).setPacketItem(stack.func_77946_l());
        }
    }

    @Inject(method={"processTryUseItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorld(I)Lnet/minecraft/world/WorldServer;")}, cancellable=true)
    public void onProcessTryUseItem(CPacketPlayerTryUseItem packetIn, CallbackInfo ci) {
        SpongeCommonEventFactory.lastSecondaryPacketTick = SpongeImpl.getServer().func_71259_af();
        long packetDiff = System.currentTimeMillis() - SpongeCommonEventFactory.lastTryBlockPacketTimeStamp;
        if (packetDiff < 100L && SpongeCommonEventFactory.lastInteractItemOnBlockCancelled) {
            ci.cancel();
        }
    }

    @Inject(method={"processTryUseItemOnBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getWorld(I)Lnet/minecraft/world/WorldServer;")})
    public void onProcessTryUseItemOnBlock(CPacketPlayerTryUseItemOnBlock packetIn, CallbackInfo ci) {
        SpongeCommonEventFactory.lastTryBlockPacketTimeStamp = System.currentTimeMillis();
        SpongeCommonEventFactory.lastSecondaryPacketTick = SpongeImpl.getServer().func_71259_af();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Overwrite
    public void func_147340_a(CPacketUseEntity packetIn) {
        if (!SpongeImpl.getServer().func_152345_ab()) {
            if (packetIn.func_149565_c() == CPacketUseEntity.Action.INTERACT) {
                return;
            }
            PacketThreadUtil.func_180031_a((Packet)packetIn, (INetHandler)((NetHandlerPlayServer)this), (IThreadListener)this.field_147369_b.func_71121_q());
            return;
        }
        WorldServer worldserver = this.field_147367_d.func_71218_a(this.field_147369_b.field_71093_bK);
        net.minecraft.entity.Entity entity = packetIn.func_149564_a((net.minecraft.world.World)worldserver);
        this.field_147369_b.func_143004_u();
        if (entity == null) return;
        boolean flag = this.field_147369_b.func_70685_l(entity);
        double d0 = 36.0;
        if (!flag) {
            d0 = 9.0;
        }
        if (!(this.field_147369_b.func_70068_e(entity) < d0)) return;
        if (packetIn.func_149565_c() == CPacketUseEntity.Action.INTERACT_AT) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                EnumHand hand = packetIn.func_186994_b();
                ItemStack itemstack = hand != null ? this.field_147369_b.func_184586_b(hand) : ItemStack.field_190927_a;
                SpongeCommonEventFactory.lastSecondaryPacketTick = this.field_147367_d.func_71259_af();
                if (SpongeCommonEventFactory.callInteractItemEventSecondary((EntityPlayer)this.field_147369_b, itemstack, hand, VecHelper.toVector3d(packetIn.func_179712_b()), entity).isCancelled() || SpongeCommonEventFactory.callInteractEntityEventSecondary(this.field_147369_b, entity, hand, VecHelper.toVector3d(entity.func_174791_d().func_178787_e(packetIn.func_179712_b()))).isCancelled()) {
                    int index = ((IMixinInventoryPlayer)this.field_147369_b.field_71071_by).getHeldItemIndex(hand);
                    if (hand == EnumHand.OFF_HAND) {
                        this.func_147359_a((Packet<?>)new SPacketSetSlot(-2, ((IMixinContainerPlayer)this.field_147369_b.field_71069_bz).getOffHandSlot(), itemstack));
                    } else {
                        Slot slot = this.field_147369_b.field_71070_bA.func_75147_a((IInventory)this.field_147369_b.field_71071_by, index);
                        this.func_147359_a((Packet<?>)new SPacketSetSlot(this.field_147369_b.field_71070_bA.field_75152_c, slot.field_75222_d, itemstack));
                    }
                    if (itemstack.func_77973_b() == Items.field_151058_ca) {
                        this.func_147359_a((Packet<?>)new SPacketEntityAttach(entity, null));
                        return;
                    } else {
                        DataParameter<?> parameter = MixinNetHandlerPlayServer.findModifiedEntityInteractDataParameter(itemstack, entity);
                        if (parameter == null) return;
                        entity.func_184212_Q().func_187217_b(parameter);
                    }
                    return;
                }
                if (entity.func_184199_a((EntityPlayer)this.field_147369_b, packetIn.func_179712_b(), hand) == EnumActionResult.SUCCESS) return;
                this.field_147369_b.func_190775_a(entity, hand);
                return;
            }
        } else {
            if (packetIn.func_149565_c() != CPacketUseEntity.Action.ATTACK) return;
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack itemstack = this.field_147369_b.func_184586_b(hand);
            SpongeCommonEventFactory.lastPrimaryPacketTick = this.field_147367_d.func_71259_af();
            Vector3d hitVec = null;
            if (packetIn.func_179712_b() == null) {
                RayTraceResult result = SpongeImplHooks.rayTraceEyes((EntityLivingBase)this.field_147369_b, SpongeImplHooks.getBlockReachDistance(this.field_147369_b));
                Vector3d vector3d = hitVec = result == null ? null : VecHelper.toVector3d(result.field_72307_f);
            }
            if (SpongeCommonEventFactory.callInteractItemEventPrimary((EntityPlayer)this.field_147369_b, itemstack, hand, hitVec, entity).isCancelled()) {
                ((IMixinEntityPlayerMP)this.field_147369_b).restorePacketItem(hand);
                return;
            }
            if (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity == this.field_147369_b) {
                this.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.invalid_entity_attacked", new Object[0]));
                this.field_147367_d.func_71236_h("Player " + this.field_147369_b.func_70005_c_() + " tried to attack an invalid entity");
                return;
            }
            if (SpongeCommonEventFactory.callInteractEntityEventPrimary(this.field_147369_b, entity, hand, hitVec).isCancelled()) {
                ((IMixinEntityPlayerMP)this.field_147369_b).restorePacketItem(hand);
                return;
            }
            this.field_147369_b.func_71059_n(entity);
        }
    }

    @Override
    public void setLastMoveLocation(Location<World> location) {
        this.lastMoveLocation = location;
    }

    @Inject(method={"handleResourcePackStatus(Lnet/minecraft/network/play/client/CPacketResourcePackStatus;)V"}, at={@At(value="HEAD")})
    private void onProcessResourcePackStatus(CPacketResourcePackStatus packet, CallbackInfo ci) {
        PacketThreadUtil.func_180031_a((Packet)packet, (INetHandler)((INetHandlerPlayServer)this), (IThreadListener)this.field_147369_b.func_71121_q());
    }

    @Override
    public void resendLatestResourcePackRequest() {
        ResourcePack pack = this.lastReceivedPack;
        if (this.numResourcePacksInTransit.get() > 0 || pack == null) {
            return;
        }
        this.lastReceivedPack = null;
        ((Player)this.field_147369_b).sendResourcePack(pack);
    }

    @Override
    public ResourcePack popReceivedResourcePack(boolean markAccepted) {
        ResourcePack pack = this.lastReceivedPack;
        this.lastReceivedPack = null;
        if (markAccepted) {
            this.lastAcceptedPack = pack;
        }
        return pack;
    }

    @Override
    public ResourcePack popAcceptedResourcePack() {
        ResourcePack pack = this.lastAcceptedPack;
        this.lastAcceptedPack = null;
        return pack;
    }
}

