/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item.inventory;

import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntityLockable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.LensProvider;
import org.spongepowered.common.item.inventory.lens.ReusableLensProvider;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.item.inventory.lens.impl.ReusableLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;

@Mixin(value={TileEntityLockable.class, InventoryBasic.class, InventoryCraftResult.class, InventoryLargeChest.class}, priority=999)
public abstract class MixinTraitAdapter
implements MinecraftInventoryAdapter {
    @Nullable
    private ReusableLens<?> reusableLens = null;
    @Nullable
    private SlotProvider slots = null;

    @Override
    public SlotProvider getSlotProvider() {
        if (this.slots != null) {
            return this.slots;
        }
        return this.getReusableLens().getSlots();
    }

    @Override
    public Lens getRootLens() {
        return this.getReusableLens().getLens();
    }

    private ReusableLens<?> getReusableLens() {
        if (this.reusableLens != null) {
            return this.reusableLens;
        }
        if (this instanceof ReusableLensProvider) {
            return ((ReusableLensProvider)((Object)this)).generateLens(this.getFabric(), this);
        }
        if (this instanceof LensProvider) {
            this.slots = ((LensProvider)((Object)this)).slotProvider(this.getFabric(), this);
            Lens lens = ((LensProvider)((Object)this)).rootLens(this.getFabric(), this);
            return new ReusableLens<Lens>(this.slots, lens);
        }
        SlotCollection slots = new SlotCollection.Builder().add(this.getFabric().getSize()).build();
        Lens lens = this.getFabric().getSize() == 0 ? new DefaultEmptyLens(this) : new OrderedInventoryLensImpl(0, this.getFabric().getSize(), 1, (SlotProvider)slots);
        return new ReusableLens<DefaultEmptyLens>((SlotProvider)slots, (DefaultEmptyLens)lens);
    }
}

