/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.passive;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.village.MerchantRecipeList;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.CareerData;
import org.spongepowered.api.data.type.Career;
import org.spongepowered.api.data.type.Profession;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.Villager;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeCareerData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.SpongeCareer;
import org.spongepowered.common.entity.SpongeEntityMeta;
import org.spongepowered.common.interfaces.entity.IMixinVillager;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.fabric.IInventoryFabric;
import org.spongepowered.common.mixin.core.entity.MixinEntityAgeable;
import org.spongepowered.common.registry.SpongeVillagerRegistry;

@Mixin(value={EntityVillager.class})
@Implements(value={@Interface(iface=Villager.class, prefix="villager$"), @Interface(iface=MinecraftInventoryAdapter.class, prefix="inventory$")})
public abstract class MixinEntityVillager
extends MixinEntityAgeable
implements Villager,
IMixinVillager,
CarriedInventory<Villager> {
    @Shadow
    private boolean field_70953_g;
    @Shadow
    private int field_175563_bv;
    @Shadow
    private int field_175562_bw;
    @Shadow
    @Nullable
    private MerchantRecipeList field_70963_i;
    @Shadow
    @Final
    private InventoryBasic field_175560_bz;
    private Fabric fabric;
    private SlotCollection slots;
    private Lens lens;
    @Nullable
    private Profession profession;

    @Shadow
    public abstract void func_70938_b(int var1);

    @Shadow
    public abstract void func_70932_a_(EntityPlayer var1);

    @Shadow
    public abstract boolean shadow$func_70940_q();

    @Shadow
    @Nullable
    public abstract EntityPlayer shadow$func_70931_l_();

    @Shadow
    public abstract MerchantRecipeList func_70934_b(EntityPlayer var1);

    @Inject(method={"setProfession(I)V"}, at={@At(value="RETURN")})
    private void onSetProfession(int professionId, CallbackInfo ci) {
        this.profession = SpongeImplHooks.validateProfession(professionId);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onSpongeConstructed(CallbackInfo ci) {
        this.fabric = new IInventoryFabric((IInventory)this.field_175560_bz);
        this.slots = new SlotCollection.Builder().add(8).build();
        this.lens = new OrderedInventoryLensImpl(0, 8, 1, (SlotProvider)this.slots);
    }

    public SlotProvider inventory$getSlotProvider() {
        return this.slots;
    }

    public Lens inventory$getRootLens() {
        return this.lens;
    }

    public Fabric inventory$getFabric() {
        return this.fabric;
    }

    @Override
    public boolean isPlaying() {
        return this.field_70953_g;
    }

    @Override
    public void setPlaying(boolean playing) {
        this.field_70953_g = playing;
    }

    @Intrinsic
    public boolean villager$isTrading() {
        return this.shadow$func_70940_q();
    }

    @Override
    public Career getCareer() {
        List careers = (List)this.profession.getCareers();
        if (this.field_175563_bv == 0 || this.field_175563_bv > careers.size()) {
            this.field_175563_bv = new Random().nextInt(careers.size()) + 1;
        }
        this.func_70934_b(null);
        return (Career)careers.get(this.field_175563_bv - 1);
    }

    @Override
    public Optional<Profession> getProfession() {
        return Optional.ofNullable(this.profession);
    }

    @Override
    public void setProfession(Profession profession) {
        this.profession = (Profession)Preconditions.checkNotNull((Object)profession, (Object)"VillagerProfession cannot be null!");
    }

    @Override
    public void setCareer(Career career) {
        this.func_70938_b(((SpongeEntityMeta)((Object)career.getProfession())).type);
        this.field_70963_i = null;
        this.field_175563_bv = ((SpongeCareer)career).type + 1;
        this.field_175562_bw = 1;
        this.func_70934_b(null);
    }

    @Override
    public Optional<Humanoid> getCustomer() {
        return Optional.ofNullable((Humanoid)this.shadow$func_70931_l_());
    }

    @Overwrite
    public void func_175554_cu() {
        List careers = (List)this.profession.getCareers();
        if (this.field_175563_bv != 0 && this.field_175562_bw != 0) {
            ++this.field_175562_bw;
        } else {
            this.field_175563_bv = this.field_70146_Z.nextInt(careers.size()) + 1;
            this.field_175562_bw = 1;
        }
        if (this.field_70963_i == null) {
            this.field_70963_i = new MerchantRecipeList();
        }
        Preconditions.checkState((this.field_175563_bv <= careers.size() ? 1 : 0) != 0, (Object)("The villager career id is out of bounds fo the available Careers! Found: " + this.field_175563_bv + " when the current maximum is: " + careers.size()));
        Career careerLevel = (Career)careers.get(this.field_175563_bv - 1);
        SpongeVillagerRegistry.getInstance().populateOffers(this, (List<TradeOffer>)this.field_70963_i, careerLevel, this.field_175562_bw, this.field_70146_Z);
    }

    @Override
    public void setCustomer(@Nullable Humanoid humanoid) {
        this.func_70932_a_((EntityPlayer)humanoid);
    }

    @Override
    public CareerData getCareerData() {
        return new SpongeCareerData(this.getCareer());
    }

    @Override
    public Value<Career> career() {
        return new SpongeValue<Career>(Keys.CAREER, DataConstants.Catalog.CAREER_DEFAULT, this.getCareer());
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(this.getCareerData());
    }

    @Override
    public CarriedInventory<? extends Carrier> getInventory() {
        return this;
    }

    @Override
    public Optional<Villager> getCarrier() {
        return Optional.of(this);
    }
}

