/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.event.damage.MinecraftFallingBlockDamageSource;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.mixin.core.entity.MixinEntity;

@Mixin(value={EntityFallingBlock.class})
public abstract class MixinEntityFallingBlock
extends MixinEntity
implements FallingBlock {
    @Shadow
    public IBlockState field_175132_d;
    @Shadow
    public boolean field_145809_g;
    @Shadow
    public int field_145815_h;
    @Shadow
    public float field_145816_i;
    @Shadow
    public NBTTagCompound field_145810_d;

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void onWorldSetBlockToAir(CallbackInfo ci) {
        BlockPos pos = new BlockPos((Entity)((EntityFallingBlock)this));
        if (((IMixinWorld)this.field_70170_p).isFake()) {
            this.field_70170_p.func_175698_g(pos);
            return;
        }
        PhaseData currentPhaseData = PhaseTracker.getInstance().getCurrentPhaseData();
        this.field_70170_p.func_175698_g(pos);
        if (!TrackingUtil.processBlockCaptures(currentPhaseData.context.getCapturedBlocks(), currentPhaseData.state, currentPhaseData.context)) {
            this.func_70106_y();
            ci.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"fall"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean spongeAttackFallingOrAnvil(Entity entity, DamageSource source, float damage) {
        if (entity.field_70170_p.field_72995_K) {
            return entity.func_70097_a(source, damage);
        }
        boolean isAnvil = this.field_175132_d.func_177230_c() == Blocks.field_150467_bQ;
        try {
            if (isAnvil) {
                DamageSource.field_82728_o = new MinecraftFallingBlockDamageSource("anvil", (EntityFallingBlock)this);
                boolean bl = entity.func_70097_a(DamageSource.field_82728_o, damage);
                return bl;
            }
            DamageSource.field_82729_p = new MinecraftFallingBlockDamageSource("fallingblock", (EntityFallingBlock)this);
            boolean bl = entity.func_70097_a(DamageSource.field_82729_p, damage);
            return bl;
        }
        finally {
            if (isAnvil) {
                DamageSource.field_82728_o = source;
            } else {
                DamageSource.field_82729_p = source;
            }
        }
    }
}

