/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.ArmorEquipable;
import org.spongepowered.api.entity.Equipable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.type.SpongeEquipmentType;
import org.spongepowered.common.entity.living.human.EntityHuman;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.MixinEntityLivingBase;

@Mixin(value={EntityArmorStand.class, EntityGiantZombie.class, EntityPlayerMP.class, AbstractSkeleton.class, EntityZombie.class, EntityHuman.class})
@Implements(value={@Interface(iface=ArmorEquipable.class, prefix="equipable$")})
public abstract class MixinArmorEquipable
extends MixinEntityLivingBase
implements Equipable {
    @Override
    public boolean canEquip(EquipmentType type) {
        return true;
    }

    @Override
    public boolean canEquip(EquipmentType type, @Nullable ItemStack equipment) {
        return true;
    }

    @Override
    public Optional<ItemStack> getEquipped(EquipmentType type) {
        if (type instanceof SpongeEquipmentType) {
            EntityEquipmentSlot[] slots = ((SpongeEquipmentType)type).getSlots();
            if (slots.length != 1) {
                throw new IllegalArgumentException("Only EquipmentTypes for a single Slot are possible");
            }
            net.minecraft.item.ItemStack nmsItem = this.func_184582_a(slots[0]);
            return Optional.of(ItemStackUtil.fromNative(nmsItem));
        }
        return Optional.empty();
    }

    @Override
    public boolean equip(EquipmentType type, @Nullable ItemStack equipment) {
        if (type instanceof SpongeEquipmentType) {
            EntityEquipmentSlot[] entityEquipmentSlotArray;
            int n;
            int n2;
            EntityEquipmentSlot[] slots = ((SpongeEquipmentType)type).getSlots();
            if (slots.length == 0) {
                slots = EntityEquipmentSlot.values();
            }
            if ((n2 = 0) < (n = (entityEquipmentSlotArray = slots).length)) {
                EntityEquipmentSlot slot = entityEquipmentSlotArray[n2];
                this.func_184201_a(slot, ItemStackUtil.toNative(equipment));
                return true;
            }
        }
        return false;
    }

    public Optional<ItemStack> equipable$getItemInHand(HandType handType) {
        Preconditions.checkNotNull((Object)handType, (Object)"HandType cannot be null!");
        net.minecraft.item.ItemStack nmsItem = this.func_184586_b((EnumHand)handType);
        return Optional.of(ItemStackUtil.fromNative(nmsItem));
    }

    public void equipable$setItemInHand(HandType handType, @Nullable ItemStack itemInHand) {
        Preconditions.checkNotNull((Object)handType, (Object)"HandType cannot be null!");
        this.func_184611_a((EnumHand)handType, ItemStackUtil.toNative(itemInHand).func_77946_l());
    }
}

