/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDropData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDirectionalData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDropData;
import org.spongepowered.common.data.util.DirectionResolver;
import org.spongepowered.common.mixin.core.block.MixinBlock;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={BlockSkull.class})
public abstract class MixinBlockSkull
extends MixinBlock {
    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getShouldDropFor(blockState), (Object)this.getDirectionalData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableDropData.class.isAssignableFrom(immutable) || ImmutableDirectionalData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableDropData) {
            boolean shouldDrop = (Boolean)((ImmutableDropData)manipulator).willDrop().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSkull.field_176417_b, (Comparable)Boolean.valueOf(!shouldDrop)));
        }
        if (manipulator instanceof ImmutableDirectionalData) {
            Direction dir = (Direction)((Object)((ImmutableDirectionalData)manipulator).direction().get());
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)DirectionResolver.getFor(dir)));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.SHOULD_DROP)) {
            boolean shouldDrop = (Boolean)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSkull.field_176417_b, (Comparable)Boolean.valueOf(!shouldDrop)));
        }
        if (key.equals(Keys.DIRECTION)) {
            Direction dir = (Direction)((Object)value);
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockSkull.field_176418_a, (Comparable)DirectionResolver.getFor(dir)));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableDropData getShouldDropFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDropData.class, (Boolean)blockState.func_177229_b((IProperty)BlockSkull.field_176417_b) == false);
    }

    private ImmutableDirectionalData getDirectionalData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDirectionalData.class, new Object[]{DirectionResolver.getFor((EnumFacing)blockState.func_177229_b((IProperty)BlockSkull.field_176418_a))});
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation("item.skull.skeleton.name");
    }
}

