/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableHingeData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableOpenData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePortionData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePoweredData;
import org.spongepowered.api.data.type.Hinge;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.PortionTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDirectionalData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeHingeData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeOpenData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePortionData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePoweredData;
import org.spongepowered.common.data.util.DirectionChecker;
import org.spongepowered.common.data.util.DirectionResolver;
import org.spongepowered.common.mixin.core.block.MixinBlock;
import org.spongepowered.common.text.translation.SpongeTranslation;

@Mixin(value={BlockDoor.class})
public abstract class MixinBlockDoor
extends MixinBlock {
    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getHingeFor(blockState), (Object)this.getIsOpenFor(blockState), (Object)this.getIsPoweredFor(blockState), (Object)this.getDirectionalData(blockState), (Object)this.getPortionData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableHingeData.class.isAssignableFrom(immutable) || ImmutableOpenData.class.isAssignableFrom(immutable) || ImmutablePoweredData.class.isAssignableFrom(immutable) || ImmutablePortionData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableHingeData) {
            BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)((ImmutableHingeData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)hinge));
        }
        if (manipulator instanceof ImmutableOpenData) {
            boolean isOpen = (Boolean)((ImmutableOpenData)manipulator).open().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(isOpen)));
        }
        if (manipulator instanceof ImmutablePoweredData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)((ImmutablePoweredData)manipulator).powered().get()));
        }
        if (manipulator instanceof ImmutableDirectionalData) {
            Direction dir = DirectionChecker.checkDirectionToHorizontal((Direction)((Object)((ImmutableDirectionalData)manipulator).direction().get()));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)DirectionResolver.getFor(dir)));
        }
        if (manipulator instanceof ImmutablePortionData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)this.convertPortionType((PortionType)((ImmutablePortionData)manipulator).type().get())));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.HINGE_POSITION)) {
            BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)hinge));
        }
        if (key.equals(Keys.OPEN)) {
            boolean isOpen = (Boolean)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(isOpen)));
        }
        if (key.equals(Keys.POWERED)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.DIRECTION)) {
            Direction dir = DirectionChecker.checkDirectionToHorizontal((Direction)((Object)value));
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)DirectionResolver.getFor(dir)));
        }
        if (key.equals(Keys.PORTION_TYPE)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)this.convertPortionType((PortionType)value)));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private BlockDoor.EnumDoorHalf convertPortionType(PortionType portionType) {
        return portionType == PortionTypes.BOTTOM ? BlockDoor.EnumDoorHalf.LOWER : BlockDoor.EnumDoorHalf.UPPER;
    }

    private ImmutableHingeData getHingeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeHingeData.class, (Hinge)((Object)blockState.func_177229_b((IProperty)BlockDoor.field_176521_M)));
    }

    private ImmutableOpenData getIsOpenFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeOpenData.class, blockState.func_177229_b((IProperty)BlockDoor.field_176519_b));
    }

    private ImmutablePoweredData getIsPoweredFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePoweredData.class, blockState.func_177229_b((IProperty)BlockDoor.field_176522_N));
    }

    private ImmutableDirectionalData getDirectionalData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDirectionalData.class, new Object[]{DirectionResolver.getFor((EnumFacing)blockState.func_177229_b((IProperty)BlockDoor.field_176520_a))});
    }

    private ImmutablePortionData getPortionData(IBlockState blockState) {
        BlockDoor.EnumDoorHalf half = (BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O);
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePortionData.class, half == BlockDoor.EnumDoorHalf.LOWER ? PortionTypes.BOTTOM : PortionTypes.TOP);
    }

    @Override
    public Translation getTranslation() {
        return new SpongeTranslation(this.func_149739_a().replaceAll("tile", "item") + ".name");
    }
}

