/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDirectionalData;
import org.spongepowered.common.data.util.DirectionResolver;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockDispenser.class})
public abstract class MixinBlockDispenser
extends MixinBlock {
    private ItemStackSnapshot originalItem;
    private PhaseContext<?> context;

    @Shadow
    protected abstract void func_176439_d(World var1, BlockPos var2);

    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getDirectionalData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableDirectionalData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableDirectionalData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)DirectionResolver.getFor((Direction)((Object)((ImmutableDirectionalData)manipulator).direction().get()))));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.DIRECTION)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)DirectionResolver.getFor((Direction)((Object)value))));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableDirectionalData getDirectionalData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDirectionalData.class, new Object[]{DirectionResolver.getFor((EnumFacing)blockState.func_177229_b((IProperty)BlockDispenser.field_176441_a))});
    }

    @Inject(method={"dispense"}, at={@At(value="HEAD")})
    public void onDispenseHead(World worldIn, BlockPos pos, CallbackInfo ci) {
        IBlockState state = worldIn.func_180495_p(pos);
        SpongeBlockSnapshot spongeBlockSnapshot = ((IMixinWorldServer)worldIn).createSpongeBlockSnapshot(state, state, pos, BlockChangeFlags.ALL);
        IMixinChunk mixinChunk = (IMixinChunk)worldIn.func_175726_f(pos);
        this.context = ((PhaseContext)((PhaseContext)((PhaseContext)((PhaseContext)BlockPhase.State.DISPENSE.createPhaseContext()).source(spongeBlockSnapshot)).owner(() -> mixinChunk.getBlockOwner(pos))).notifier(() -> mixinChunk.getBlockNotifier(pos))).buildAndSwitch();
    }

    @Inject(method={"dispense"}, at={@At(value="RETURN")})
    public void onDispenseReturn(World worldIn, BlockPos pos, CallbackInfo ci) {
        this.context.close();
    }

    @Redirect(method={"dispense"}, at=@At(value="INVOKE", target="Lnet/minecraft/dispenser/IBehaviorDispenseItem;dispense(Lnet/minecraft/dispenser/IBlockSource;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;"))
    public ItemStack onSpongeDispense(IBehaviorDispenseItem ibehaviordispenseitem, IBlockSource source, ItemStack stack) {
        this.originalItem = ItemStackUtil.snapshotOf(stack);
        return ibehaviordispenseitem.func_82482_a(source, stack);
    }

    @Redirect(method={"dispense"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntityDispenser;setInventorySlotContents(ILnet/minecraft/item/ItemStack;)V"))
    public void onSetInventoryContents(TileEntityDispenser dispenser, int index, @Nullable ItemStack stack) {
        PhaseData phaseData = PhaseTracker.getInstance().getCurrentPhaseData();
        PhaseContext<?> context = phaseData.context;
        if (context.getCapturedItemsOrEmptyList().isEmpty()) {
            dispenser.func_70299_a(index, stack);
            return;
        }
        ItemStack dispensedItem = context.getCapturedItems().get(0).func_92059_d();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(dispensedItem);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(dispenser);
            DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.getCurrentCause(), (List)ImmutableList.of((Object)snapshot), original);
            SpongeImpl.postEvent(dropEvent);
            if (dropEvent.isCancelled()) {
                dispenser.func_70299_a(index, (ItemStack)this.originalItem.createStack());
                context.getCapturedItems().clear();
                return;
            }
            if (dropEvent.getDroppedItems().isEmpty()) {
                context.getCapturedItems().clear();
            }
            dispenser.func_70299_a(index, stack);
        }
    }
}

