/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.ban;

import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.UserListEntryBan;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.SpongeTexts;

@Mixin(value={UserListEntryBan.class})
public abstract class MixinBanEntry<T>
extends UserListEntry<T>
implements Ban {
    @Shadow
    @Final
    private String field_73693_g;
    @Shadow
    @Final
    private String field_73695_e;
    @Shadow
    @Final
    private Date field_73694_d;
    @Shadow
    @Final
    private Date field_73692_f;
    private Optional<Text> spongeReason;
    private Text source;
    private Optional<CommandSource> commandSource = Optional.empty();

    public MixinBanEntry(T p_i1146_1_) {
        super(p_i1146_1_);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    public void onInitMixinBanEntry(CallbackInfo ci) {
        this.spongeReason = this.field_73693_g == null ? Optional.empty() : Optional.of(SpongeTexts.fromLegacy(this.field_73693_g));
        this.source = SpongeTexts.fromLegacy(this.field_73695_e);
        this.setSource();
    }

    private void setSource() {
        if (this.field_73695_e.equals("Server")) {
            this.commandSource = Optional.of(SpongeImpl.getGame().getServer().getConsole());
        } else {
            Optional<Player> user = Sponge.getGame().getServer().getPlayer(this.field_73695_e);
            if (user.isPresent()) {
                this.commandSource = Optional.of(user.get());
            }
        }
    }

    @Override
    public Optional<Text> getReason() {
        return this.spongeReason;
    }

    @Override
    public Instant getCreationDate() {
        return this.field_73694_d.toInstant();
    }

    @Override
    public Optional<Text> getBanSource() {
        return Optional.of(this.source);
    }

    @Override
    public Optional<CommandSource> getBanCommandSource() {
        return this.commandSource;
    }

    @Override
    public Optional<Instant> getExpirationDate() {
        return Optional.ofNullable(this.field_73692_f == null ? null : this.field_73692_f.toInstant());
    }
}

