/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancement;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.PlayerAdvancements;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.Progressable;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.AndCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.advancement.criteria.OrCriterion;
import org.spongepowered.api.advancement.criteria.ScoreAdvancementCriterion;
import org.spongepowered.api.advancement.criteria.ScoreCriterionProgress;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.advancement.CriterionEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.advancement.ICriterionProgress;
import org.spongepowered.common.advancement.SpongeAndCriterion;
import org.spongepowered.common.advancement.SpongeAndCriterionProgress;
import org.spongepowered.common.advancement.SpongeEmptyCriterion;
import org.spongepowered.common.advancement.SpongeOrCriterion;
import org.spongepowered.common.advancement.SpongeOrCriterionProgress;
import org.spongepowered.common.advancement.SpongeScoreCriterion;
import org.spongepowered.common.advancement.SpongeScoreCriterionProgress;
import org.spongepowered.common.interfaces.advancement.IMixinAdvancementProgress;
import org.spongepowered.common.interfaces.advancement.IMixinCriterion;
import org.spongepowered.common.interfaces.advancement.IMixinCriterionProgress;
import org.spongepowered.common.interfaces.advancement.IMixinPlayerAdvancements;
import org.spongepowered.common.registry.type.advancement.AdvancementRegistryModule;

@Mixin(value={AdvancementProgress.class})
public class MixinAdvancementProgress
implements org.spongepowered.api.advancement.AdvancementProgress,
IMixinAdvancementProgress {
    @Shadow
    @Final
    private Map<String, net.minecraft.advancements.CriterionProgress> field_192110_a;
    @Nullable
    private Map<AdvancementCriterion, ICriterionProgress> progressMap;
    @Nullable
    private String advancement;
    @Nullable
    private PlayerAdvancements playerAdvancements;

    private void checkServer() {
        Preconditions.checkState((boolean)SpongeImplHooks.isMainThread());
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void onUpdate(Map<String, Criterion> criteriaIn, String[][] requirements, CallbackInfo ci) {
        String[][] stringArray = requirements;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] reqs;
            for (String req : reqs = stringArray[i]) {
                if (criteriaIn.containsKey(req)) continue;
                String advName = this.getOptionalAdvancement().map(CatalogType::getId).orElse("unknown");
                throw new IllegalStateException("Found a requirement which does not exist in the criteria, " + req + " could not be found for the advancement: " + advName);
            }
        }
        this.updateProgressMap();
    }

    @Override
    public void updateProgressMap() {
        if (!SpongeImplHooks.isMainThread()) {
            return;
        }
        Optional<Advancement> advancement = this.getOptionalAdvancement();
        if (advancement.isPresent()) {
            this.progressMap = new HashMap<AdvancementCriterion, ICriterionProgress>();
            this.processProgressMap(advancement.get().getCriterion(), this.progressMap);
        } else {
            this.progressMap = null;
        }
    }

    private Map<AdvancementCriterion, ICriterionProgress> getProgressMap() {
        Preconditions.checkState((this.progressMap != null ? 1 : 0) != 0, (Object)"progressMap isn't initialized");
        return this.progressMap;
    }

    private void processProgressMap(AdvancementCriterion criterion, Map<AdvancementCriterion, ICriterionProgress> progressMap) {
        if (criterion instanceof OperatorCriterion) {
            ((OperatorCriterion)criterion).getCriteria().forEach(child -> this.processProgressMap((AdvancementCriterion)child, progressMap));
            if (criterion instanceof AndCriterion) {
                progressMap.put(criterion, new SpongeAndCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)this, (SpongeAndCriterion)criterion));
            } else if (criterion instanceof OrCriterion) {
                progressMap.put(criterion, new SpongeOrCriterionProgress((org.spongepowered.api.advancement.AdvancementProgress)this, (SpongeOrCriterion)criterion));
            }
        } else if (criterion instanceof SpongeScoreCriterion) {
            SpongeScoreCriterion scoreCriterion = (SpongeScoreCriterion)criterion;
            for (AdvancementCriterion advancementCriterion : scoreCriterion.internalCriteria) {
                IMixinCriterionProgress progress = (IMixinCriterionProgress)this.field_192110_a.get(advancementCriterion.getName());
                progress.setCriterion(advancementCriterion);
                progressMap.put(advancementCriterion, (ICriterionProgress)((Object)progress));
            }
            progressMap.put(scoreCriterion, new SpongeScoreCriterionProgress(this, scoreCriterion));
        } else if (criterion != SpongeEmptyCriterion.INSTANCE) {
            IMixinCriterionProgress progress = (IMixinCriterionProgress)this.field_192110_a.get(criterion.getName());
            progress.setCriterion(criterion);
            progressMap.put(criterion, (ICriterionProgress)((Object)progress));
        }
    }

    @Inject(method={"isDone"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsDone(CallbackInfoReturnable<Boolean> ci) {
        if (this.advancement == null || !SpongeImplHooks.isMainThread()) {
            return;
        }
        Advancement advancement = this.getOptionalAdvancement().orElse(null);
        if (advancement != null) {
            ci.setReturnValue(this.get(advancement.getCriterion()).map(Progressable::achieved).orElse(false));
        }
    }

    @Inject(method={"grantCriterion(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGrantCriterion(String criterionIn, CallbackInfoReturnable<Boolean> ci) {
        if (!SpongeImplHooks.isMainThread()) {
            return;
        }
        ci.setReturnValue(this.spongeGrantCriterion(criterionIn));
    }

    private boolean spongeGrantCriterion(String criterionIn) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.field_192110_a.get(criterionIn);
        if (criterionProgress == null || criterionProgress.func_192151_a()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.func_192153_b();
            return true;
        }
        Cause cause = SpongeImpl.getCauseStackManager().getCurrentCause();
        Player player = ((IMixinPlayerAdvancements)this.playerAdvancements).getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.getCriterion();
        IMixinCriterion mixinCriterion = (IMixinCriterion)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = mixinCriterion.getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.get(scoreCriterion).get();
            int lastScore = scoreProgress.getScore();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, this.getAdvancement(), scoreCriterion, player, lastScore, score) : (score == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, this.getAdvancement(), scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, this.getAdvancement(), scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventGrant(cause, this.getAdvancement(), criterion, player, Instant.now());
        }
        if (SpongeImpl.postEvent(event)) {
            return false;
        }
        criterionProgress.func_192153_b();
        return true;
    }

    @Inject(method={"revokeCriterion(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void revokeCriterion(String criterionIn, CallbackInfoReturnable<Boolean> ci) {
        if (!SpongeImplHooks.isMainThread()) {
            return;
        }
        ci.setReturnValue(this.spongeRevokeCriterion(criterionIn));
    }

    private boolean spongeRevokeCriterion(String criterionIn) {
        CriterionEvent event;
        net.minecraft.advancements.CriterionProgress criterionProgress = this.field_192110_a.get(criterionIn);
        if (criterionProgress == null || !criterionProgress.func_192151_a()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.func_192154_c();
            return true;
        }
        Cause cause = SpongeImpl.getCauseStackManager().getCurrentCause();
        Player player = ((IMixinPlayerAdvancements)this.playerAdvancements).getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.getCriterion();
        IMixinCriterion mixinCriterion = (IMixinCriterion)((Object)criterion);
        SpongeScoreCriterion scoreCriterion = mixinCriterion.getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.get(scoreCriterion).get();
            int lastScore = scoreProgress.getScore();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreRevoke(cause, this.getAdvancement(), scoreCriterion, player, lastScore, score) : (score == scoreCriterion.getGoal() ? SpongeEventFactory.createCriterionEventScoreGrant(cause, this.getAdvancement(), scoreCriterion, player, Instant.now(), lastScore, score) : SpongeEventFactory.createCriterionEventScoreChange(cause, this.getAdvancement(), scoreCriterion, player, lastScore, score));
        } else {
            event = SpongeEventFactory.createCriterionEventRevoke(cause, this.getAdvancement(), criterion, player);
        }
        if (SpongeImpl.postEvent(event)) {
            return false;
        }
        criterionProgress.func_192154_c();
        return true;
    }

    @Override
    public PlayerAdvancements getPlayerAdvancements() {
        this.checkServer();
        Preconditions.checkState((this.playerAdvancements != null ? 1 : 0) != 0, (Object)"The playerAdvancements is not yet initialized");
        return this.playerAdvancements;
    }

    @Override
    public void setPlayerAdvancements(PlayerAdvancements playerAdvancements) {
        this.checkServer();
        this.playerAdvancements = playerAdvancements;
    }

    @Override
    public void setAdvancement(String advancement) {
        this.checkServer();
        this.advancement = advancement;
    }

    @Override
    public void invalidateAchievedState() {
        if (!SpongeImplHooks.isMainThread()) {
            return;
        }
        for (ICriterionProgress progress : this.getProgressMap().values()) {
            progress.invalidateAchievedState();
        }
    }

    private Optional<Advancement> getOptionalAdvancement() {
        this.checkServer();
        Preconditions.checkState((this.advancement != null ? 1 : 0) != 0, (Object)"The advancement is not yet initialized");
        return AdvancementRegistryModule.getInstance().getById(this.advancement);
    }

    @Override
    public Advancement getAdvancement() {
        return this.getOptionalAdvancement().orElseThrow(() -> new IllegalStateException("The advancement of this advancement progress is unloaded: " + this.advancement));
    }

    @Override
    public Optional<ScoreCriterionProgress> get(ScoreAdvancementCriterion criterion) {
        this.checkServer();
        return Optional.ofNullable((ScoreCriterionProgress)((Object)this.getProgressMap().get(criterion)));
    }

    @Override
    public Optional<CriterionProgress> get(AdvancementCriterion criterion) {
        this.checkServer();
        Preconditions.checkNotNull((Object)criterion, (Object)"criterion");
        return Optional.ofNullable(this.getProgressMap().get(criterion));
    }

    @Override
    public Optional<Instant> get() {
        return this.get(this.getAdvancement().getCriterion()).get().get();
    }

    @Override
    public Instant grant() {
        return this.get(this.getAdvancement().getCriterion()).get().grant();
    }

    @Override
    public Optional<Instant> revoke() {
        return this.get(this.getAdvancement().getCriterion()).get().revoke();
    }
}

