/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.adapter.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.LensProvider;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.DefaultEmptyLens;
import org.spongepowered.common.item.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.item.inventory.lens.impl.ReusableLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.slots.SlotLens;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class AbstractInventoryAdapter
implements MinecraftInventoryAdapter {
    public static final Translation DEFAULT_NAME = new SpongeTranslation("inventory.default.title");
    protected final Fabric inventory;
    protected final SlotCollection slots;
    protected final Lens lens;
    protected final List<Inventory> children = new ArrayList<Inventory>();
    protected Inventory parent;
    @Nullable
    protected Inventory next;
    @Nullable
    private Iterable<Slot> slotIterator;

    public AbstractInventoryAdapter(Fabric inventory) {
        this(inventory, null, null);
    }

    public <T extends Lens> AbstractInventoryAdapter(Fabric inventory, Class<T> lensType) {
        this.inventory = inventory;
        this.parent = this;
        if (inventory.getSize() == 0) {
            this.slots = new SlotCollection(0);
            this.lens = new DefaultEmptyLens(this);
        } else {
            ReusableLens<Lens> lens = ReusableLens.getLens(lensType, this, () -> this.initSlots(inventory, this.parent), slots -> new DefaultIndexedLens(0, inventory.getSize(), (InventoryAdapter)this, (SlotCollection)slots));
            this.slots = (SlotCollection)lens.getSlots();
            this.lens = lens.getLens();
        }
    }

    public AbstractInventoryAdapter(Fabric inventory, @Nullable Lens root, @Nullable Inventory parent) {
        this.inventory = inventory;
        this.parent = parent == null ? this : parent;
        this.slots = this.initSlots(inventory, parent);
        this.lens = root != null ? root : (Lens)Preconditions.checkNotNull((Object)this.initRootLens(), (Object)"root lens");
    }

    private SlotCollection initSlots(Fabric inventory, @Nullable Inventory parent) {
        SlotProvider sp;
        if (parent instanceof MinecraftInventoryAdapter && (sp = ((MinecraftInventoryAdapter)parent).getSlotProvider()) instanceof SlotCollection) {
            return (SlotCollection)sp;
        }
        return new SlotCollection(inventory.getSize());
    }

    @Override
    public Inventory parent() {
        return this.parent;
    }

    protected Lens initRootLens() {
        if (this instanceof LensProvider) {
            return ((LensProvider)((Object)this)).rootLens(this.inventory, this);
        }
        int size = this.inventory.getSize();
        if (size == 0) {
            return new DefaultEmptyLens(this);
        }
        return new DefaultIndexedLens(0, size, (InventoryAdapter)this, this.slots);
    }

    @Override
    public SlotProvider getSlotProvider() {
        return this.slots;
    }

    @Override
    public Lens getRootLens() {
        return this.lens;
    }

    @Override
    public Fabric getFabric() {
        return this.inventory;
    }

    @Override
    public Inventory getChild(int index) {
        if (index < 0 || index >= this.lens.getChildren().size()) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        while (index >= this.children.size()) {
            this.children.add(null);
        }
        Inventory child = this.children.get(index);
        if (child == null) {
            child = this.lens.getChildren().get(index).getAdapter(this.inventory, this);
            this.children.set(index, child);
        }
        return child;
    }

    @Override
    public Inventory getChild(Lens lens) {
        return null;
    }

    @Override
    public <T extends Inventory> Iterable<T> slots() {
        if (this.slotIterator == null) {
            this.slotIterator = this.slots.getIterator(this);
        }
        return this.slotIterator;
    }

    @Override
    public void clear() {
        this.slots().forEach(Inventory::clear);
    }

    public static Optional<Slot> forSlot(Fabric inv, SlotLens slotLens, Inventory parent) {
        return slotLens == null ? Optional.empty() : Optional.ofNullable((Slot)((Object)slotLens.getAdapter(inv, parent)));
    }

    @Override
    public PluginContainer getPlugin() {
        if (this.parent != this) {
            return this.parent.getPlugin();
        }
        return null;
    }
}

