/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject.provider.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.config.SpongeConfigManager;
import org.spongepowered.common.inject.provider.PathAsFileProvider;
import org.spongepowered.common.inject.provider.config.ConfigDirAnnotation;
import org.spongepowered.common.inject.provider.config.DefaultConfigAnnotation;

public final class PluginConfigurationModule
extends AbstractModule {
    private static final TypeLiteral<ConfigurationLoader<CommentedConfigurationNode>> COMMENTED_CONFIGURATION_NODE_LOADER = new TypeLiteral<ConfigurationLoader<CommentedConfigurationNode>>(){};

    @Override
    protected void configure() {
        this.bind(Path.class).annotatedWith(ConfigDirAnnotation.NON_SHARED).toProvider(NonSharedDirAsPath.class);
        this.bind(File.class).annotatedWith(ConfigDirAnnotation.NON_SHARED).toProvider(NonSharedDirAsFile.class);
        this.bind(Path.class).annotatedWith(DefaultConfigAnnotation.NON_SHARED).toProvider(NonSharedPathAsPath.class);
        this.bind(File.class).annotatedWith(DefaultConfigAnnotation.NON_SHARED).toProvider(NonSharedPathAsFile.class);
        this.bind(Path.class).annotatedWith(DefaultConfigAnnotation.SHARED).toProvider(SharedDirAsPath.class);
        this.bind(File.class).annotatedWith(DefaultConfigAnnotation.SHARED).toProvider(SharedDirAsFile.class);
        this.bind(COMMENTED_CONFIGURATION_NODE_LOADER).annotatedWith(DefaultConfigAnnotation.SHARED).toProvider(SharedCommentedConfigurationNode.class);
        this.bind(COMMENTED_CONFIGURATION_NODE_LOADER).annotatedWith(DefaultConfigAnnotation.NON_SHARED).toProvider(PrivateCommentedConfigurationNode.class);
    }

    static class PrivateCommentedConfigurationNode
    extends CommentedConfigurationNodeProvider {
        PrivateCommentedConfigurationNode() {
        }

        @Override
        public ConfigurationLoader<CommentedConfigurationNode> get() {
            return SpongeConfigManager.getPrivateRoot(this.container).getConfig();
        }
    }

    static class SharedCommentedConfigurationNode
    extends CommentedConfigurationNodeProvider {
        SharedCommentedConfigurationNode() {
        }

        @Override
        public ConfigurationLoader<CommentedConfigurationNode> get() {
            return SpongeConfigManager.getSharedRoot(this.container).getConfig();
        }
    }

    static abstract class CommentedConfigurationNodeProvider
    implements Provider<ConfigurationLoader<CommentedConfigurationNode>> {
        @Inject
        protected PluginContainer container;

        CommentedConfigurationNodeProvider() {
        }
    }

    static class SharedDirAsFile
    extends PathAsFileProvider {
        SharedDirAsFile() {
        }

        @Inject
        void init(@DefaultConfig(sharedRoot=true) Provider<Path> path) {
            this.path = path;
        }
    }

    static class SharedDirAsPath
    implements Provider<Path> {
        @Inject
        private PluginContainer container;

        SharedDirAsPath() {
        }

        @Override
        public Path get() {
            return SpongeConfigManager.getSharedRoot(this.container).getConfigPath();
        }
    }

    public static class NonSharedPathAsFile
    extends PathAsFileProvider {
        @Inject
        void init(@DefaultConfig(sharedRoot=false) Provider<Path> path) {
            this.path = path;
        }
    }

    public static class NonSharedPathAsPath
    implements Provider<Path> {
        @Inject
        private PluginContainer container;

        @Override
        public Path get() {
            return SpongeConfigManager.getPrivateRoot(this.container).getConfigPath();
        }
    }

    public static class NonSharedDirAsFile
    extends PathAsFileProvider {
        @Inject
        void init(@ConfigDir(sharedRoot=false) Provider<Path> path) {
            this.path = path;
        }
    }

    public static class NonSharedDirAsPath
    implements Provider<Path> {
        @Inject
        private PluginContainer container;

        @Override
        public Path get() {
            return SpongeConfigManager.getPrivateRoot(this.container).getDirectory();
        }
    }
}

