/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject;

import com.google.common.base.MoreObjects;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class SpongeInjectionPoint
implements AnnotatedElement {
    private final TypeToken<?> source;
    private final TypeToken<?> type;
    private final Annotation[] annotations;

    SpongeInjectionPoint(TypeToken<?> source, TypeToken<?> type, Annotation[] annotations) {
        this.annotations = annotations;
        this.source = source;
        this.type = type;
    }

    public TypeToken<?> getSource() {
        return this.source;
    }

    public TypeToken<?> getType() {
        return this.type;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return (A)((Annotation)Arrays.stream(this.annotations).filter(annotationClass::isInstance).findFirst().orElse(null));
    }

    @Override
    public Annotation[] getAnnotations() {
        return Arrays.copyOf(this.annotations, this.annotations.length);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return Arrays.copyOf(this.annotations, this.annotations.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", this.source).add("type", this.type).add("annotations", (Object)Arrays.toString(this.annotations)).toString();
    }
}

