/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

abstract class LocationBasedTickPhaseState<T extends LocationBasedTickContext<T>>
extends TickPhaseState<T> {
    private final BiConsumer<CauseStackManager.StackFrame, T> LOCATION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> context.getSource(LocatableBlock.class).ifPresent(frame::pushCause));

    LocationBasedTickPhaseState() {
    }

    abstract LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> var1);

    @Override
    public BiConsumer<CauseStackManager.StackFrame, T> getFrameModifier() {
        return this.LOCATION_MODIFIER;
    }

    @Override
    public void associateNeighborStateNotifier(T context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        ((PhaseContext)context).applyNotifierIfAvailable(user -> {
            IMixinChunk mixinChunk = (IMixinChunk)minecraftWorld.func_175726_f(notifyPos);
            mixinChunk.addTrackedBlockPosition(block, notifyPos, (User)user, PlayerTracker.Type.NOTIFIER);
        });
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<BlockSnapshot> snapshotTransaction, T context) {
        ((PhaseContext)context).applyNotifierIfAvailable(user -> {
            Block block = (Block)((BlockSnapshot)snapshotTransaction.getOriginal()).getState().getType();
            Location<World> changedLocation = ((BlockSnapshot)snapshotTransaction.getOriginal()).getLocation().get();
            BlockPos changedBlockPos = VecHelper.toBlockPos(changedLocation);
            IMixinChunk changedMixinChunk = (IMixinChunk)((WorldServer)changedLocation.getExtent()).func_175726_f(changedBlockPos);
            changedMixinChunk.addTrackedBlockPosition(block, changedBlockPos, (User)user, PlayerTracker.Type.NOTIFIER);
            if (blockChange == BlockChange.PLACE) {
                context.applyOwnerIfAvailable(owner -> changedMixinChunk.addTrackedBlockPosition(block, changedBlockPos, (User)owner, PlayerTracker.Type.OWNER));
            }
        });
    }

    @Override
    public boolean canSwitchTo(IPhaseState<?> state) {
        return super.canSwitchTo(state) || state == GenerationPhase.State.CHUNK_LOADING;
    }
}

