/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;

class BlockTickPhaseState
extends LocationBasedTickPhaseState<BlockTickContext> {
    private final String name;

    BlockTickPhaseState(String name) {
        this.name = name;
    }

    @Override
    public BlockTickContext createPhaseContext() {
        return (BlockTickContext)new BlockTickContext(this).addCaptures();
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
    }

    @Override
    public void unwind(BlockTickContext context) {
        context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, context));
        context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
            Sponge.getCauseStackManager().addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem entity : items) {
                capturedEntities.add(EntityUtil.fromNative((Entity)entity));
            }
            SpongeCommonEventFactory.callSpawnEntity(capturedEntities, context);
        });
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, BlockTickContext context) {
        context.applyOwnerIfAvailable(explosionContext::owner);
        context.applyNotifierIfAvailable(explosionContext::notifier);
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        explosionContext.source(locatableBlock);
    }

    @Override
    public boolean spawnEntityOrCapture(BlockTickContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        LocatableBlock locatableBlock = this.getLocatableBlockSourceFromContext(context);
        if (!context.allowsEntityEvents() || !ShouldFire.SPAWN_ENTITY_EVENT) {
            return EntityUtil.processEntitySpawn(entity, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(locatableBlock);
            if (entity instanceof EntityXPOrb) {
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
                entities.add(entity);
                boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
                return bl;
            }
            ArrayList<org.spongepowered.api.entity.Entity> nonExpEntities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
            nonExpEntities.add(entity);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(nonExpEntities, context);
            return bl;
        }
    }

    @Override
    public boolean doesCaptureEntitySpawns() {
        return false;
    }

    @Override
    public void postTrackBlock(BlockSnapshot snapshot, BlockTickContext context) {
        if (context.shouldProcessImmediately()) {
            TrackingUtil.processBlockCaptures(context.getCapturedBlocks(), this, context);
            context.getCapturedBlockSupplier().get().remove(snapshot);
        }
    }

    @Override
    public boolean doesBulkBlockCapture(BlockTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean doesBlockEventTracking(BlockTickContext context) {
        return context.allowsBlockEvents();
    }

    @Override
    public boolean doesCaptureEntityDrops(BlockTickContext context) {
        return true;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

