/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;

public final class UnknownPacketState
extends BasicPacketState {
    @Override
    public boolean ignoresItemPreMerging() {
        return true;
    }

    @Override
    public boolean tracksBlockSpecificDrops(BasicPacketContext context) {
        return true;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public void unwind(BasicPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        try (CauseStackManager.StackFrame frame1 = Sponge.getCauseStackManager().pushCauseFrame();){
            frame1.pushCause(player);
            frame1.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT);
            context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
            context.getCapturedEntitySupplier().acceptAndClearIfNotEmpty(entities -> SpongeCommonEventFactory.callSpawnEntity(entities, context));
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                List<org.spongepowered.api.entity.Entity> items = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                SpongeCommonEventFactory.callSpawnEntity(items, context);
            });
        }
        context.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(map -> {
            PrettyPrinter printer = new PrettyPrinter(80);
            printer.add("Processing An Unknown Packet for Entity Drops").centre().hr();
            printer.add("The item stacks captured are: ");
            for (Map.Entry entry : map.asMap().entrySet()) {
                printer.add("  - Entity with UUID: %s", entry.getKey());
                for (ItemDropData stack : (Collection)entry.getValue()) {
                    printer.add("    - %s", stack);
                }
            }
            printer.trace(System.err);
        });
        context.getPerEntityItemEntityDropSupplier().acceptAndClearIfNotEmpty(map -> {
            for (Map.Entry entry : map.asMap().entrySet()) {
                List entities;
                UUID entityUuid = (UUID)entry.getKey();
                Entity entityFromUuid = player.func_71121_q().func_175733_a(entityUuid);
                org.spongepowered.api.entity.Entity affectedEntity = EntityUtil.fromNative(entityFromUuid);
                if (entityFromUuid == null || (entities = ((Collection)entry.getValue()).stream().map(EntityUtil::fromNative).collect(Collectors.toList())).isEmpty()) continue;
                CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                Throwable throwable = null;
                try {
                    frame.pushCause(player);
                    frame.pushCause(affectedEntity);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
                    DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(frame.getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (event.isCancelled()) continue;
                    UnknownPacketState.processSpawnedEntities(player, event);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (frame == null) continue;
                    if (throwable != null) {
                        try {
                            frame.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    frame.close();
                }
            }
        });
        context.getCapturedItemStackSupplier().acceptAndClearIfNotEmpty(drops -> {
            List items = drops.stream().map(drop -> drop.create(player.func_71121_q())).collect(Collectors.toList());
            List entities = items.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
            if (!entities.isEmpty()) {
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    frame.pushCause(player);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.CUSTOM);
                    DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(frame.getCurrentCause(), entities);
                    SpongeImpl.postEvent(event);
                    if (!event.isCancelled()) {
                        UnknownPacketState.processSpawnedEntities(player, event);
                    }
                }
            }
        });
    }
}

