/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketConstants;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.item.inventory.util.ContainerUtil;

public final class DropItemWithHotkeyState
extends BasicInventoryPacketState {
    public DropItemWithHotkeyState() {
        super(PacketConstants.MODE_DROP | 1 | 2 | 0x10000);
    }

    @Override
    public boolean doesCaptureEntityDrops(InventoryPacketContext context) {
        return true;
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        org.spongepowered.api.entity.Entity spongePlayer = EntityUtil.fromNative((Entity)player);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(spongePlayer);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            context.getCapturedBlockSupplier().acceptAndClearIfNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(items -> {
                CPacketPlayerDigging packetIn;
                ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
                for (EntityItem item : items) {
                    entities.add(EntityUtil.fromNative((Entity)item));
                }
                int usedButton = 0;
                if (context.getPacket() instanceof CPacketPlayerDigging) {
                    packetIn = (CPacketPlayerDigging)context.getPacket();
                    usedButton = packetIn.func_180762_c() == CPacketPlayerDigging.Action.DROP_ITEM ? 0 : 1;
                } else {
                    packetIn = (CPacketClickWindow)context.getPacket();
                    usedButton = packetIn.func_149543_e();
                }
                Transaction<ItemStackSnapshot> cursorTrans = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, ItemStackSnapshot.NONE);
                IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
                List<SlotTransaction> slotTrans = mixinContainer.getCapturedTransactions();
                ClickInventoryEvent dropItemEvent = this.createInventoryEvent(player, ContainerUtil.fromNative(player.field_71070_bA), (Transaction)cursorTrans, (List)Lists.newArrayList(slotTrans), entities, usedButton);
                SpongeImpl.postEvent(dropItemEvent);
                if (dropItemEvent.isCancelled() || PacketPhaseUtil.allTransactionsInvalid(dropItemEvent.getTransactions())) {
                    ((IMixinEntityPlayerMP)player).restorePacketItem(EnumHand.MAIN_HAND);
                    PacketPhaseUtil.handleSlotRestore((EntityPlayer)player, player.field_71070_bA, dropItemEvent.getTransactions(), true);
                } else {
                    DropItemWithHotkeyState.processSpawnedEntities(player, (SpawnEntityEvent)((Object)dropItemEvent));
                }
                slotTrans.clear();
                mixinContainer.setCaptureInventory(false);
            });
            context.getPerEntityItemDropSupplier().acceptAndClearIfNotEmpty(itemMapping -> {});
            IMixinContainer mixinContainer = ContainerUtil.toMixin(player.field_71070_bA);
            mixinContainer.setCaptureInventory(false);
            mixinContainer.getCapturedTransactions().clear();
        }
    }

    @Override
    public ClickInventoryEvent.Drop createInventoryEvent(EntityPlayerMP playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<org.spongepowered.api.entity.Entity> capturedEntities, int usedButton) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            ClickInventoryEvent.Drop event;
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            for (org.spongepowered.api.entity.Entity currentEntity : capturedEntities) {
                currentEntity.setCreator(playerMP.func_110124_au());
            }
            ClickInventoryEvent.Drop drop = event = usedButton == 0 ? SpongeEventFactory.createClickInventoryEventDropSingle(Sponge.getCauseStackManager().getCurrentCause(), transaction, capturedEntities, openContainer, slotTransactions) : SpongeEventFactory.createClickInventoryEventDropFull(Sponge.getCauseStackManager().getCurrentCause(), transaction, capturedEntities, openContainer, slotTransactions);
            return drop;
        }
    }

    @Override
    public boolean ignoresItemPreMerging() {
        return true;
    }
}

