/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.config.category.PhaseTrackerCategory;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseStack;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.event.tracking.phase.general.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.phase.tick.NeighborNotificationContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.event.SpawnTypeRegistryModule;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;
import org.spongepowered.common.world.WorldUtil;

public final class PhaseTracker {
    private static final PhaseTracker INSTANCE = new PhaseTracker();
    public static final String ASYNC_BLOCK_CHANGE_MESSAGE = "Sponge adapts the vanilla handling of block changes to power events and plugins such that it follows the known fact that block changes MUST occur on the server thread (even on clients, this exists as the InternalServer thread). It is NOT possible to change this fact and must be reported to the offending mod for async issues.";
    public static final String ASYNC_TRACKER_ACCESS = "Sponge adapts the vanilla handling of various processes, such as setting a block or spawning an entity. Sponge is designed around the concept that Minecraft is primarily performing these operations on the \"server thread\". Because of this Sponge is safeguarding common access to the PhaseTracker as the entrypoint for performing these sort of changes.";
    private static final CopyOnWriteArrayList<net.minecraft.entity.Entity> ASYNC_CAPTURED_ENTITIES = new CopyOnWriteArrayList();
    private static final Task ASYNC_TO_SYNC_SPAWNER = Task.builder().name("Sponge Async To Sync Entity Spawn Task").intervalTicks(1L).execute(() -> {
        if (ASYNC_CAPTURED_ENTITIES.isEmpty()) {
            return;
        }
        ArrayList<net.minecraft.entity.Entity> entities = new ArrayList<net.minecraft.entity.Entity>(ASYNC_CAPTURED_ENTITIES);
        ASYNC_CAPTURED_ENTITIES.removeAll(entities);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypeRegistryModule.FORCED);
            for (net.minecraft.entity.Entity entity : entities) {
                PhaseTracker.getInstance().spawnEntityWithCause((World)entity.func_130014_f_(), (Entity)entity);
            }
        }
    }).submit(SpongeImpl.getPlugin());
    public static final BiConsumer<PrettyPrinter, PhaseContext<?>> CONTEXT_PRINTER = (printer, context) -> context.printCustom((PrettyPrinter)printer, 4);
    private static final BiConsumer<PrettyPrinter, PhaseData> PHASE_PRINTER = (printer, data) -> {
        printer.add("  - Phase: %s", data.state);
        printer.add("    Context:");
        data.context.printCustom((PrettyPrinter)printer, 4);
        data.context.printTrace((PrettyPrinter)printer);
    };
    private final PhaseStack stack = new PhaseStack();
    private boolean hasPrintedEmptyOnce = false;
    private boolean hasPrintedAboutRunnawayPhases = false;
    private boolean hasPrintedAsyncEntities = false;
    private int printRunawayCount = 0;
    private final List<IPhaseState<?>> printedExceptionsForBlocks = new ArrayList();
    private final List<IPhaseState<?>> printedExceptionsForEntities = new ArrayList();
    private final List<Tuple<IPhaseState<?>, IPhaseState<?>>> completedIncorrectStates = new ArrayList();
    private final List<IPhaseState<?>> printedExceptionsForState = new ArrayList();
    private final Set<IPhaseState<?>> printedExceptionsForUnprocessedState = new HashSet();
    private final Set<IPhaseState<?>> printedExceptionForMaximumProcessDepth = new HashSet();

    public static PhaseTracker getInstance() {
        return (PhaseTracker)Preconditions.checkNotNull((Object)INSTANCE, (Object)"PhaseTracker instance was illegally set to null!");
    }

    void switchToPhase(IPhaseState<?> state, PhaseContext<?> phaseContext) {
        if (!SpongeImplHooks.isMainThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped(ASYNC_TRACKER_ACCESS, new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
            return;
        }
        Preconditions.checkNotNull(state, (Object)"State cannot be null!");
        Preconditions.checkNotNull((Object)state.getPhase(), (Object)"Phase cannot be null!");
        Preconditions.checkNotNull(phaseContext, (Object)"PhaseContext cannot be null!");
        Preconditions.checkArgument((boolean)phaseContext.isComplete(), (Object)"PhaseContext must be complete!");
        IPhaseState<?> currentState = this.stack.peek().state;
        if (SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            if (this.stack.size() > 6 && this.stack.checkForRunaways(state)) {
                this.printRunawayPhase(state, phaseContext);
            }
            if (state != GeneralPhase.Post.UNWINDING && currentState == GeneralPhase.Post.UNWINDING && !currentState.canSwitchTo(state)) {
                this.printPhaseIncompatibility(currentState, state);
            }
        }
        if (Sponge.isServerAvailable()) {
            SpongeImpl.getCauseStackManager().registerPhaseContextProvider(phaseContext, state.getFrameModifier());
        }
        this.stack.push(state, phaseContext);
    }

    public void printExceptionFromPhase(Throwable t) {
        this.printMessageWithCaughtException("Exception during phase body", "Something happened trying to run the main body of a phase", t);
    }

    public void completePhase(IPhaseState<?> prevState) {
        if (!SpongeImplHooks.isMainThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped(ASYNC_TRACKER_ACCESS, new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
            return;
        }
        PhaseData currentPhaseData = this.stack.peek();
        IPhaseState<?> state = currentPhaseData.state;
        boolean isEmpty = this.stack.isEmpty();
        if (isEmpty) {
            this.printEmptyStackOnCompletion();
            return;
        }
        if (prevState != state) {
            this.printIncorrectPhaseCompletion(prevState, state);
            this.stack.pop();
        }
        if (SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && this.stack.checkForRunaways(GeneralPhase.Post.UNWINDING)) {
            this.printRunnawayPhaseCompletion(state);
        }
        TrackingPhase phase = state.getPhase();
        PhaseContext<?> context = currentPhaseData.context;
        try (UnwindingPhaseContext unwinding = UnwindingPhaseContext.unwind(state, context);){
            try {
                if (context.hasCaptures()) {
                    state.unwind(context);
                }
            }
            catch (Exception e) {
                this.printMessageWithCaughtException("Exception Exiting Phase", "Something happened when trying to unwind", state, context, e);
            }
        }
        catch (Exception e) {
            this.printMessageWithCaughtException("Exception Post Dispatching Phase", "Something happened when trying to post dispatch state", state, context, e);
        }
        this.checkPhaseContextProcessed(state, context);
        this.stack.pop();
    }

    private void printRunnawayPhaseCompletion(IPhaseState<?> state) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && !this.hasPrintedAboutRunnawayPhases) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Completing Phase").centre().hr();
        printer.addWrapped(60, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!! Sponge will stop printingafter three more times to avoid generating extra logs", new Object[0]);
        printer.add();
        printer.addWrapped(60, "%s : %s", "Completing phase", state);
        printer.add(" Phases Remaining:");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add();
        printer.add("Stacktrace:");
        printer.add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && this.printRunawayCount++ > 3) {
            this.hasPrintedAboutRunnawayPhases = true;
        }
    }

    public void generateVersionInfo(PrettyPrinter printer) {
        for (PluginContainer pluginContainer : SpongeImpl.getInternalPlugins()) {
            pluginContainer.getVersion().ifPresent(version -> printer.add("%s : %s", pluginContainer.getName(), version));
        }
    }

    private void printIncorrectPhaseCompletion(IPhaseState<?> prevState, IPhaseState<?> state) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && !this.completedIncorrectStates.isEmpty()) {
            for (Tuple<IPhaseState<?>, IPhaseState<?>> tuple : this.completedIncorrectStates) {
                if (!tuple.getFirst().equals(prevState) || !tuple.getSecond().equals(state)) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Completing incorrect phase").centre().hr().addWrapped("Sponge's tracking system is very dependent on knowing when a change to any world takes place, however, we are attempting to complete a \"phase\" other than the one we most recently entered. This is an error usually on Sponge's part, so a report is required on the issue tracker on GitHub.", new Object[0]).hr().add("Expected to exit phase: %s", prevState).add("But instead found phase: %s", state).add("StackTrace:").add(new Exception());
        printer.add(" Phases Remaining:");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            this.completedIncorrectStates.add(new Tuple(prevState, state));
        }
    }

    private void printEmptyStackOnCompletion() {
        if (this.hasPrintedEmptyOnce) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Unexpectedly Completing An Empty Stack").centre().hr().addWrapped(60, "Sponge's tracking system is very dependent on knowing when a change to any world takes place, however, we have been told to complete a \"phase\" without having entered any phases. This is an error usually on Sponge's part, so a report is required on the issue tracker on GitHub.", new Object[0]).hr().add("StackTrace:").add(new Exception()).add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            this.hasPrintedEmptyOnce = true;
        }
    }

    private void printRunawayPhase(IPhaseState<?> state, PhaseContext<?> context) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && !this.hasPrintedAboutRunnawayPhases) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Switching Phase").centre().hr();
        printer.addWrapped(60, "Detecting a runaway phase! Potentially a problem where something isn't completing a phase!!!", new Object[0]);
        printer.add("  %s : %s", "Entering Phase", state.getPhase());
        printer.add("  %s : %s", "Entering State", state);
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add();
        printer.add("  %s :", "Printing stack trace").add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && this.printRunawayCount++ > SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().getMaximumRunawayCount()) {
            this.hasPrintedAboutRunnawayPhases = true;
        }
    }

    private void printPhaseIncompatibility(IPhaseState<?> currentState, IPhaseState<?> incompatibleState) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && !this.completedIncorrectStates.isEmpty()) {
            for (Tuple<IPhaseState<?>, IPhaseState<?>> tuple : this.completedIncorrectStates) {
                if (!tuple.getFirst().equals(currentState) || !tuple.getSecond().equals(incompatibleState)) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add("Switching Phase").centre().hr();
        printer.add("Phase incompatibility detected! Attempting to switch to an invalid phase!");
        printer.add("  %s : %s", "Current Phase", currentState.getPhase());
        printer.add("  %s : %s", "Current State", currentState);
        printer.add("  %s : %s", "Entering incompatible Phase", incompatibleState.getPhase());
        printer.add("  %s : %s", "Entering incompatible State", incompatibleState);
        printer.add("%s :", "Current phases");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("  %s :", "Printing stack trace");
        printer.add(new Exception("Stack trace"));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            this.completedIncorrectStates.add(Tuple.of(currentState, incompatibleState));
        }
    }

    public void printMessageWithCaughtException(String header, String subHeader, @Nullable Throwable e) {
        this.printMessageWithCaughtException(header, subHeader, this.getCurrentState(), this.getCurrentContext(), e);
    }

    private void printMessageWithCaughtException(String header, String subHeader, IPhaseState<?> state, PhaseContext<?> context, @Nullable Throwable t) {
        PrettyPrinter printer = new PrettyPrinter(60);
        printer.add(header).centre().hr().add("%s %s", subHeader, state).addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        if (t != null) {
            printer.add("Stacktrace:").add(t);
        }
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    public void printExceptionFromPhase(Throwable e, PhaseContext<?> context) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && !this.printedExceptionsForState.isEmpty()) {
            for (IPhaseState<?> iPhaseState : this.printedExceptionsForState) {
                if (context.state != iPhaseState) continue;
                return;
            }
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception occurred during a PhaseState").centre().hr().addWrapped("Sponge's tracking system makes a best effort to not throw exceptions randomly but sometimes it is inevitable. In most cases, something else triggered this exception and Sponge prevented a crash by catching it. The following stacktrace can be used to help pinpoint the cause.", new Object[0]).hr().add("The PhaseState having an exception: %s", context.state).add("The PhaseContext:");
        printer.add(context.printCustom(printer, 4));
        printer.hr().add("StackTrace:").add(e);
        printer.add(" Phases Remaining:");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add();
        this.generateVersionInfo(printer);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            this.printedExceptionsForState.add(context.state);
        }
    }

    private void checkPhaseContextProcessed(IPhaseState<?> state, PhaseContext<?> context) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && this.printedExceptionsForUnprocessedState.contains(state)) {
            return;
        }
        if (context.notAllCapturesProcessed()) {
            this.printUnprocessedPhaseContextObjects(state, context);
            this.printedExceptionsForUnprocessedState.add(state);
        }
    }

    private void printUnprocessedPhaseContextObjects(IPhaseState<?> state, PhaseContext<?> context) {
        this.printMessageWithCaughtException("Failed to process all PhaseContext captured!", "During the processing of a phase, certain objects were captured in a PhaseContext. All of them should have been removed from the PhaseContext by this point", state, context, null);
    }

    private void printBlockTrackingException(PhaseData phaseData, IPhaseState<?> phaseState, Throwable e) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && !this.printedExceptionsForBlocks.isEmpty() && this.printedExceptionsForBlocks.contains(phaseState)) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture a block change!").centre().hr();
        printer.addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, phaseData.context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("Stacktrace:");
        printer.add(e);
        printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            this.printedExceptionsForBlocks.add(phaseState);
        }
    }

    private void printUnexpectedBlockChange(IMixinWorldServer mixinWorld, BlockPos pos, IBlockState currentState, IBlockState newState) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            return;
        }
        new PrettyPrinter(60).add("Unexpected World Change Detected!").centre().hr().add("Sponge's tracking system is very dependent on knowing when\na change to any world takes place, however there are chances\nwhere Sponge does not know of changes that mods may perform.\nIn cases like this, it is best to report to Sponge to get this\nchange tracked correctly and accurately.").hr().add().add("%s : %s", "World", mixinWorld).add("%s : %s", "Position", pos).add("%s : %s", "Current State", currentState).add("%s : %s", "New State", newState).add().add("StackTrace:").add(new Exception()).trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
    }

    private void printExceptionSpawningEntity(PhaseContext<?> context, Throwable e) {
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose() && !this.printedExceptionsForEntities.isEmpty() && this.printedExceptionsForEntities.contains(context.state)) {
            return;
        }
        PrettyPrinter printer = new PrettyPrinter(60).add("Exception attempting to capture or spawn an Entity!").centre().hr();
        printer.addWrapped(60, "%s :", "PhaseContext");
        CONTEXT_PRINTER.accept(printer, context);
        printer.addWrapped(60, "%s :", "Phases remaining");
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        printer.add("Stacktrace:");
        printer.add(e);
        printer.log(SpongeImpl.getLogger(), Level.ERROR);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            this.printedExceptionsForEntities.add(context.state);
        }
    }

    String dumpStack() {
        if (this.stack.isEmpty()) {
            return "[Empty stack]";
        }
        PrettyPrinter printer = new PrettyPrinter(40);
        this.stack.forEach(data -> PHASE_PRINTER.accept(printer, (PhaseData)data));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        printer.print(new PrintStream(stream));
        return stream.toString();
    }

    public PhaseData getCurrentPhaseData() {
        return this.stack.peek();
    }

    public IPhaseState<?> getCurrentState() {
        return this.stack.peekState();
    }

    public PhaseContext<?> getCurrentContext() {
        return this.stack.peekContext();
    }

    public void notifyBlockOfStateChange(IMixinWorldServer mixinWorld, BlockPos notifyPos, Block sourceBlock, BlockPos sourcePos) {
        if (!SpongeImplHooks.isMainThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped(ASYNC_TRACKER_ACCESS, new Object[0]).add().add(new Exception("Async Block Notifcation Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
            return;
        }
        IBlockState iblockstate = ((WorldServer)mixinWorld).func_180495_p(notifyPos);
        try {
            PhaseData peek = this.stack.peek();
            IPhaseState<?> state = peek.state;
            state.associateNeighborStateNotifier(peek.context, sourcePos, iblockstate.func_177230_c(), notifyPos, (WorldServer)mixinWorld, PlayerTracker.Type.NOTIFIER);
            LocatableBlock block = new SpongeLocatableBlockBuilder().world((World)((Object)mixinWorld)).position(sourcePos.func_177958_n(), sourcePos.func_177956_o(), sourcePos.func_177952_p()).state((BlockState)iblockstate).build();
            try (NeighborNotificationContext context = TickPhase.Tick.NEIGHBOR_NOTIFY.createPhaseContext().source(block).sourceBlock(sourceBlock).setNotifiedBlockPos(notifyPos).setNotifiedBlockState(iblockstate).setSourceNotification(sourcePos).allowsCaptures(state);){
                state.provideNotifierForNeighbors(peek.context, context);
                context.buildAndSwitch();
                iblockstate.func_189546_a((net.minecraft.world.World)((WorldServer)mixinWorld), notifyPos, sourceBlock, sourcePos);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while updating neighbours");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
            crashreportcategory.func_189529_a("Source block type", () -> {
                try {
                    return String.format("ID #%d (%s // %s)", Block.func_149682_b((Block)sourceBlock), sourceBlock.func_149739_a(), sourceBlock.getClass().getCanonicalName());
                }
                catch (Throwable var2) {
                    return "ID #" + Block.func_149682_b((Block)sourceBlock);
                }
            });
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)notifyPos, (IBlockState)iblockstate);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setBlockState(IMixinWorldServer mixinWorld, BlockPos pos, IBlockState newState, BlockChangeFlag flag) {
        boolean isComplete;
        if (!SpongeImplHooks.isMainThread()) {
            new PrettyPrinter(60).add("Illegal Async Block Change").centre().hr().addWrapped(ASYNC_BLOCK_CHANGE_MESSAGE, new Object[0]).add().add(" %s : %s", "World", mixinWorld).add(" %s : %d, %d, %d", "Block Pos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).add(" %s : %s", "BlockState", newState).add().addWrapped("Sponge is not going to allow this block change to take place as doing so can lead to further issues, not just with sponge or plugins, but other mods as well.", new Object[0]).add().add(new Exception("Async Block Change Detected")).log(SpongeImpl.getLogger(), Level.ERROR);
            return false;
        }
        SpongeBlockChangeFlag spongeFlag = (SpongeBlockChangeFlag)flag;
        WorldServer minecraftWorld = WorldUtil.asNative(mixinWorld);
        Chunk chunk = minecraftWorld.func_175726_f(pos);
        if (chunk.func_76621_g()) {
            return false;
        }
        Block block = newState.func_177230_c();
        IBlockState currentState = chunk.func_177435_g(pos);
        if (currentState == newState) {
            return false;
        }
        PhaseData phaseData = this.stack.peek();
        IPhaseState<?> phaseState = phaseData.state;
        PhaseContext<?> context = phaseData.context;
        boolean bl = isComplete = phaseState == GeneralPhase.State.COMPLETE;
        if (isComplete && SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            this.printUnexpectedBlockChange(mixinWorld, pos, currentState, newState);
        }
        if (phaseState.doesBulkBlockCapture(context)) {
            try {
                return TrackingUtil.captureBulkBlockChange(mixinWorld, chunk, currentState, newState, pos, flag, context, phaseState);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.printBlockTrackingException(phaseData, phaseState, e);
                return false;
            }
        }
        if (phaseState.doesBlockEventTracking(context)) {
            try {
                SpongeBlockChangeFlag spongeFlag1 = (SpongeBlockChangeFlag)flag;
                Block block1 = newState.func_177230_c();
                if (!ShouldFire.CHANGE_BLOCK_EVENT) {
                    IBlockState iblockstate = ((IMixinChunk)chunk).setBlockState(pos, newState, chunk.func_177435_g(pos), null, flag);
                    if (iblockstate == null) {
                        return false;
                    }
                    if (newState.func_185891_c() != iblockstate.func_185891_c() || newState.func_185906_d() != iblockstate.func_185906_d()) {
                        minecraftWorld.field_72984_F.func_76320_a("checkLight");
                        minecraftWorld.func_175664_x(pos);
                        minecraftWorld.field_72984_F.func_76319_b();
                    }
                    if (spongeFlag1.isNotifyClients() && chunk.func_150802_k()) {
                        minecraftWorld.func_184138_a(pos, iblockstate, newState, spongeFlag1.getRawFlag());
                    }
                    if (flag.updateNeighbors()) {
                        minecraftWorld.func_175722_b(pos, iblockstate.func_177230_c(), true);
                        if (!newState.func_185912_n()) return true;
                        minecraftWorld.func_175666_e(pos, block1);
                        return true;
                    }
                    if (!flag.notifyObservers()) return true;
                    minecraftWorld.func_190522_c(pos, block1);
                    return true;
                }
                SpongeBlockSnapshot originalBlockSnapshot = mixinWorld.createSpongeBlockSnapshot(currentState, currentState, pos, flag);
                ArrayList<BlockSnapshot> capturedSnapshots = new ArrayList<BlockSnapshot>(1);
                Block newBlock = newState.func_177230_c();
                TrackingUtil.associateBlockChangeWithSnapshot(phaseState, newBlock, currentState, originalBlockSnapshot, capturedSnapshots);
                IMixinChunk mixinChunk = (IMixinChunk)chunk;
                IBlockState originalBlockState = mixinChunk.setBlockState(pos, newState, currentState, originalBlockSnapshot, BlockChangeFlags.ALL);
                if (originalBlockState == null) {
                    return false;
                }
                Transaction<BlockSnapshot> transaction = TrackingUtil.TRANSACTION_CREATION.apply(originalBlockSnapshot);
                ImmutableList transactions = ImmutableList.of(transaction);
                ChangeBlockEvent normalEvent = originalBlockSnapshot.blockChange.createEvent(Sponge.getCauseStackManager().getCurrentCause(), (ImmutableList<Transaction<BlockSnapshot>>)transactions);
                try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                    phaseState.associateAdditionalCauses(context, frame);
                    SpongeImpl.postEvent(normalEvent);
                    frame.pushCause(normalEvent);
                    ChangeBlockEvent.Post post = phaseState.createChangeBlockPostEvent(context, (ImmutableList<Transaction<BlockSnapshot>>)transactions);
                    SpongeImpl.postEvent(post);
                    if (!transaction.isValid()) {
                        transaction.getOriginal().restore(true, BlockChangeFlags.NONE);
                        if (phaseState.tracksBlockSpecificDrops(context)) {
                            context.getBlockDropSupplier().removeAllIfNotEmpty(pos);
                        }
                        boolean bl22 = false;
                        return bl22;
                    }
                    boolean bl2 = TrackingUtil.performTransactionProcess(transaction, phaseState, context, true, 0);
                    return bl2;
                }
            }
            catch (Exception | NoClassDefFoundError e) {
                this.printBlockTrackingException(phaseData, phaseState, e);
                return false;
            }
        }
        IBlockState iblockstate = ((IMixinChunk)chunk).setBlockState(pos, newState, currentState, null, flag);
        if (iblockstate == null) {
            return false;
        }
        if (newState.func_185891_c() != iblockstate.func_185891_c() || newState.func_185906_d() != iblockstate.func_185906_d()) {
            minecraftWorld.field_72984_F.func_76320_a("checkLight");
            minecraftWorld.func_175664_x(pos);
            minecraftWorld.field_72984_F.func_76319_b();
        }
        if (spongeFlag.isNotifyClients() && chunk.func_150802_k()) {
            minecraftWorld.func_184138_a(pos, iblockstate, newState, spongeFlag.getRawFlag());
        }
        if (spongeFlag.updateNeighbors()) {
            minecraftWorld.func_175722_b(pos, iblockstate.func_177230_c(), true);
            if (!newState.func_185912_n()) return true;
            minecraftWorld.func_175666_e(pos, block);
            return true;
        }
        if (!spongeFlag.notifyObservers()) return true;
        minecraftWorld.func_190522_c(pos, block);
        return true;
    }

    public boolean spawnEntity(World world, Entity entity) {
        User user;
        EntityThrowable throwable;
        EntityLivingBase thrower;
        boolean isForced;
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null!");
        if (entity instanceof EntityItem && SpongeImplHooks.isRestoringBlocks((net.minecraft.world.World)world)) {
            return false;
        }
        if (((IMixinEntity)entity).isInConstructPhase()) {
            ((IMixinEntity)entity).firePostConstructEvents();
        }
        net.minecraft.entity.Entity minecraftEntity = EntityUtil.toNative(entity);
        WorldServer minecraftWorld = (WorldServer)world;
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)minecraftWorld;
        PhaseData phaseData = this.stack.peek();
        IPhaseState<?> phaseState = phaseData.state;
        PhaseContext<?> context = phaseData.context;
        boolean bl = isForced = minecraftEntity.field_98038_p || minecraftEntity instanceof EntityPlayer;
        if (!isForced && !phaseState.doesAllowEntitySpawns()) {
            return false;
        }
        int chunkX = MathHelper.func_76128_c((double)(minecraftEntity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(minecraftEntity.field_70161_v / 16.0));
        if (!isForced && !mixinWorldServer.isMinecraftChunkLoaded(chunkX, chunkZ, true)) {
            return false;
        }
        if (minecraftEntity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)minecraftEntity;
            minecraftWorld.field_73010_i.add(entityplayer);
            minecraftWorld.func_72854_c();
            SpongeImplHooks.firePlayerJoinSpawnEvent((EntityPlayerMP)entityplayer);
        } else if (minecraftEntity instanceof IEntityOwnable) {
            IEntityOwnable ownable = (IEntityOwnable)entity;
            net.minecraft.entity.Entity owner = ownable.func_70902_q();
            if (owner instanceof EntityPlayer) {
                context.owner = (User)owner;
                entity.setCreator(ownable.func_184753_b());
            }
        } else if (minecraftEntity instanceof EntityThrowable && (thrower = (throwable = (EntityThrowable)minecraftEntity).func_85052_h()) != null && (user = !(thrower instanceof EntityPlayer) ? (User)((IMixinEntity)thrower).getCreatorUser().orElse(null) : (User)thrower) != null) {
            context.owner = user;
            entity.setCreator(user.getUniqueId());
        }
        if (!isForced && (ShouldFire.SPAWN_ENTITY_EVENT || ShouldFire.CHANGE_BLOCK_EVENT && phaseState.doesBulkBlockCapture(context) && phaseState.tracksBlockSpecificDrops(context) && context.getCaptureBlockPos().getPos().isPresent())) {
            try {
                return phaseState.spawnEntityOrCapture(context, entity, chunkX, chunkZ);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.printExceptionSpawningEntity(context, e);
                return false;
            }
        }
        minecraftWorld.func_72964_e(chunkX, chunkZ).func_76612_a(minecraftEntity);
        minecraftWorld.field_72996_f.add(minecraftEntity);
        mixinWorldServer.onSpongeEntityAdded(minecraftEntity);
        return true;
    }

    public boolean spawnEntityWithCause(World world, Entity entity) {
        boolean isForced;
        Preconditions.checkNotNull((Object)entity, (Object)"Entity cannot be null!");
        if (((IMixinEntity)entity).isInConstructPhase()) {
            ((IMixinEntity)entity).firePostConstructEvents();
        }
        net.minecraft.entity.Entity minecraftEntity = EntityUtil.toNative(entity);
        WorldServer worldServer = (WorldServer)world;
        IMixinWorldServer mixinWorldServer = (IMixinWorldServer)worldServer;
        int chunkX = MathHelper.func_76128_c((double)(minecraftEntity.field_70165_t / 16.0));
        int chunkZ = MathHelper.func_76128_c((double)(minecraftEntity.field_70161_v / 16.0));
        boolean bl = isForced = minecraftEntity.field_98038_p || minecraftEntity instanceof EntityPlayer;
        if (!isForced && !mixinWorldServer.isMinecraftChunkLoaded(chunkX, chunkZ, true)) {
            return false;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        SpawnEntityEvent.Custom event = SpongeEventFactory.createSpawnEntityEventCustom(Sponge.getCauseStackManager().getCurrentCause(), entities);
        SpongeImpl.postEvent(event);
        if (entity instanceof EntityPlayer || !event.isCancelled()) {
            EntityUtil.processEntitySpawn(entity, Optional::empty);
        }
        return true;
    }

    public static boolean isEntitySpawnInvalid(Entity entity) {
        if (Sponge.isServerAvailable() && (Sponge.getServer().isMainThread() || SpongeImpl.getServer().func_71241_aa())) {
            return false;
        }
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().captureEntitiesAsync()) {
            if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
                return true;
            }
            if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().verboseErrors() && PhaseTracker.getInstance().hasPrintedAsyncEntities) {
                return true;
            }
            new PrettyPrinter(60).add("Async Entity Spawn Warning").centre().hr().add("An entity was attempting to spawn off the \"main\" server thread").add().add("Details of the spawning are disabled according to the Sponge").add("configuration file. A stack trace of the attempted spawn should").add("provide information about how it was being spawned. Sponge is").add("currently configured to NOT attempt to capture this spawn and").add("spawn the entity at an appropriate time, while on the main server").add("thread.").add().add("Details of the spawn:").add("%s : %s", "Entity", entity).add("Stacktrace").add(new Exception("Async entity spawn attempt")).trace(SpongeImpl.getLogger(), Level.WARN);
            PhaseTracker.getInstance().hasPrintedAsyncEntities = true;
            return true;
        }
        ASYNC_CAPTURED_ENTITIES.add((net.minecraft.entity.Entity)entity);
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().isVerbose()) {
            return true;
        }
        if (!SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker().verboseErrors() && PhaseTracker.getInstance().hasPrintedAsyncEntities) {
            return true;
        }
        new PrettyPrinter(60).add("Async Entity Spawn Warning").centre().hr().add("An entity was attempting to spawn off the \"main\" server thread").add().add("Delayed spawning is ENABLED for Sponge.").add("The entity is safely captured by Sponge while off the main").add("server thread, and therefore will be spawned the next tick.").add("Some cases where a mod is expecting the entity back while").add("async can cause issues with said mod.").add().add("Details of the spawn:").add("%s : %s", "Entity", entity).add("Stacktrace").add(new Exception("Async entity spawn attempt")).trace(SpongeImpl.getLogger(), Level.WARN);
        PhaseTracker.getInstance().hasPrintedAsyncEntities = true;
        return true;
    }

    public static boolean checkMaxBlockProcessingDepth(IPhaseState<?> state, PhaseContext<?> context, int currentDepth) {
        PhaseTrackerCategory trackerConfig = SpongeImpl.getGlobalConfig().getConfig().getPhaseTracker();
        int maxDepth = trackerConfig.getMaxBlockProcessingDepth();
        if (currentDepth < maxDepth) {
            return false;
        }
        PhaseTracker tracker = PhaseTracker.getInstance();
        if (!trackerConfig.isVerbose() && tracker.printedExceptionForMaximumProcessDepth.contains(state)) {
            return true;
        }
        tracker.printedExceptionForMaximumProcessDepth.add(state);
        String message = String.format("Sponge is still trying to process captured blocks after %s iterations of depth-first processing. This is likely due to a mod doing something unusual.", currentDepth);
        tracker.printMessageWithCaughtException("Maximum block processing depth exceeded!", message, state, context, null);
        return true;
    }
}

