/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Consumer;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;

final class PhaseStack {
    private static final PhaseData EMPTY_DATA = new PhaseData(PhaseContext.empty(), GeneralPhase.State.COMPLETE);
    private static final int DEFAULT_QUEUE_SIZE = 16;
    private final Deque<PhaseData> phases;

    PhaseStack() {
        this(16);
    }

    private PhaseStack(int size) {
        this.phases = new ArrayDeque<PhaseData>(size);
    }

    PhaseData peek() {
        PhaseData phase = this.phases.peek();
        return phase == null ? EMPTY_DATA : phase;
    }

    IPhaseState<?> peekState() {
        PhaseData peek = this.phases.peek();
        return peek == null ? GeneralPhase.State.COMPLETE : peek.state;
    }

    PhaseContext<?> peekContext() {
        PhaseData peek = this.phases.peek();
        return peek == null ? PhaseContext.empty() : peek.context;
    }

    PhaseData pop() {
        return this.phases.pop();
    }

    private PhaseStack push(PhaseData tuple) {
        Preconditions.checkNotNull((Object)tuple, (Object)"Tuple cannot be null!");
        Preconditions.checkArgument((boolean)tuple.context.isComplete(), (String)"Phase context must be complete: %s", (Object)tuple);
        this.phases.push(tuple);
        return this;
    }

    PhaseStack push(IPhaseState<?> state, PhaseContext<?> context) {
        return this.push(new PhaseData(context, state));
    }

    public void forEach(Consumer<PhaseData> consumer) {
        this.phases.forEach(consumer);
    }

    public boolean isEmpty() {
        return this.phases.isEmpty();
    }

    public int size() {
        return this.phases.size();
    }

    public int hashCode() {
        return Objects.hash(this.phases);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PhaseStack other = (PhaseStack)obj;
        return Objects.equals(this.phases, other.phases);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("phases", this.phases).toString();
    }

    boolean checkForRunaways(IPhaseState<?> state) {
        if (!state.isNotReEntrant()) {
            return false;
        }
        int totalCount = this.phases.size();
        IPhaseState[] allStates = new IPhaseState[totalCount];
        int i = 0;
        for (PhaseData data : this.phases) {
            allStates[i++] = data.state;
        }
        for (int index = 0; index < allStates.length; ++index) {
            if (index >= allStates.length - 1 || allStates[index] != allStates[index + 1] || allStates[index] != state) continue;
            return true;
        }
        return false;
    }
}

