/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.NeighborNotificationContext;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.WorldUtil;

public interface IPhaseState<C extends PhaseContext<C>> {
    public static final BiConsumer<CauseStackManager.StackFrame, ? extends PhaseContext<?>> DEFAULT_OWNER_NOTIFIER = (frame, ctx) -> {
        if (ctx.usedFrame == null) {
            ctx.usedFrame = new ArrayDeque<CauseStackManager.StackFrame>();
        }
        ctx.usedFrame.push((CauseStackManager.StackFrame)frame);
        if (ctx.owner != null) {
            frame.addContext(EventContextKeys.OWNER, ctx.owner);
        }
        if (ctx.notifier != null) {
            frame.addContext(EventContextKeys.NOTIFIER, ctx.notifier);
        }
    };

    public TrackingPhase getPhase();

    public C createPhaseContext();

    default public BiConsumer<CauseStackManager.StackFrame, C> getFrameModifier() {
        return DEFAULT_OWNER_NOTIFIER;
    }

    default public boolean canSwitchTo(IPhaseState<?> state) {
        return false;
    }

    default public boolean isNotReEntrant() {
        return true;
    }

    default public boolean isInteraction() {
        return false;
    }

    default public boolean isTicking() {
        return false;
    }

    default public boolean isWorldGeneration() {
        return false;
    }

    default public boolean isEvent() {
        return false;
    }

    public void unwind(C var1);

    default public boolean spawnEntityOrCapture(C context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        entities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    default public boolean spawnItemOrCapture(C phaseContext, Entity entity, EntityItem entityitem) {
        if (this.doesCaptureEntityDrops(phaseContext)) {
            if (this.tracksEntitySpecificDrops()) {
                SpongeImplHooks.capturePerEntityItemDrop(phaseContext, entity, entityitem);
            } else {
                ((PhaseContext)phaseContext).getCapturedItemsSupplier().get().add(entityitem);
            }
            return true;
        }
        return false;
    }

    default public void performOnBlockAddedSpawns(C context, int depth) {
    }

    default public void performPostBlockNotificationsAndNeighborUpdates(C context, int currentDepth) {
    }

    default public ChangeBlockEvent.Post createChangeBlockPostEvent(C context, ImmutableList<Transaction<BlockSnapshot>> transactions) {
        return SpongeEventFactory.createChangeBlockEventPost(Sponge.getCauseStackManager().getCurrentCause(), transactions);
    }

    default public void postBlockTransactionApplication(BlockChange blockChange, Transaction<BlockSnapshot> snapshotTransaction, C context) {
    }

    default public void postTrackBlock(BlockSnapshot snapshot, C context) {
    }

    default public void postProcessSpawns(C unwindingContext, ArrayList<org.spongepowered.api.entity.Entity> entities) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            SpongeCommonEventFactory.callSpawnEntity(entities, unwindingContext);
        }
    }

    default public boolean tracksOwnersAndNotifiers() {
        return false;
    }

    default public boolean tracksBlockSpecificDrops(C context) {
        return false;
    }

    default public boolean tracksEntitySpecificDrops() {
        return false;
    }

    default public boolean tracksEntityDeaths() {
        return false;
    }

    default public boolean doesCaptureEntityDrops(C context) {
        return false;
    }

    default public boolean doesAllowEntitySpawns() {
        return true;
    }

    default public boolean doesBulkBlockCapture(C context) {
        return true;
    }

    default public boolean doesDenyChunkRequests() {
        return false;
    }

    default public boolean doesCaptureEntitySpawns() {
        return false;
    }

    default public boolean doesBlockEventTracking(C context) {
        return true;
    }

    default public boolean doesDropEventTracking(C context) {
        return true;
    }

    default public boolean ignoresEntityCollisions() {
        return false;
    }

    default public boolean ignoresBlockEvent() {
        return false;
    }

    default public boolean ignoresBlockUpdateTick(C context) {
        return false;
    }

    default public boolean ignoresScheduledUpdates() {
        return false;
    }

    default public boolean ignoresItemPreMerging() {
        return false;
    }

    default public boolean shouldCaptureBlockChangeOrSkip(C phaseContext, BlockPos pos) {
        return true;
    }

    default public boolean alreadyCapturingBlockTicks(C context) {
        return false;
    }

    default public boolean alreadyCapturingEntitySpawns() {
        return false;
    }

    default public boolean alreadyCapturingEntityTicks() {
        return false;
    }

    default public boolean alreadyCapturingTileTicks() {
        return false;
    }

    default public boolean alreadyProcessingBlockItemDrops() {
        return false;
    }

    default public boolean requiresBlockPosTracking() {
        return false;
    }

    default public boolean requiresPost() {
        return true;
    }

    default public boolean handlesOwnStateCompletion() {
        return false;
    }

    default public void associateAdditionalCauses(PhaseContext<?> context, CauseStackManager.StackFrame frame) {
        context.applyOwnerIfAvailable(owner -> frame.addContext(EventContextKeys.OWNER, owner));
        context.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
    }

    default public void associateNeighborStateNotifier(C unwindingContext, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
    }

    default public void appendContextPreExplosion(ExplosionContext explosionContext, C currentPhaseData) {
    }

    default public void appendNotifierPreBlockTick(IMixinWorldServer mixinWorld, BlockPos pos, C context, BlockTickContext phaseContext) {
        Chunk chunk = WorldUtil.asNative(mixinWorld).func_175726_f(pos);
        IMixinChunk mixinChunk = (IMixinChunk)chunk;
        if (chunk != null && !chunk.func_76621_g()) {
            mixinChunk.getBlockOwner(pos).ifPresent(phaseContext::owner);
            mixinChunk.getBlockNotifier(pos).ifPresent(phaseContext::notifier);
        }
    }

    default public void appendNotifierToBlockEvent(C context, IMixinWorldServer mixinWorldServer, BlockPos pos, IMixinBlockEventData blockEvent) {
    }

    default public void capturePlayerUsingStackToBreakBlock(ItemStack itemStack, EntityPlayerMP playerIn, C context) {
    }

    default public void provideNotifierForNeighbors(C context, NeighborNotificationContext notification) {
        if (((PhaseContext)context).notifier != null) {
            notification.notifier(((PhaseContext)context).notifier);
            return;
        }
        if (((PhaseContext)context).owner != null) {
            notification.notifier(((PhaseContext)context).owner);
        }
    }

    default public boolean allowsEventListener() {
        return true;
    }
}

