/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.damage;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import net.minecraft.entity.item.EntityFallingBlock;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFallingBlockData;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.common.event.damage.MinecraftFallingBlockDamageSource;

public class SpongeFallingBlockDamgeSourceBuilder
extends AbstractDamageSourceBuilder<FallingBlockDamageSource, FallingBlockDamageSource.Builder>
implements FallingBlockDamageSource.Builder {
    protected WeakReference<Entity> reference = null;
    private ImmutableFallingBlockData blockData = null;

    @Override
    public SpongeFallingBlockDamgeSourceBuilder fallingBlock(ImmutableFallingBlockData fallingBlock) {
        this.blockData = fallingBlock;
        return this;
    }

    @Override
    public SpongeFallingBlockDamgeSourceBuilder entity(Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof FallingBlock));
        this.reference = new WeakReference<Entity>(entity);
        return this;
    }

    @Override
    public FallingBlockDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.reference.get() != null ? 1 : 0) != 0);
        Preconditions.checkState((this.blockData != null ? 1 : 0) != 0);
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0);
        MinecraftFallingBlockDamageSource damageSource = new MinecraftFallingBlockDamageSource(this.damageType.getId(), (EntityFallingBlock)this.reference.get(), this.blockData);
        if (this.creative) {
            damageSource.func_76359_i();
        }
        if (this.scales) {
            damageSource.func_76351_m();
        }
        if (this.magical) {
            damageSource.func_82726_p();
        }
        if (this.bypasses) {
            damageSource.func_76348_h();
        }
        if (this.absolute) {
            damageSource.func_151518_m();
        }
        if (this.explosion) {
            damageSource.func_94540_d();
        }
        if (this.exhaustion != null) {
            damageSource.field_76384_q = this.exhaustion.floatValue();
        }
        return (FallingBlockDamageSource)((Object)damageSource);
    }

    @Override
    public FallingBlockDamageSource.Builder from(FallingBlockDamageSource value) {
        super.from(value);
        this.reference = new WeakReference<FallingBlock>(value.getSource());
        this.blockData = value.getFallingBlockData();
        return this;
    }

    @Override
    public SpongeFallingBlockDamgeSourceBuilder reset() {
        super.reset();
        this.reference = null;
        this.blockData = null;
        return this;
    }
}

