/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.damage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.damage.DamageObject;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public class DamageEventHandler {
    public static final DoubleUnaryOperator HARD_HAT_FUNCTION = damage -> -(damage - damage * 0.75);
    public static final DoubleUnaryOperator BLOCKING_FUNCTION = damage -> -(damage - (1.0 + damage) * 0.5);
    private static double damageToHandle;
    private static double enchantmentDamageTracked;

    public static DoubleUnaryOperator createResistanceFunction(int resistanceAmplifier) {
        int base = (resistanceAmplifier + 1) * 5;
        int modifier = 25 - base;
        return damage -> -(damage - damage * (double)modifier / 25.0);
    }

    public static Optional<DamageFunction> createHardHatModifier(EntityLivingBase entityLivingBase, DamageSource damageSource) {
        if (damageSource instanceof FallingBlockDamageSource && !entityLivingBase.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), ((ItemStack)entityLivingBase.func_184582_a(EntityEquipmentSlot.HEAD)).createSnapshot())).type(DamageModifierTypes.HARD_HAT).build();
            return Optional.of(new DamageFunction(modifier, HARD_HAT_FUNCTION));
        }
        return Optional.empty();
    }

    public static Optional<List<DamageFunction>> createArmorModifiers(EntityLivingBase entityLivingBase, DamageSource damageSource, double damage) {
        if (!damageSource.func_76363_c()) {
            DamageObject object;
            damage *= 25.0;
            net.minecraft.item.ItemStack[] inventory = (net.minecraft.item.ItemStack[])Iterables.toArray((Iterable)entityLivingBase.func_184193_aE(), net.minecraft.item.ItemStack.class);
            ArrayList<DamageFunction> modifiers = new ArrayList<DamageFunction>();
            ArrayList<DamageObject> damageObjects = new ArrayList<DamageObject>();
            for (int index = 0; index < inventory.length; ++index) {
                Item item;
                net.minecraft.item.ItemStack itemStack = inventory[index];
                if (itemStack.func_190926_b() || !((item = itemStack.func_77973_b()) instanceof ItemArmor)) continue;
                ItemArmor armor = (ItemArmor)item;
                double reduction = (double)armor.field_77879_b / 25.0;
                object = new DamageObject();
                object.slot = index;
                object.ratio = reduction;
                damageObjects.add(object);
            }
            boolean first = true;
            double ratio = 0.0;
            for (DamageObject prop : damageObjects) {
                EquipmentType type = DamageEventHandler.resolveEquipment(prop.slot);
                object = new DamageObject();
                object.ratio = ratio;
                if (first) {
                    object.previousDamage = damage;
                    object.augment = true;
                }
                DoubleUnaryOperator function = incomingDamage -> {
                    double functionDamage;
                    incomingDamage *= 25.0;
                    if (object.augment) {
                        damageToHandle = incomingDamage;
                    }
                    object.previousDamage = functionDamage = damageToHandle;
                    object.ratio = prop.ratio;
                    object.ratio += prop.ratio;
                    return -(functionDamage * prop.ratio / 25.0);
                };
                ratio += prop.ratio;
                DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), ((ItemStack)inventory[prop.slot]).createSnapshot(), prop, object)).type(DamageModifierTypes.ARMOR).build();
                modifiers.add(new DamageFunction(modifier, function));
                first = false;
            }
            if (!modifiers.isEmpty()) {
                return Optional.of(modifiers);
            }
        }
        return Optional.empty();
    }

    public static void acceptArmorModifier(EntityLivingBase entity, DamageSource damageSource, DamageModifier modifier, double damage) {
        Optional<DamageObject> property = modifier.getCause().first(DamageObject.class);
        Iterable inventory = entity.func_184193_aE();
        if (property.isPresent()) {
            damage = Math.abs(damage) * 25.0;
            net.minecraft.item.ItemStack stack = (net.minecraft.item.ItemStack)Iterables.get((Iterable)inventory, (int)property.get().slot);
            if (stack.func_190926_b()) {
                throw new IllegalStateException("Invalid slot position " + property.get().slot);
            }
            int itemDamage = (int)(damage / 25.0 < 1.0 ? 1.0 : damage / 25.0);
            stack.func_77972_a(itemDamage, entity);
        }
    }

    public static EquipmentType resolveEquipment(int slot) {
        if (slot == 0) {
            return EquipmentTypes.BOOTS;
        }
        if (slot == 1) {
            return EquipmentTypes.LEGGINGS;
        }
        if (slot == 2) {
            return EquipmentTypes.CHESTPLATE;
        }
        if (slot == 3) {
            return EquipmentTypes.HEADWEAR;
        }
        return EquipmentTypes.WORN;
    }

    public static Optional<DamageFunction> createResistanceModifier(EntityLivingBase entityLivingBase, DamageSource damageSource) {
        if (!damageSource.func_151517_h() && entityLivingBase.func_70644_a(MobEffects.field_76429_m) && damageSource != DamageSource.field_76380_i) {
            PotionEffect effect = (PotionEffect)entityLivingBase.func_70660_b(MobEffects.field_76429_m);
            return Optional.of(new DamageFunction(DamageModifier.builder().cause(Cause.of(EventContext.empty(), effect)).type(DamageModifierTypes.DEFENSIVE_POTION_EFFECT).build(), DamageEventHandler.createResistanceFunction(effect.getAmplifier())));
        }
        return Optional.empty();
    }

    public static Optional<List<DamageFunction>> createEnchantmentModifiers(EntityLivingBase entityLivingBase, DamageSource damageSource) {
        if (!damageSource.func_151517_h()) {
            Iterable inventory = entityLivingBase.func_184193_aE();
            if (EnchantmentHelper.func_77508_a((Iterable)Lists.newArrayList((Iterable)entityLivingBase.func_184193_aE()), (DamageSource)damageSource) == 0) {
                return Optional.empty();
            }
            ArrayList<DamageFunction> modifiers = new ArrayList<DamageFunction>();
            boolean first = true;
            int totalModifier = 0;
            for (net.minecraft.item.ItemStack itemStack : inventory) {
                if (itemStack.func_190926_b()) continue;
                LinkedHashMultimap enchantments = LinkedHashMultimap.create();
                NBTTagList enchantmentList = itemStack.func_77986_q();
                if (enchantmentList == null) continue;
                for (int i = 0; i < enchantmentList.func_74745_c(); ++i) {
                    Enchantment enchantment;
                    int temp;
                    short enchantmentId = enchantmentList.func_150305_b(i).func_74765_d("id");
                    short level = enchantmentList.func_150305_b(i).func_74765_d("lvl");
                    if (Enchantment.func_185262_c((int)enchantmentId) == null || (temp = (enchantment = Enchantment.func_185262_c((int)enchantmentId)).func_77318_a((int)level, damageSource)) == 0) continue;
                    enchantments.put((Object)enchantment, (Object)level);
                }
                ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(itemStack);
                for (Map.Entry enchantment : enchantments.asMap().entrySet()) {
                    DamageObject object = new DamageObject();
                    int modifierTemp = 0;
                    Iterator iterator = ((Collection)enchantment.getValue()).iterator();
                    while (iterator.hasNext()) {
                        short level = (Short)iterator.next();
                        modifierTemp += ((Enchantment)enchantment.getKey()).func_77318_a((int)level, damageSource);
                    }
                    int modifier = modifierTemp;
                    object.previousDamage = totalModifier;
                    if (object.previousDamage > 25.0) {
                        object.previousDamage = 25.0;
                    }
                    totalModifier += modifier;
                    object.augment = first;
                    object.ratio = modifier;
                    DoubleUnaryOperator enchantmentFunction = damageIn -> {
                        if (object.augment) {
                            enchantmentDamageTracked = damageIn;
                        }
                        if (damageIn <= 0.0) {
                            return 0.0;
                        }
                        double actualDamage = enchantmentDamageTracked;
                        if (object.previousDamage > 25.0) {
                            return 0.0;
                        }
                        double modifierDamage = actualDamage;
                        if (modifier > 0 && modifier <= 20) {
                            int j = 25 - modifier;
                            double magicModifier = modifierDamage * (double)j;
                            modifierDamage = magicModifier / 25.0;
                        }
                        return -Math.max(actualDamage - modifierDamage, 0.0);
                    };
                    if (first) {
                        first = false;
                    }
                    DamageModifier enchantmentModifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), enchantment, snapshot, entityLivingBase)).type(DamageModifierTypes.ARMOR_ENCHANTMENT).build();
                    modifiers.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
                }
                if (modifiers.isEmpty()) continue;
                return Optional.of(modifiers);
            }
        }
        return Optional.empty();
    }

    public static Optional<DamageFunction> createAbsorptionModifier(EntityLivingBase entityLivingBase, DamageSource damageSource) {
        float absorptionAmount = entityLivingBase.func_110139_bj();
        if (absorptionAmount > 0.0f) {
            DoubleUnaryOperator function = damage -> -Math.max(damage - Math.max(damage - (double)absorptionAmount, 0.0), 0.0);
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), entityLivingBase)).type(DamageModifierTypes.ABSORPTION).build();
            return Optional.of(new DamageFunction(modifier, function));
        }
        return Optional.empty();
    }

    public static Location<World> findFirstMatchingBlock(net.minecraft.entity.Entity entity, AxisAlignedBB bb, Predicate<IBlockState> predicate) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(bb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(bb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(bb.field_72334_f + 1.0));
        IMixinChunkProviderServer spongeChunkProvider = (IMixinChunkProviderServer)entity.field_70170_p.func_72863_F();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    Chunk chunk = spongeChunkProvider.getLoadedChunkWithoutMarkingActive(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
                    if (chunk == null || !predicate.test(chunk.func_177435_g(blockPos))) continue;
                    return new Location<World>((World)entity.field_70170_p, k1, l1, i2);
                }
            }
        }
        return ((Entity)entity).getLocation();
    }

    public static void generateCauseFor(DamageSource damageSource, CauseStackManager.StackFrame frame) {
        if (damageSource instanceof EntityDamageSourceIndirect) {
            net.minecraft.entity.Entity source = damageSource.func_76346_g();
            if (!(source instanceof EntityPlayer) && source != null) {
                IMixinEntity mixinEntity = EntityUtil.toMixin(source);
                mixinEntity.getNotifierUser().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
                mixinEntity.getCreatorUser().ifPresent(owner -> frame.addContext(EventContextKeys.OWNER, owner));
            }
        } else if (damageSource instanceof EntityDamageSource) {
            net.minecraft.entity.Entity source = damageSource.func_76346_g();
            if (!(source instanceof EntityPlayer) && source != null) {
                IMixinEntity mixinEntity = EntityUtil.toMixin(source);
                mixinEntity.getNotifierUser().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
                mixinEntity.getCreatorUser().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            }
        } else if (damageSource instanceof BlockDamageSource) {
            Location<World> location = ((BlockDamageSource)damageSource).getLocation();
            BlockPos blockPos = VecHelper.toBlockPos(location);
            IMixinChunk mixinChunk = (IMixinChunk)((net.minecraft.world.World)location.getExtent()).func_175726_f(blockPos);
            mixinChunk.getBlockNotifier(blockPos).ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            mixinChunk.getBlockOwner(blockPos).ifPresent(owner -> frame.addContext(EventContextKeys.CREATOR, owner));
        }
        frame.pushCause(damageSource);
    }

    public static List<DamageFunction> createAttackEnchantmentFunction(net.minecraft.item.ItemStack heldItem, EnumCreatureAttribute creatureAttribute, float attackStrength) {
        LinkedHashMultimap enchantments = LinkedHashMultimap.create();
        ArrayList<DamageFunction> damageModifierFunctions = new ArrayList<DamageFunction>();
        if (!heldItem.func_190926_b()) {
            NBTTagList nbttaglist = heldItem.func_77986_q();
            if (nbttaglist.func_82582_d()) {
                return ImmutableList.of();
            }
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                short j = nbttaglist.func_150305_b(i).func_74765_d("id");
                short enchantmentLevel = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                Enchantment enchantment = Enchantment.func_185262_c((int)j);
                if (enchantment == null) continue;
                enchantments.put((Object)enchantment, (Object)enchantmentLevel);
            }
            if (enchantments.isEmpty()) {
                return ImmutableList.of();
            }
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(heldItem);
            for (Map.Entry enchantment : enchantments.asMap().entrySet()) {
                DamageModifier enchantmentModifier = DamageModifier.builder().type(DamageModifierTypes.WEAPON_ENCHANTMENT).cause(Cause.of(EventContext.empty(), snapshot, enchantment)).build();
                DoubleUnaryOperator enchantmentFunction = damage -> {
                    double totalDamage = 0.0;
                    Iterator iterator = ((Collection)enchantment.getValue()).iterator();
                    while (iterator.hasNext()) {
                        int level = (Integer)iterator.next();
                        totalDamage += (double)((Enchantment)enchantment.getKey()).func_152376_a(level, creatureAttribute) * (double)attackStrength;
                    }
                    return totalDamage;
                };
                damageModifierFunctions.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
            }
        }
        return damageModifierFunctions;
    }

    public static DamageFunction provideCriticalAttackTuple(EntityPlayer player) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.CRITICAL_HIT).build();
        DoubleUnaryOperator function = damage -> damage * 0.5;
        return new DamageFunction(modifier, function);
    }

    public static DamageFunction provideCooldownAttackStrengthFunction(EntityPlayer player, float attackStrength) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.ATTACK_COOLDOWN).build();
        DoubleUnaryOperator function = damage -> -damage + damage * (double)(0.2f + attackStrength * attackStrength * 0.8f);
        return new DamageFunction(modifier, function);
    }

    public static Optional<DamageFunction> createShieldFunction(EntityLivingBase entity, DamageSource source, float amount) {
        if (entity.func_184585_cz() && (double)amount > 0.0 && entity.func_184583_d(source)) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), entity, ((ItemStack)entity.func_184607_cu()).createSnapshot())).type(DamageModifierTypes.SHIELD).build();
            return Optional.of(new DamageFunction(modifier, damage -> -damage));
        }
        return Optional.empty();
    }
}

