/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property.store.block;

import java.util.Optional;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.data.property.block.IndirectlyPoweredProperty;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.data.property.store.common.AbstractSpongePropertyStore;
import org.spongepowered.common.util.VecHelper;

public class IndirectlyPoweredPropertyStore
extends AbstractSpongePropertyStore<IndirectlyPoweredProperty> {
    private static final IndirectlyPoweredProperty TRUE = new IndirectlyPoweredProperty(true);
    private static final IndirectlyPoweredProperty FALSE = new IndirectlyPoweredProperty(false);

    @Override
    public Optional<IndirectlyPoweredProperty> getFor(Location<World> location) {
        net.minecraft.world.World world = (net.minecraft.world.World)location.getExtent();
        boolean powered = world.func_175687_A(VecHelper.toBlockPos(location)) > 0;
        return Optional.of(powered ? TRUE : FALSE);
    }

    @Override
    public Optional<IndirectlyPoweredProperty> getFor(Location<World> location, Direction direction) {
        net.minecraft.world.World world = (net.minecraft.world.World)location.getExtent();
        EnumFacing facing = IndirectlyPoweredPropertyStore.toEnumFacing(direction);
        boolean powered = world.func_175651_c(VecHelper.toBlockPos(location).func_177972_a(facing), facing) > 0;
        return Optional.of(powered ? TRUE : FALSE);
    }
}

