/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.item.EntityBoat;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableTreeData;
import org.spongepowered.api.data.manipulator.mutable.block.TreeData;
import org.spongepowered.api.data.type.TreeType;
import org.spongepowered.api.data.type.TreeTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeTreeData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class BoatTreeTypeValueProcessor
extends AbstractEntitySingleDataProcessor<EntityBoat, TreeType, Value<TreeType>, TreeData, ImmutableTreeData> {
    public BoatTreeTypeValueProcessor() {
        super(EntityBoat.class, Keys.TREE_TYPE);
    }

    @Override
    protected TreeData createManipulator() {
        return new SpongeTreeData();
    }

    @Override
    protected boolean set(EntityBoat dataHolder, TreeType value) {
        if (value == TreeTypes.OAK) {
            dataHolder.func_184458_a(EntityBoat.Type.OAK);
        } else if (value == TreeTypes.SPRUCE) {
            dataHolder.func_184458_a(EntityBoat.Type.SPRUCE);
        } else if (value == TreeTypes.JUNGLE) {
            dataHolder.func_184458_a(EntityBoat.Type.JUNGLE);
        } else if (value == TreeTypes.DARK_OAK) {
            dataHolder.func_184458_a(EntityBoat.Type.DARK_OAK);
        } else if (value == TreeTypes.BIRCH) {
            dataHolder.func_184458_a(EntityBoat.Type.BIRCH);
        } else if (value == TreeTypes.ACACIA) {
            dataHolder.func_184458_a(EntityBoat.Type.ACACIA);
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected Optional<TreeType> getVal(EntityBoat dataHolder) {
        switch (dataHolder.func_184453_r()) {
            case OAK: {
                return Optional.of(TreeTypes.OAK);
            }
            case SPRUCE: {
                return Optional.of(TreeTypes.SPRUCE);
            }
            case BIRCH: {
                return Optional.of(TreeTypes.BIRCH);
            }
            case JUNGLE: {
                return Optional.of(TreeTypes.JUNGLE);
            }
            case ACACIA: {
                return Optional.of(TreeTypes.ACACIA);
            }
            case DARK_OAK: {
                return Optional.of(TreeTypes.DARK_OAK);
            }
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.successNoData();
    }

    @Override
    protected ImmutableValue<TreeType> constructImmutableValue(TreeType value) {
        return new ImmutableSpongeValue<TreeType>(this.key, value);
    }

    @Override
    protected Value<TreeType> constructValue(TreeType actualValue) {
        return new SpongeValue<TreeType>(this.key, actualValue);
    }
}

