/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableMovementSpeedData;
import org.spongepowered.api.data.manipulator.mutable.entity.MovementSpeedData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeMovementSpeedData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.processor.value.entity.WalkingSpeedValueProcessor;
import org.spongepowered.common.data.util.DataUtil;

public class MovementSpeedDataProcessor
extends AbstractEntityDataProcessor<EntityPlayer, MovementSpeedData, ImmutableMovementSpeedData> {
    public MovementSpeedDataProcessor() {
        super(EntityPlayer.class);
    }

    @Override
    protected boolean doesDataExist(EntityPlayer entity) {
        return true;
    }

    @Override
    protected boolean set(EntityPlayer entity, Map<Key<?>, Object> keyValues) {
        WalkingSpeedValueProcessor.setWalkSpeed(entity, (Double)keyValues.get(Keys.WALKING_SPEED));
        entity.field_71075_bZ.field_75096_f = ((Double)keyValues.get(Keys.FLYING_SPEED)).floatValue();
        entity.func_71016_p();
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityPlayer entity) {
        double walkSpeed = entity.field_71075_bZ.func_75094_b();
        double flySpeed = entity.field_71075_bZ.func_75093_a();
        return ImmutableMap.of(Keys.WALKING_SPEED, (Object)walkSpeed, Keys.FLYING_SPEED, (Object)flySpeed);
    }

    @Override
    protected MovementSpeedData createManipulator() {
        return new SpongeMovementSpeedData();
    }

    @Override
    public Optional<MovementSpeedData> fill(DataContainer container, MovementSpeedData movementSpeedData) {
        movementSpeedData.set(Keys.WALKING_SPEED, DataUtil.getData(container, Keys.WALKING_SPEED));
        movementSpeedData.set(Keys.FLYING_SPEED, DataUtil.getData(container, Keys.FLYING_SPEED));
        return Optional.of(movementSpeedData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

