/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableExperienceHolderData;
import org.spongepowered.api.data.manipulator.mutable.entity.ExperienceHolderData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeExperienceHolderData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;

public class ExperienceHolderDataProcessor
extends AbstractEntityDataProcessor<EntityPlayer, ExperienceHolderData, ImmutableExperienceHolderData> {
    public ExperienceHolderDataProcessor() {
        super(EntityPlayer.class);
    }

    @Override
    protected ExperienceHolderData createManipulator() {
        return new SpongeExperienceHolderData();
    }

    @Override
    protected boolean doesDataExist(EntityPlayer entity) {
        return true;
    }

    @Override
    protected boolean set(EntityPlayer entity, Map<Key<?>, Object> keyValues) {
        entity.field_71068_ca = (Integer)keyValues.get(Keys.EXPERIENCE_LEVEL);
        entity.field_71067_cb = (Integer)keyValues.get(Keys.TOTAL_EXPERIENCE);
        entity.field_71106_cc = (float)((Integer)keyValues.get(Keys.EXPERIENCE_SINCE_LEVEL)).intValue() / (float)entity.func_71050_bK();
        ((IMixinEntityPlayerMP)entity).refreshExp();
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityPlayer entity) {
        int level = entity.field_71068_ca;
        int totalExp = entity.field_71067_cb;
        int expSinceLevel = ((IMixinEntityPlayer)entity).getExperienceSinceLevel();
        int expBetweenLevels = entity.func_71050_bK();
        return ImmutableMap.of(Keys.EXPERIENCE_LEVEL, (Object)level, Keys.TOTAL_EXPERIENCE, (Object)totalExp, Keys.EXPERIENCE_SINCE_LEVEL, (Object)expSinceLevel, Keys.EXPERIENCE_FROM_START_OF_LEVEL, (Object)expBetweenLevels);
    }

    @Override
    public Optional<ExperienceHolderData> fill(DataContainer container, ExperienceHolderData experienceHolderData) {
        experienceHolderData.set(Keys.EXPERIENCE_LEVEL, DataUtil.getData(container, Keys.EXPERIENCE_LEVEL));
        experienceHolderData.set(Keys.TOTAL_EXPERIENCE, DataUtil.getData(container, Keys.TOTAL_EXPERIENCE));
        experienceHolderData.set(Keys.EXPERIENCE_SINCE_LEVEL, DataUtil.getData(container, Keys.EXPERIENCE_SINCE_LEVEL));
        return Optional.of(experienceHolderData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

