/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableDamageableData;
import org.spongepowered.api.data.manipulator.mutable.entity.DamageableData;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeDamageableData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.interfaces.entity.IMixinEntityLivingBase;

public class DamageableDataProcessor
extends AbstractEntityDataProcessor<EntityLivingBase, DamageableData, ImmutableDamageableData> {
    public DamageableDataProcessor() {
        super(EntityLivingBase.class);
    }

    @Override
    protected boolean doesDataExist(EntityLivingBase dataHolder) {
        return true;
    }

    @Override
    protected boolean set(EntityLivingBase dataHolder, Map<Key<?>, Object> keyValues) {
        Entity entity;
        Optional<Entity> optionalEntity;
        Optional lastAttacker = (Optional)keyValues.get(Keys.LAST_ATTACKER);
        if (lastAttacker == null || !lastAttacker.isPresent()) {
            dataHolder.func_70604_c(null);
            return true;
        }
        if (((EntitySnapshot)lastAttacker.get()).getUniqueId().isPresent() && (optionalEntity = ((EntitySnapshot)lastAttacker.get()).restore()).isPresent() && (entity = optionalEntity.get()).isLoaded() && entity instanceof EntityLivingBase) {
            dataHolder.func_70604_c((EntityLivingBase)entity);
            ((IMixinEntityLivingBase)dataHolder).setLastDamage(((Optional)keyValues.get(Keys.LAST_DAMAGE)).orElse(0.0));
            return true;
        }
        return false;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityLivingBase dataHolder) {
        EntitySnapshot snapshot = dataHolder.func_94060_bK() != null ? ((Entity)dataHolder.func_94060_bK()).createSnapshot() : null;
        return ImmutableMap.of(Keys.LAST_ATTACKER, Optional.ofNullable(snapshot), Keys.LAST_DAMAGE, Optional.ofNullable(dataHolder.func_94060_bK() == null ? null : Double.valueOf(((IMixinEntityLivingBase)dataHolder).getLastDamageTaken())));
    }

    @Override
    protected DamageableData createManipulator() {
        return new SpongeDamageableData();
    }

    @Override
    public Optional<DamageableData> fill(DataContainer container, DamageableData damageableData) {
        if (container.contains(Keys.LAST_DAMAGE)) {
            container.get(Keys.LAST_DAMAGE.getQuery()).ifPresent(o -> {
                DamageableData cfr_ignored_0 = (DamageableData)damageableData.set(Keys.LAST_DAMAGE, (Optional)o);
            });
        } else {
            damageableData.set(Keys.LAST_DAMAGE, Optional.empty());
        }
        if (container.contains(Keys.LAST_ATTACKER)) {
            container.get(Keys.LAST_ATTACKER.getQuery()).ifPresent(o -> {
                DamageableData cfr_ignored_0 = (DamageableData)damageableData.set(Keys.LAST_ATTACKER, (Optional)o);
            });
        } else {
            container.set(Keys.LAST_ATTACKER, (Object)Optional.empty());
        }
        return Optional.of(damageableData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

