/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableWetData;
import org.spongepowered.api.data.manipulator.mutable.WetData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.common.data.manipulator.mutable.SpongeWetData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class ItemWetDataProcessor
extends AbstractItemSingleDataProcessor<Boolean, Value<Boolean>, WetData, ImmutableWetData> {
    public ItemWetDataProcessor() {
        super((ItemStack item) -> item.func_77973_b().equals(ItemTypes.SPONGE), Keys.IS_WET);
    }

    @Override
    protected boolean set(ItemStack itemStack, Boolean value) {
        itemStack.func_77964_b(value != false ? 1 : 0);
        return true;
    }

    @Override
    protected Optional<Boolean> getVal(ItemStack itemStack) {
        return Optional.of(itemStack.func_77952_i() == 1);
    }

    @Override
    protected Value<Boolean> constructValue(Boolean actualValue) {
        return new SpongeValue<Boolean>(Keys.IS_WET, false, actualValue);
    }

    @Override
    protected ImmutableValue<Boolean> constructImmutableValue(Boolean value) {
        return ImmutableSpongeValue.cachedOf(Keys.IS_WET, false, value);
    }

    @Override
    protected WetData createManipulator() {
        return new SpongeWetData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

