/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableBlockItemData;
import org.spongepowered.api.data.manipulator.mutable.item.BlockItemData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeBlockItemData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class BlockItemDataProcessor
extends AbstractItemSingleDataProcessor<BlockState, Value<BlockState>, BlockItemData, ImmutableBlockItemData> {
    public BlockItemDataProcessor() {
        super((ItemStack stack) -> stack.func_77973_b() instanceof ItemBlock, Keys.ITEM_BLOCKSTATE);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean set(ItemStack stack, BlockState value) {
        IBlockState blockState = (IBlockState)value;
        Block baseBlock = blockState.func_177230_c();
        if (Block.func_149634_a((Item)stack.func_77973_b()) != baseBlock) {
            return false;
        }
        stack.func_77964_b(baseBlock.func_180651_a(blockState));
        return true;
    }

    @Override
    protected Optional<BlockState> getVal(ItemStack stack) {
        Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
        int blockMeta = stack.func_77973_b().func_77647_b(stack.func_77952_i());
        return Optional.of((BlockState)block.func_176203_a(blockMeta));
    }

    @Override
    protected Value<BlockState> constructValue(BlockState actualValue) {
        return new SpongeValue<BlockState>(Keys.ITEM_BLOCKSTATE, DataConstants.Catalog.DEFAULT_BLOCK_STATE, actualValue);
    }

    @Override
    protected ImmutableValue<BlockState> constructImmutableValue(BlockState value) {
        return new ImmutableSpongeValue<BlockState>(Keys.ITEM_BLOCKSTATE, DataConstants.Catalog.DEFAULT_BLOCK_STATE, value);
    }

    @Override
    protected BlockItemData createManipulator() {
        return new SpongeBlockItemData();
    }
}

