/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.extra;

import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.extra.fluid.FluidStackSnapshot;
import org.spongepowered.api.extra.fluid.FluidTypes;
import org.spongepowered.api.extra.fluid.data.manipulator.immutable.ImmutableFluidItemData;
import org.spongepowered.api.extra.fluid.data.manipulator.mutable.FluidItemData;
import org.spongepowered.common.data.manipulator.mutable.extra.SpongeFluidItemData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.extra.fluid.SpongeFluidStackBuilder;
import org.spongepowered.common.extra.fluid.SpongeFluidStackSnapshot;

public class FluidItemDataProcessor
extends AbstractItemSingleDataProcessor<FluidStackSnapshot, Value<FluidStackSnapshot>, FluidItemData, ImmutableFluidItemData> {
    private static final FluidStackSnapshot WATER = new SpongeFluidStackBuilder().fluid(FluidTypes.WATER).volume(1000).build().createSnapshot();
    private static final FluidStackSnapshot LAVA = new SpongeFluidStackBuilder().fluid(FluidTypes.LAVA).volume(1000).build().createSnapshot();

    public FluidItemDataProcessor() {
        super((ItemStack item) -> item.func_77973_b() == Items.field_151133_ar || item.func_77973_b() == Items.field_151131_as || item.func_77973_b() == Items.field_151129_at, Keys.FLUID_ITEM_STACK);
    }

    @Override
    protected boolean set(ItemStack dataHolder, FluidStackSnapshot value) {
        return false;
    }

    @Override
    protected Optional<FluidStackSnapshot> getVal(ItemStack dataHolder) {
        if (dataHolder.func_77973_b() == Items.field_151131_as) {
            return Optional.of(WATER);
        }
        if (dataHolder.func_77973_b() == Items.field_151129_at) {
            return Optional.of(LAVA);
        }
        return Optional.empty();
    }

    @Override
    protected ImmutableValue<FluidStackSnapshot> constructImmutableValue(FluidStackSnapshot value) {
        return new ImmutableSpongeValue<FluidStackSnapshot>(Keys.FLUID_ITEM_STACK, SpongeFluidStackSnapshot.DEFAULT, value);
    }

    @Override
    protected Value<FluidStackSnapshot> constructValue(FluidStackSnapshot actualValue) {
        return new SpongeValue<FluidStackSnapshot>(Keys.FLUID_ITEM_STACK, SpongeFluidStackSnapshot.DEFAULT, actualValue);
    }

    @Override
    protected FluidItemData createManipulator() {
        return new SpongeFluidItemData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

